/*
 * Decompiled with CFR 0.152.
 */
package ordermate.hom.synchronisation;

import ordermate.database.misc.StoreGroup;
import ordermate.hom.synchronisation.IdTranslator;

public class LocalIdTranslator
implements IdTranslator {
    private static final long TEN_BILLION;
    public static final long STORE_RANGE;
    private static final long STARTING_POINT;
    private final long superMask;
    public static final long NON_TRANSLATABLE_ID = -1L;

    public LocalIdTranslator() {
        this(LocalIdTranslator.getSupermaskForStore(StoreGroup.getInstance().getStoreId() == null ? 0L : StoreGroup.getInstance().getStoreId()));
    }

    public LocalIdTranslator(long theSuperMask) {
        this.superMask = theSuperMask;
    }

    public static long getSupermaskForStore(long storeId) {
        return STARTING_POINT + 10L * STORE_RANGE * storeId;
    }

    public static long getStoreId(long rowId) {
        if ((rowId = Math.abs(rowId)) < STARTING_POINT || rowId >= STARTING_POINT * 2L) {
            return -1L;
        }
        String string = Long.toString(rowId);
        if (string.length() < 5) {
            return -1L;
        }
        string = string.substring(1, 5);
        return Long.valueOf(string);
    }

    @Override
    public Long convertToLocalId(Number id) {
        if (id == null) {
            return null;
        }
        long value = id.longValue();
        if (value < 0L) {
            long demasked = (value = Math.abs(value)) - this.superMask;
            if (demasked >= 0L && demasked < STORE_RANGE) {
                return -1L * demasked;
            }
            return -1L * value;
        }
        long demasked = value - this.superMask;
        if (demasked >= 0L && demasked < STORE_RANGE) {
            return demasked;
        }
        return value;
    }

    @Override
    public Long convertToHOId(Number id) {
        if (id == null) {
            return null;
        }
        long value = id.longValue();
        if (value == 0L || value > STORE_RANGE) {
            return value;
        }
        if (value < 0L) {
            if ((value = Math.abs(value)) > STORE_RANGE) {
                return -1L * value;
            }
            return -1L * (value + this.superMask);
        }
        return value + this.superMask;
    }

    static {
        STORE_RANGE = TEN_BILLION = (long)Math.pow(10.0, 10.0);
        STARTING_POINT = (long)Math.pow(10.0, 15.0) + TEN_BILLION;
    }
}

