/*
 * Decompiled with CFR 0.152.
 */
package ordermate.hom.synchronisation;

import au.com.ordermate.configuration.Config;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.database.ClassMap;
import au.com.ordermate.persistence.database.QueryableClassMap;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Table;
import ordermate.OrderMate;
import ordermate.database.finance.FinanceAccountingGroup;
import ordermate.database.finance.Shift;
import ordermate.database.misc.HOConfig;
import ordermate.database.misc.TradingDay;
import ordermate.database.sales.Customer;
import ordermate.database.sales.CustomerCategory;
import ordermate.database.sales.coupon.SalesComboCouponUsage;
import ordermate.database.sales.coupon.SalesCouponUsage;
import ordermate.database.sales.coupon.SalesPriceAdjustmentCouponUsage;
import ordermate.database.sales.loyalty.EarningLoyaltyPointTransaction;
import ordermate.database.sales.loyalty.LoyaltyPointTransaction;
import ordermate.database.sales.loyalty.RedeemingLoyaltyPointTransaction;
import ordermate.hom.synchronisation.AbstractPosSnapshotFilter;
import ordermate.hom.synchronisation.conditional.CouponSnapshotFilter;
import ordermate.maps.AllMappings;

public class POSSnapshotFilter
extends AbstractPosSnapshotFilter {
    private Set<String> includeTables;

    @Override
    protected void primeCache() {
        this.primed = false;
        this.includeTables = new HashSet<String>();
        this.cachedIncludedClasses.clear();
        for (ClassMap map : AllMappings.getMappings()) {
            if (!this.isSynchronisable(map.getTypeClass())) {
                this.excludedClasses.add(map.getTypeClass());
                continue;
            }
            if (!(map instanceof QueryableClassMap)) continue;
            this.includeTables.add(((QueryableClassMap)map).getTable());
        }
        this.excludedProperties.add(Customer.Properties.CUSTOMER_POINTS);
        this.excludedProperties.add(Customer.Properties.LOYALTY_POINTS);
        CouponSnapshotFilter couponFilter = new CouponSnapshotFilter();
        this.conditionalFilters.put(SalesCouponUsage.class, couponFilter);
        this.conditionalFilters.put(SalesPriceAdjustmentCouponUsage.class, couponFilter);
        this.conditionalFilters.put(SalesComboCouponUsage.class, couponFilter);
        if (Config.isDebuging()) {
            StringBuilder SB = new StringBuilder("Head Office Syncable classes:\r\n");
            for (Class clazz : this.cachedIncludedClasses) {
                SB.append(clazz).append("\r\n");
            }
            OrderMate.LOG.debug(SB.toString());
        }
        this.primed = true;
    }

    public boolean isSynchronisable(String tableName) {
        return this.includeTables.contains(tableName);
    }

    @Override
    public boolean isSynchronisableNoCache(Class entity) {
        boolean canSync = true;
        if (HOConfig.getInstance().isHoLite()) {
            canSync = this.isHoLiteSyncable(entity);
        }
        return canSync && super.isSynchronisableNoCache(entity) && PersistenceManager.getInstance().classSupportsQueries(entity);
    }

    private boolean isHoLiteSyncable(Class clazz) {
        Table table = clazz.getAnnotation(Table.class);
        for (Class parent = clazz.getSuperclass(); table == null && parent != null && !parent.equals(PersistentObject.class); parent = parent.getSuperclass()) {
            table = parent.getAnnotation(Table.class);
        }
        boolean include = true;
        if (table != null) {
            String name = table.name();
            if (name.startsWith("sales")) {
                include = clazz.equals(RedeemingLoyaltyPointTransaction.class) || clazz.equals(EarningLoyaltyPointTransaction.class) || clazz.equals(LoyaltyPointTransaction.class) || clazz.equals(SalesCouponUsage.class) || clazz.equals(SalesComboCouponUsage.class) || clazz.equals(SalesPriceAdjustmentCouponUsage.class) || clazz.equals(Customer.class) || clazz.equals(CustomerCategory.class);
            } else if (name.startsWith("finance")) {
                include = clazz.equals(TradingDay.class) || clazz.equals(Shift.class) || clazz.equals(FinanceAccountingGroup.class);
            } else if (name.startsWith("stock") || name.startsWith("price") || name.startsWith("report") || name.startsWith("gui") || name.startsWith("kiosk") || name.startsWith("workflow") || name.startsWith("upsell") || name.startsWith("street") || name.startsWith("feedback") || name.startsWith("debtor") || name.startsWith("config_table") || name.startsWith("config_integration")) {
                include = false;
            }
        } else {
            include = false;
        }
        OrderMate.LOG.info("Ho-lite" + (include ? " WILL " : " NOT ") + "include " + clazz);
        return include;
    }
}

