/*
 * Decompiled with CFR 0.152.
 */
package ordermate.hom.synchronisation;

import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PersistentObjectSnapshot;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.synchronisation.PersistenceOperation;
import au.com.ordermate.persistence.synchronisation.SynchronisationSnapshot;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import ordermate.database.misc.StoreGroup;
import ordermate.database.schedule.Schedule;
import ordermate.hom.synchronisation.ColourConversion;
import ordermate.hom.synchronisation.Conversion;
import ordermate.hom.synchronisation.DefaultSnapshotFilter;
import ordermate.hom.synchronisation.IdTranslator;
import ordermate.hom.synchronisation.PriceConversion;
import ordermate.hom.synchronisation.SalesQuantityConversion;
import ordermate.hom.synchronisation.SnapshotFilter;
import ordermate.hom.synchronisation.TriggerActivationStrategyConversion;
import ordermate.hom.synchronisation.customer.CustomerCategoryConversion;

public class SnapshotFactory {
    private static final Conversion[] ALL_CONVERTERS = new Conversion[]{new PriceConversion(), new SalesQuantityConversion(), new TriggerActivationStrategyConversion(), new ColourConversion(), new CustomerCategoryConversion()};
    private static final Set<PropertiedObject.Property> EXCLUDED_PROPERTIES = Collections.unmodifiableSet(new HashSet<PropertiedObject.Property>(){
        {
            this.add(Schedule.Properties.DATA);
        }
    });
    private final Map<Class, Conversion> converters = new HashMap<Class, Conversion>();
    private final IdTranslator idTranslator;
    private final Long storeId;

    public SnapshotFactory(IdTranslator theIdTranslator) {
        this(theIdTranslator, StoreGroup.getInstance().getStoreId());
    }

    public SnapshotFactory(IdTranslator theIdTranslator, Long storeId) {
        this.idTranslator = theIdTranslator;
        this.storeId = storeId;
        if (this.idTranslator == null) {
            throw new IllegalStateException("Cannot perform id translations with a null translator");
        }
        for (Conversion converter : ALL_CONVERTERS) {
            for (Class type : converter.getTypes()) {
                this.converters.put(type, converter);
            }
        }
    }

    public void setConversion(Class clazz, Conversion conversion) {
        if (conversion == null) {
            this.converters.remove(clazz);
        } else {
            this.converters.put(clazz, conversion);
        }
    }

    public SynchronisationSnapshot createSynchronisationSnapshot(PersistentObjectSnapshot<?> snapshot, PersistenceOperation operation, SnapshotFilter filter) {
        if (snapshot == null) {
            throw new IllegalArgumentException("Snap shot should not be null");
        }
        if (filter == null) {
            filter = new DefaultSnapshotFilter();
        }
        if (!filter.isSynchronisable(snapshot)) {
            return null;
        }
        SynchronisationSnapshot syncSnapshot = new SynchronisationSnapshot(operation, snapshot.getObjectType().getName());
        if (operation.equals((Object)PersistenceOperation.DELETE)) {
            Long id = this.idTranslator.convertToHOId(snapshot.get(PersistentObject.Properties.ID));
            syncSnapshot.put("ID", id);
        } else {
            for (PropertiedObject.Property<?> key : snapshot.getProperties()) {
                if (!this.isPropertySynchronisable(key, filter)) continue;
                Object value = this.converted(key, snapshot.get(key), operation);
                syncSnapshot.put(key.getName(), value);
            }
            if (filter.isPropertySynchronisable(PersistentObject.Properties.STORE_ID)) {
                syncSnapshot.put(PersistentObject.Properties.STORE_ID.getName(), this.storeId);
            }
        }
        return syncSnapshot;
    }

    private boolean isPropertySynchronisable(PropertiedObject.Property property, SnapshotFilter filter) {
        return !EXCLUDED_PROPERTIES.contains(property) && filter.isPropertySynchronisable(property);
    }

    private Object converted(PropertiedObject.Property property, Object value, PersistenceOperation operation) {
        Object toReturn = value;
        if (!this.converters.containsKey(property.getObjectType()) && (property.equals(PersistentObject.Properties.ID) || property.isReference())) {
            Long refID = (Long)value;
            toReturn = refID == null || refID == 0L ? null : this.idTranslator.convertToHOId(refID);
        } else if (value != null && this.converters.containsKey(property.getObjectType())) {
            toReturn = this.converters.get(property.getObjectType()).getPrimitiveValue(value, operation);
        }
        return toReturn;
    }
}

