/*
 * Decompiled with CFR 0.152.
 */
package ordermate.hom.synchronisation;

import java.util.HashMap;
import java.util.Map;
import ordermate.hom.DbSnapshotBufferType;
import ordermate.hom.synchronisation.SynchronisationQueue;

public class SyncQueueVendor {
    private static final Map<SyncQueueType, SynchronisationQueue> queues = new HashMap<SyncQueueType, SynchronisationQueue>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SynchronisationQueue getQueue(SyncQueueType type) {
        if (!queues.containsKey((Object)type)) {
            Map<SyncQueueType, SynchronisationQueue> map = queues;
            synchronized (map) {
                queues.put(type, new SynchronisationQueue(type));
            }
        }
        return queues.get((Object)type);
    }

    static void setSynchronisationQueue(SynchronisationQueue yourQueue) {
        queues.put(yourQueue.getQueueType(), yourQueue);
    }

    public static enum SyncQueueType {
        HeadOfficeUpdate("Update", DbSnapshotBufferType.SYNCRONISATION),
        HeadOfficeVerification("Verification", DbSnapshotBufferType.VERIFICATION);

        private final String queueName;
        private final DbSnapshotBufferType bufferType;

        private SyncQueueType(String theQueueName, DbSnapshotBufferType type) {
            this.queueName = theQueueName;
            this.bufferType = type;
        }

        public String getQueueName() {
            return this.queueName;
        }

        public DbSnapshotBufferType getBufferType() {
            return this.bufferType;
        }
    }
}

