/*
 * Decompiled with CFR 0.152.
 */
package ordermate.hom.synchronisation;

import au.com.ordermate.persistence.PersistentObjectSnapshot;
import au.com.ordermate.persistence.database.DbSnapshotBuffer;
import au.com.ordermate.persistence.synchronisation.PersistenceListener;
import au.com.ordermate.persistence.synchronisation.PersistenceOperation;
import au.com.ordermate.persistence.synchronisation.SynchronisationSnapshot;
import ordermate.OrderMate;
import ordermate.hom.DbSnapshotBufferType;
import ordermate.hom.synchronisation.LocalIdTranslator;
import ordermate.hom.synchronisation.POSSnapshotFilter;
import ordermate.hom.synchronisation.SnapshotFactory;
import ordermate.hom.synchronisation.SnapshotFilter;

public class SynchronisationListener
implements PersistenceListener {
    private final DbSnapshotBuffer buffer = new DbSnapshotBuffer(DbSnapshotBufferType.SYNCRONISATION);
    private final SnapshotFactory converter = new SnapshotFactory(new LocalIdTranslator());
    private final SnapshotFilter filter = new POSSnapshotFilter();
    private static SynchronisationListener instance;

    @Override
    public void objectChanged(PersistentObjectSnapshot snapshot, PersistenceOperation operation) {
        try {
            SynchronisationSnapshot syncSnapshot = this.converter.createSynchronisationSnapshot(snapshot, operation, this.filter);
            if (syncSnapshot != null) {
                this.buffer.add(syncSnapshot);
            }
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Exception creating and adding snapshot", (Throwable)ex);
        }
    }

    public static synchronized PersistenceListener getInstance() {
        if (instance == null) {
            instance = new SynchronisationListener();
        }
        return instance;
    }
}

