/*
 * Decompiled with CFR 0.152.
 */
package ordermate.hom.synchronisation;

import au.com.ordermate.configuration.Config;
import au.com.ordermate.persistence.database.DbSnapshotBuffer;
import au.com.ordermate.persistence.synchronisation.SnapshotEntry;
import au.com.ordermate.persistence.synchronisation.SynchronisationSnapshot;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;
import javax.jms.JMSException;
import ordermate.OrderMate;
import ordermate.database.Data;
import ordermate.database.misc.HOConfig;
import ordermate.hom.jms.JMSProducerService;
import ordermate.hom.synchronisation.SnapshotBuffer;
import ordermate.hom.synchronisation.SyncQueueVendor;

public class SynchronisationQueue
implements Runnable {
    private static final long POLL_DELAY = 5000L;
    private static final long RETRY_DELAY = 600000L;
    private static final ExecutorService executor = Executors.newFixedThreadPool(3, new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r);
            thread.setPriority(4);
            return thread;
        }
    });
    private final SyncQueueVendor.SyncQueueType type;
    private final JMSProducerService connectionService;
    private final SnapshotBuffer buffer;
    private final List<Integer> last100Sizes = new ArrayList<Integer>(100);
    private final Semaphore binarySemaphore = new Semaphore(1, true);
    private int optimizeCount = 0;

    public SynchronisationQueue(SyncQueueVendor.SyncQueueType yourType) {
        this(yourType, new DbSnapshotBuffer(yourType.getBufferType()));
    }

    public SynchronisationQueue(SyncQueueVendor.SyncQueueType yourType, SnapshotBuffer yourBuffer) {
        this.type = yourType;
        this.connectionService = new JMSProducerService(this.type.getQueueName());
        this.buffer = yourBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        this.connectionService.createConnection();
        if (!this.connectionService.isConnectionValid()) {
            OrderMate.LOG.error("Cannot start synchronisation queue, jms connection could not be created for " + (Object)((Object)this.type));
            return;
        }
        boolean busy = false;
        try {
            this.connectionService.createProducer();
            try {
                this.send(new ArrayList<SnapshotEntry>());
            }
            catch (Exception ex) {
                OrderMate.LOG.error("Error sending list of snapshot entries", (Throwable)ex);
            }
            int consecutiveErrorCount = 0;
            while (!Thread.interrupted()) {
                try {
                    this.binarySemaphore.acquire();
                    List<SnapshotEntry> entries = this.buffer.getBufferContent();
                    if (entries.isEmpty()) {
                        if (busy) {
                            OrderMate.LOG.info("Message queue now empty.");
                            busy = false;
                        }
                        Thread.sleep(5000L);
                    } else {
                        if (!busy) {
                            OrderMate.LOG.info("Message queue busy.");
                            busy = true;
                        }
                        this.send(entries);
                        Thread.sleep(HOConfig.getInstance().getSyncSendDelayMs());
                    }
                    consecutiveErrorCount = 0;
                    this.binarySemaphore.release();
                }
                catch (Exception ex) {
                    int sleepSeconds = 2 * (++consecutiveErrorCount + 1);
                    OrderMate.LOG.warn("An exception occurred in the synchronization queue, will attempt to continue in " + sleepSeconds + " seconds", (Throwable)ex);
                    this.connectionService.closeProducer();
                    this.connectionService.createProducer();
                    try {
                        Thread.sleep(1000 * sleepSeconds);
                    }
                    catch (InterruptedException ie) {
                        OrderMate.LOG.info("Interrupted whilst sleeping, existing sync Queue thread.");
                        this.binarySemaphore.release();
                        this.connectionService.closeProducer();
                        this.connectionService.closeConnection();
                        try {
                            OrderMate.LOG.warn("JMS Sync Queue shutdown, will attempt to start queue again after 10 minutes");
                            Thread.sleep(600000L);
                        }
                        catch (InterruptedException ex2) {
                            return;
                        }
                        if (Config.getBooleanValue("killSync")) return;
                        SynchronisationQueue.startExecutor(this);
                        return;
                    }
                    {
                        catch (Throwable throwable) {
                            this.binarySemaphore.release();
                            throw throwable;
                        }
                    }
                    try {
                        this.binarySemaphore.release();
                    }
                    catch (JMSException jmse) {
                        OrderMate.LOG.warn("A JMS exception occured, exiting sync loop, will start again in 15 minutes", (Throwable)jmse);
                        return;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                        return;
                    }
                }
            }
        }
        finally {
            this.connectionService.closeProducer();
            this.connectionService.closeConnection();
            try {
                OrderMate.LOG.warn("JMS Sync Queue shutdown, will attempt to start queue again after 10 minutes");
                Thread.sleep(600000L);
            }
            catch (InterruptedException ex) {
                return;
            }
            if (!Config.getBooleanValue("killSync")) {
                SynchronisationQueue.startExecutor(this);
            }
        }
    }

    public SnapshotBuffer getSnapshotBuffer() {
        return this.buffer;
    }

    private void send(List<SnapshotEntry> entries) throws JMSException, Exception {
        long start = 0L;
        if (Config.isDebuging()) {
            OrderMate.LOG.info("Sending synchronization updates : " + entries.size());
            start = System.nanoTime();
        }
        if (this.last100Sizes.size() == 100) {
            ++this.optimizeCount;
            int avg = 0;
            for (Integer val : this.last100Sizes) {
                avg += val.intValue();
            }
            OrderMate.LOG.info("Average synchronization message size : " + (avg /= 100));
            start = System.nanoTime();
        }
        int objectPriority = entries.isEmpty() ? 4 : entries.get(0).getPriority();
        this.connectionService.sendObjectMessage((Serializable)((Object)entries), objectPriority);
        this.buffer.remove(entries);
        if (this.last100Sizes.size() == 100) {
            OrderMate.LOG.info(String.format("Last sync msg took %.1fms", (double)(System.nanoTime() - start) / 1000000.0));
            this.last100Sizes.clear();
        }
        if (Config.isDebuging()) {
            OrderMate.LOG.info(String.format("Last sync msg took %.1fms", (double)(System.nanoTime() - start) / 1000000.0));
        }
        if (this.optimizeCount == 10) {
            this.optimizeCount = 0;
            try {
                OrderMate.LOG.info("Optimizing system_sync_buffer table");
                long optimizeStart = System.currentTimeMillis();
                Data.dbMaintenance.optimizeTable("system_synchronisation_buffer");
                OrderMate.LOG.info("Optimizing system_synchronisation_buffer took :" + (System.currentTimeMillis() - optimizeStart) + "ms");
            }
            catch (Exception ex) {
                OrderMate.LOG.error("exception optimizing the system sync buffer", (Throwable)ex);
            }
        }
        this.last100Sizes.add(entries.size());
    }

    public static void startExecutor(SynchronisationQueue queueToStart) {
        executor.submit(queueToStart);
    }

    protected void pause(boolean pauseQueue) {
        if (pauseQueue) {
            try {
                this.binarySemaphore.acquire();
            }
            catch (InterruptedException ex) {
                OrderMate.LOG.warn("Interrupted exception whilst trying to pause synchronisation queue");
                return;
            }
        } else {
            this.binarySemaphore.release();
        }
    }

    public void add(SynchronisationSnapshot snappy) throws Exception {
        this.buffer.add(snappy);
    }

    public SyncQueueVendor.SyncQueueType getQueueType() {
        return this.type;
    }
}

