/*
 * Decompiled with CFR 0.152.
 */
package ordermate.hom.synchronisation;

import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistenceMetaData;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PersistentObjectSnapshot;
import au.com.ordermate.persistence.database.LPAPersistenceDelegate;
import au.com.ordermate.persistence.synchronisation.PersistenceOperation;
import au.com.ordermate.persistence.synchronisation.SynchronisationSnapshot;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import ordermate.OrderMate;
import ordermate.database.reports.general.NumberReport;
import ordermate.hom.synchronisation.LocalIdTranslator;
import ordermate.hom.synchronisation.POSSnapshotFilter;
import ordermate.hom.synchronisation.SnapshotBuffer;
import ordermate.hom.synchronisation.SnapshotFactory;
import ordermate.hom.synchronisation.SnapshotFilter;
import ordermate.hom.synchronisation.SyncQueueVendor;
import ordermate.hom.synchronisation.SynchronisationException;
import ordermate.hom.synchronisation.SynchronisationModel;
import ordermate.signals.Signal;

public class Synchroniser
implements Runnable {
    private final SnapshotBuffer buffer;
    private final SnapshotFactory converter;
    private final SnapshotFilter filter;
    private final Collection<Class> entities;
    private final Signal endSignal;
    private static final ExecutorService executor = Executors.newSingleThreadExecutor();
    private SynchronisationModel tableModel;

    public Synchroniser(SnapshotBuffer buffer, Collection<Class> entities, Signal end) {
        this.buffer = buffer;
        this.entities = entities;
        this.endSignal = end;
        this.converter = new SnapshotFactory(new LocalIdTranslator());
        this.filter = new POSSnapshotFilter();
    }

    public Future synchroniseAll() {
        return executor.submit(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        Thread.currentThread().setName("HO Synchroniser");
        this.pauseSynchronisationQueue(true);
        this.buffer.setUsePreparedStatements(true);
        ((LPAPersistenceDelegate)PersistenceManager.getPersistenceDelegate()).setCallInitOnLoad(false);
        this.lockEntitiesTable();
        try {
            long start = System.currentTimeMillis();
            this.buffer.clear();
            this.clearAll(this.entities);
            this.sendAll(this.entities);
            OrderMate.LOG.info(String.format("Sync complete, took : %.3fmin", (double)((System.currentTimeMillis() - start) / 1000L) / 60.0));
            return;
        }
        catch (Exception ex) {
            OrderMate.LOG.warn("Exception clearing entities in synchroniser", (Throwable)ex);
            return;
        }
        finally {
            try {
                ((LPAPersistenceDelegate)PersistenceManager.getPersistenceDelegate()).setCallInitOnLoad(true);
                this.unlockEntitiesTables();
                OrderMate.LOG.info("All tables unlocked.");
                this.buffer.setUsePreparedStatements(false);
                OrderMate.LOG.info("Analyzing sync buffer table");
                PersistenceManager.getPersistenceDelegate().executeUpdate("ANALYZE TABLE system_synchronisation_buffer", null);
                this.pauseSynchronisationQueue(false);
            }
            catch (Exception ex) {
                OrderMate.LOG.error("Error cleaning up after synchronisation");
            }
            finally {
                this.endSignal.emit();
            }
        }
    }

    private void pauseSynchronisationQueue(boolean pauseIt) {
        SyncQueueVendor.getQueue(SyncQueueVendor.SyncQueueType.HeadOfficeUpdate).pause(pauseIt);
    }

    public void setModel(SynchronisationModel model) {
        this.tableModel = model;
    }

    void send(Class<? extends PersistentObject> entity) throws InterruptedException, SynchronisationException {
        List<? extends PersistentObject> list;
        this.addTableToView(entity);
        int offset = 0;
        do {
            NumberReport totalEntityCount;
            int rowCount = (totalEntityCount = PersistenceManager.getObject(NumberReport.class, "SELECT count(*) AS value FROM " + PersistenceManager.getPersistenceMetaData().getClassTable(entity), null)) != null ? totalEntityCount.intValue() : 0;
            String sql = Query.select(entity).limit(1000, offset).toString();
            list = PersistenceManager.getObjectList(entity, sql, null);
            ArrayList<SynchronisationSnapshot> bulkBuffer = new ArrayList<SynchronisationSnapshot>();
            int i = 0;
            while (i < list.size()) {
                int BULK_SIZE = 10;
                for (int j = 0; j < 10 && i < list.size(); ++j) {
                    PersistentObject po;
                    PersistentObjectSnapshot snapshot;
                    if ((snapshot = (po = list.get(i++)).getLastSavedSnapshot()) == null) {
                        snapshot = po.getSnapshot();
                    }
                    SynchronisationSnapshot sync = this.converter.createSynchronisationSnapshot(snapshot, PersistenceOperation.SYNC, this.filter);
                    bulkBuffer.add(sync);
                }
                try {
                    this.buffer.add(bulkBuffer.toArray(new SynchronisationSnapshot[bulkBuffer.size()]));
                    bulkBuffer.clear();
                }
                catch (Exception ex) {
                    throw new SynchronisationException(ex);
                }
                if (!Thread.interrupted()) continue;
                throw new InterruptedException();
            }
            this.updateTableView(offset, list, rowCount);
            offset += 1000;
        } while (!list.isEmpty() && list.size() == 1000);
    }

    private void lockEntitiesTable() {
        StringBuilder sb = new StringBuilder();
        sb.append("LOCK TABLES ");
        this.appendTables(sb);
        PersistenceManager.getPersistenceDelegate().executeUpdate(sb.toString(), null);
        OrderMate.LOG.info("All tables locked.");
    }

    private void unlockEntitiesTables() {
        PersistenceManager.getPersistenceDelegate().executeUpdate("UNLOCK TABLES", null);
    }

    private void appendTables(StringBuilder sb) {
        PersistenceMetaData meta = PersistenceManager.getPersistenceMetaData();
        boolean first = true;
        ArrayList<String> tables = new ArrayList<String>(this.entities.size());
        for (Class entity : this.entities) {
            String table;
            if (!PersistenceManager.getInstance().classSupportsQueries(entity) || (table = meta.getClassTable(entity)) == null || tables.contains(table)) continue;
            tables.add(table);
            if (!first) {
                sb.append(", ");
            } else {
                first = false;
            }
            sb.append(table);
            sb.append(" WRITE");
        }
    }

    void clearAll(Collection<Class> entitiesToSend) throws Exception {
        int count;
        for (Class entity : entitiesToSend) {
            OrderMate.LOG.info("Clearing " + entity);
            SynchronisationSnapshot clear = new SynchronisationSnapshot(PersistenceOperation.CLEAR_ALL, entity.getName());
            this.buffer.add(clear);
        }
        this.pauseSynchronisationQueue(false);
        OrderMate.LOG.info("Sending Clear Entites for Synchronisation");
        for (count = 120; this.buffer.getBufferContent().size() > 0 && count > 0; --count) {
            OrderMate.LOG.info("Waiting for clear buffer to drain");
            Thread.sleep(1000L);
        }
        if (count == 0) {
            OrderMate.LOG.warn("Clear commands were not drained after two minutes, this could result in data loss.");
        } else {
            OrderMate.LOG.info("Clear commands drained");
        }
        this.pauseSynchronisationQueue(true);
    }

    private void sendAll(Collection<Class> entitiesToSend) throws Exception {
        Thread.sleep(10000L);
        for (Class entity : entitiesToSend) {
            if (this.filter.isSynchronisable(entity)) {
                OrderMate.LOG.info("Synchronising " + entity);
                try {
                    this.send(entity);
                    continue;
                }
                catch (InterruptedException ex) {
                    OrderMate.LOG.info("Synchronisation interrupted sending entity " + entity, (Throwable)ex);
                    return;
                }
                catch (SynchronisationException ex) {
                    OrderMate.LOG.warn("The synchronisation failed for " + entity, (Throwable)ex);
                    return;
                }
                catch (Throwable th) {
                    OrderMate.LOG.warn("The synchronisation failed for " + entity, th);
                    continue;
                }
            }
            OrderMate.LOG.info("Not synchronising " + entity);
        }
    }

    private void updateTableView(int offset, List<? extends PersistentObject> list, int total) {
        if (this.tableModel != null) {
            this.tableModel.updateCount(offset + list.size());
            this.tableModel.updateTotal(total);
        }
    }

    private void addTableToView(Class entity) {
        if (this.tableModel != null) {
            this.tableModel.addTable(entity.getSimpleName());
        }
    }
}

