/*
 * Decompiled with CFR 0.152.
 */
package ordermate.hom.synchronisation.config;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.synchronisation.SynchronisationSnapshot;
import au.com.ordermate.util.StringUtils;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import ordermate.OrderMate;
import ordermate.database.misc.StoreGroup;
import ordermate.database.users.PermissionGroup;
import ordermate.database.users.User;
import org.apache.activemq.command.ActiveMQObjectMessage;

public class HeadOfficeUserMessageListener
implements MessageListener {
    private static final String STORES = "ACTIVE_STORES";
    private final Set<PropertiedObject.Property> include = new HashSet<PropertiedObject.Property>();

    public HeadOfficeUserMessageListener() {
        this.include.add(User.Properties.CARD_ID);
        this.include.add(User.Properties.FIRST_NAME);
        this.include.add(User.Properties.LAST_NAME);
        this.include.add(User.Properties.PASSWORD);
        this.include.add(User.Properties.PIN);
        this.include.add(User.Properties.SYSTEM_STATE);
    }

    public void onMessage(Message arg0) {
        ActiveMQObjectMessage message = (ActiveMQObjectMessage)arg0;
        try {
            SynchronisationSnapshot snapshot = (SynchronisationSnapshot)message.getObject();
            String stores = message.getStringProperty(STORES);
            this.processHeadOfficeUser(snapshot, stores);
        }
        catch (JMSException ex) {
            OrderMate.LOG.info("Cannot read in headOfficeUser message, will not activate.", (Throwable)ex);
        }
    }

    private void processHeadOfficeUser(SynchronisationSnapshot snappy, String stores) {
        boolean isActive = false;
        List<String> strings = StringUtils.splitToList(stores, ",");
        isActive = strings.contains(StoreGroup.getInstance().getStoreId().toString());
        User user = this.createOrGetUser(snappy);
        OrderMate.LOG.info("Processing incoming HeadOffice User :" + user.getName());
        PermissionGroup admin = PermissionGroup.getPermissionGroupForName("Administrator");
        user.setPermissionGroup(admin);
        user.setHoId((Long)snappy.get(User.Properties.ID.getName()));
        user.setActive(isActive);
        user.save();
    }

    private User createOrGetUser(SynchronisationSnapshot snappy) {
        Long id = (Long)snappy.get(User.Properties.ID.getName());
        ObjectQuery query = Query.select(User.class).equals(User.Properties.HO_ID, id);
        User user = PersistenceManager.getObject(User.class, query.toString(), null);
        if (user == null) {
            user = new User();
        }
        this.populateUser(user, snappy);
        return user;
    }

    private void populateUser(User user, SynchronisationSnapshot snappy) {
        for (PropertiedObject.Property prop : User.Properties) {
            if (prop.isReference() || prop.isList() || !this.include.contains(prop)) continue;
            try {
                PropertiedObject.PropsHelper.setPropertyValue(user, prop, snappy.get(prop.getName()));
            }
            catch (Exception ex) {
                OrderMate.LOG.info("Cannot set HeadOffice User property " + prop.getLabel(), (Throwable)ex);
            }
        }
    }
}

