/*
 * Decompiled with CFR 0.152.
 */
package ordermate.hom.synchronisation.customer;

import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.synchronisation.SynchronisationSnapshot;
import javax.jms.Message;
import javax.jms.MessageListener;
import ordermate.OrderMate;
import ordermate.database.sales.CustomerCategory;
import ordermate.hom.synchronisation.customer.CustomerCategoryUpdateProcessor;
import org.apache.activemq.command.ActiveMQObjectMessage;

public class CustomerCategoryMessageListener
implements MessageListener {
    private final CustomerCategoryUpdateProcessor processor = new CustomerCategoryUpdateProcessor();

    public void onMessage(Message msg) {
        if (msg instanceof ActiveMQObjectMessage) {
            try {
                SynchronisationSnapshot snapshot = (SynchronisationSnapshot)((ActiveMQObjectMessage)msg).getObject();
                Number masterId = (Number)snapshot.get("masterId");
                boolean isNew = PersistenceManager.getObject(CustomerCategory.class, Query.select(CustomerCategory.class).equals(CustomerCategory.Properties.MASTER_ID, Long.toString(masterId.longValue())).toString()) == null;
                this.processor.processCustomerCategory(snapshot, isNew);
            }
            catch (Exception ex) {
                OrderMate.LOG.warn("Could not update customer category:", (Throwable)ex);
            }
        }
    }
}

