/*
 * Decompiled with CFR 0.152.
 */
package ordermate.hom.synchronisation.customer;

import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.synchronisation.PosPersistentObjectCreator;
import au.com.ordermate.persistence.synchronisation.SynchronisationSnapshot;
import ordermate.OrderMate;
import ordermate.database.sales.CustomerCategory;
import ordermate.hom.synchronisation.IdTranslator;
import ordermate.hom.synchronisation.LocalIdTranslator;
import ordermate.hom.synchronisation.SyncUpdateProcessor;

public class CustomerCategoryUpdateProcessor
extends SyncUpdateProcessor {
    private PosPersistentObjectCreator creator;

    public void processCustomerCategory(SynchronisationSnapshot snapshot, boolean isNew) {
        CustomerCategory cat;
        if (this.creator == null) {
            this.creator = new MasterIDObjectCreator(new LocalIdTranslator());
        }
        if ((cat = (CustomerCategory)this.creator.createFromSnapShotContent(snapshot)) == null) {
            return;
        }
        if (cat.isDefaultPrimitive()) {
            CustomerCategory currentDefault = CustomerCategory.getDefaultCategory();
            if (currentDefault != null) {
                currentDefault.setIsDefault(null);
                this.saveToDB(currentDefault, false);
            }
            cat.setIsDefault(Boolean.TRUE);
        }
        this.saveToDB(cat, isNew);
    }

    class MasterIDObjectCreator
    extends PosPersistentObjectCreator {
        public MasterIDObjectCreator(IdTranslator translator) {
            super(translator);
        }

        @Override
        protected PersistentObject retrieveObject(Class objectType, SynchronisationSnapshot snapshot) {
            snapshot.remove("ID");
            Number id = (Number)snapshot.get("masterId");
            if (id != null) {
                Class clazz = objectType;
                PersistentObject po = (PersistentObject)PersistenceManager.getObject(clazz, Query.select(objectType).whereFunction("MasterId = " + id).toString());
                if (po != null) {
                    return po;
                }
                try {
                    return (PersistentObject)objectType.newInstance();
                }
                catch (Exception e) {
                    OrderMate.LOG.error("Cannot instantiate class:" + objectType, (Throwable)e);
                }
            }
            return null;
        }

        @Override
        protected PersistentObject createObject(Class<? extends PersistentObject> objectType) throws InstantiationException, IllegalAccessException {
            return null;
        }
    }
}

