/*
 * Decompiled with CFR 0.152.
 */
package ordermate.hom.synchronisation.customer;

import au.com.ordermate.gui.GuiHandler;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.util.StringUtils;
import com.sun.jersey.api.client.WebResource;
import ordermate.OrderMate;
import ordermate.database.misc.HOConfig;
import ordermate.database.misc.StoreGroup;
import ordermate.database.sales.Customer;
import ordermate.hom.synchronisation.BusinessObjectRequestorExecuter;
import ordermate.hom.synchronisation.LocalIdTranslator;
import ordermate.hom.synchronisation.customer.LoyaltyPointAuth;
import ordermate.integration.jaxb.customerportal.CustomerExt;
import ordermate.integration.jaxb.customerportal.CustomerExtList;
import ordermate.integration.jaxb.customerportal.CustomerPortalResult;
import ordermate.integration.jaxb.customerportal.SystemStateType;
import ordermate.integration.loyalty.LoyaltyPointAuthority;
import ordermate.integration.loyalty.LoyaltyPointsInfoRecord;
import ordermate.integration.webservice.RestHelper;

public class CustomerLoyaltyPointAuthority
extends LoyaltyPointAuthority {
    private final String CURRENT_POINTS = "synchronize/loyaltyPoints/currentLoyaltyPoints";
    private final String AUTHORISATION = "synchronize/loyaltyPoints/authorisation";
    private final String RETURN_POINTS = "synchronize/loyaltyPoints/returnLoyaltyPoints";
    private final String RESYNC_POINTS = "synchronize/loyaltyPoints/resyncLoyaltyPoints";
    private RestHelper helper;
    private LocalIdTranslator translator;
    public static final String CUSTOMER_LIST_URI = "portal/customer/customerList";
    public static final String CUSTOMER_DETAILS = "portal/customer/customerDetails";
    public static final String CP_PARAM_CARD_NO = "cardno";
    public static final String CP_PARAM_EMAIL = "email";
    public static final String CP_PARAM_SYSTEM_STATE = "systemstate";
    private static final Integer CONN_TIMEOUT = 5000;
    private static final Integer READ_TIMEOUT = 5000;

    public CustomerLoyaltyPointAuthority(GuiHandler handler) {
        this(handler, new RestHelper());
    }

    protected CustomerLoyaltyPointAuthority(GuiHandler handler, RestHelper yourHelper) {
        super(handler);
        this.gui = handler;
        this.helper = yourHelper;
        if (this.helper == null) {
            this.helper = new RestHelper();
        }
        this.translator = new LocalIdTranslator();
    }

    @Override
    public Integer updateNumberOfPoints(LoyaltyPointsInfoRecord loyaltyInfo) {
        if (!this.checkCustomer(loyaltyInfo.getCustomer())) {
            return null;
        }
        StringBuilder SB = new StringBuilder(HOConfig.getInstance().getServerLocation());
        SB.append("synchronize/loyaltyPoints/currentLoyaltyPoints");
        WebResource resource = this.helper.getResource(SB.toString(), this.SHORT_TIMEOUT, this.SHORT_TIMEOUT);
        resource = this.helper.addBasicAuth(resource, StoreGroup.getInstance().getStoreName(), String.valueOf(StoreGroup.getInstance().getStoreId()));
        resource = this.helper.addParameter(resource, "customerId", this.translator.convertToHOId(loyaltyInfo.getCustomer().getID()).toString());
        Integer points = null;
        try {
            String pointsString = this.helper.getText(resource);
            if (pointsString == null) {
                OrderMate.LOG.warn("Could not retrieve points from HO, null response");
            } else {
                points = Integer.valueOf(pointsString);
            }
        }
        catch (NumberFormatException ex) {
            OrderMate.LOG.warn("Could not retrieve customer points from HO:", (Throwable)ex);
        }
        catch (Exception ex) {
            OrderMate.LOG.warn("Could not retrieve points from HO:", (Throwable)ex);
        }
        return points;
    }

    protected Long authoriseTransaction(Customer customer, int numPoints) {
        if (!this.checkCustomer(customer)) {
            return null;
        }
        StringBuilder SB = new StringBuilder(HOConfig.getInstance().getServerLocation());
        SB.append("synchronize/loyaltyPoints/authorisation");
        WebResource resource = this.helper.getResource(SB.toString(), this.LONG_TIMEOUT, this.LONG_TIMEOUT);
        resource = this.helper.addBasicAuth(resource, StoreGroup.getInstance().getStoreName(), String.valueOf(StoreGroup.getInstance().getStoreId()));
        resource = this.helper.addParameter(resource, "customerId", this.translator.convertToHOId(customer.getID()).toString());
        resource = this.helper.addParameter(resource, "numPoints", Integer.toString(numPoints));
        String result = null;
        try {
            result = this.helper.getText(resource);
        }
        catch (Exception ex) {
            OrderMate.LOG.warn("Couldn't reach LoyaltyPointResource:", (Throwable)ex);
        }
        if (result != null && result.startsWith(LoyaltyPointAuth.Allowed.name())) {
            return this.handleAllowedResult(result);
        }
        if (numPoints < 0) {
            if (result != null && result.startsWith("Not")) {
                this.handleRefusedResult(result);
            } else {
                this.handleProblemResult(result);
            }
        }
        return null;
    }

    private boolean returnPoints(LoyaltyPointsInfoRecord loyaltyInfo) {
        if (loyaltyInfo.getNumPoints() == 0) {
            return true;
        }
        if (!this.checkCustomer(loyaltyInfo.getCustomer())) {
            return false;
        }
        StringBuilder SB = new StringBuilder(HOConfig.getInstance().getServerLocation());
        SB.append("synchronize/loyaltyPoints/returnLoyaltyPoints");
        WebResource resource = this.helper.getResource(SB.toString(), this.SHORT_TIMEOUT, this.SHORT_TIMEOUT);
        resource = this.helper.addBasicAuth(resource, StoreGroup.getInstance().getStoreName(), String.valueOf(StoreGroup.getInstance().getStoreId()));
        resource = this.helper.addParameter(resource, "customerId", this.translator.convertToHOId(loyaltyInfo.getCustomer().getID()).toString());
        resource = this.helper.addParameter(resource, "numPoints", Integer.toString(loyaltyInfo.getNumPoints()));
        String result = null;
        try {
            result = this.helper.getText(resource);
        }
        catch (Exception ex) {
            OrderMate.LOG.warn("Couldn't reach LoyaltyPointResource:", (Throwable)ex);
        }
        if (result != null && result.startsWith(LoyaltyPointAuth.Allowed.name())) {
            OrderMate.LOG.info("Returned unused points to LoyaltyPointAuthority for customerId :" + loyaltyInfo.getCustomer().getID());
            return true;
        }
        OrderMate.LOG.info("Loyalty points could not be returned to loyaltyPointAuthority : " + loyaltyInfo.getCustomer().getID());
        return false;
    }

    @Override
    public boolean resyncPoints(LoyaltyPointsInfoRecord loyaltyInfo) {
        if (!this.checkCustomer(loyaltyInfo.getCustomer())) {
            return false;
        }
        StringBuilder SB = new StringBuilder(HOConfig.getInstance().getServerLocation());
        SB.append("synchronize/loyaltyPoints/resyncLoyaltyPoints");
        WebResource resource = this.helper.getResource(SB.toString(), this.SHORT_TIMEOUT, this.SHORT_TIMEOUT);
        resource = this.helper.addBasicAuth(resource, StoreGroup.getInstance().getStoreName(), String.valueOf(StoreGroup.getInstance().getStoreId()));
        resource = this.helper.addParameter(resource, "customerId", this.translator.convertToHOId(loyaltyInfo.getCustomer().getID()).toString());
        String result = null;
        try {
            result = this.helper.getText(resource);
        }
        catch (Exception ex) {
            OrderMate.LOG.warn("Couldn't reach LoyaltyPointResource:", (Throwable)ex);
        }
        if (result != null && result.startsWith(LoyaltyPointAuth.Allowed.name())) {
            OrderMate.LOG.info("Resynchronised points for customerId :" + loyaltyInfo.getCustomer().getID());
            return true;
        }
        OrderMate.LOG.info("Could not resynchronise points for customerId :" + loyaltyInfo.getCustomer().getID() + " " + result);
        return false;
    }

    private Long handleAllowedResult(String result) {
        String id = result.substring(LoyaltyPointAuth.Allowed.name().length());
        Long value = null;
        try {
            value = Long.valueOf(id);
        }
        catch (NumberFormatException ex) {
            this.handleProblemResult(result);
            value = null;
        }
        return value;
    }

    private void handleRefusedResult(String result) {
        StringBuilder SB = new StringBuilder("<html>The requested Loyalty Point Transaction cannot be approved.<br><br>");
        if (result.startsWith(LoyaltyPointAuth.NotAllowed_Error.name())) {
            SB.append("There was an error at Head Office.<br>Please contact OrderMate regarding this matter.");
        } else if (result.startsWith(LoyaltyPointAuth.NotAllowed_Inactive.name())) {
            SB.append("The customer is recorded as inactive at Head Office.");
        } else if (result.startsWith(LoyaltyPointAuth.NotAllowed_Insufficient.name())) {
            SB.append("The customer does not have sufficient points at Head Office.");
        } else if (result.startsWith(LoyaltyPointAuth.NotAllowed_Unknown.name())) {
            SB.append("The customer is not known at Head Office. Please synchronise first.");
        }
        SB.append("</html>");
        this.displayResult("Loyalty Points Not Authorised", SB.toString());
    }

    private void handleProblemResult(String result) {
        StringBuilder SB = new StringBuilder("<html>There was an issue connecting with head office.<br><br>");
        if (result == null) {
            SB.append("A connection to Head Office could not be established, or time out.");
        } else {
            SB.append("The reply from the connection was not expected. See logs.");
        }
        SB.append("</html>");
        this.displayResult("Could not Authorise Loyalty Point Transaction", SB.toString());
        OrderMate.LOG.warn("Could not contact HO for Loyalty Point Authorisation. Result:" + result);
    }

    @Override
    public Long setResetNumberOfPoints(LoyaltyPointsInfoRecord loyaltyInfo) {
        return this.authoriseTransaction(loyaltyInfo.getCustomer(), loyaltyInfo.getNumPoints());
    }

    @Override
    public Long redeemPoints(LoyaltyPointsInfoRecord loyaltyInfo) {
        return this.authoriseTransaction(loyaltyInfo.getCustomer(), loyaltyInfo.getNumPoints());
    }

    @Override
    public Long accruePoints(LoyaltyPointsInfoRecord loyaltyInfo) {
        return this.authoriseTransaction(loyaltyInfo.getCustomer(), loyaltyInfo.getNumPoints());
    }

    @Override
    public boolean returnRedeemedPoints(LoyaltyPointsInfoRecord loyaltyInfo) {
        return this.returnPoints(loyaltyInfo);
    }

    @Override
    public boolean returnAccruedPoints(LoyaltyPointsInfoRecord loyaltyInfo) {
        return this.returnPoints(loyaltyInfo);
    }

    @Override
    public boolean fetchCustomerInfo(LoyaltyPointsInfoRecord loyaltyInfo) {
        try {
            WebResource resource = this.helper.getResource(HOConfig.getInstance().getServerLocation() + CUSTOMER_LIST_URI, CONN_TIMEOUT, READ_TIMEOUT);
            resource = this.helper.addParameter(resource, CP_PARAM_CARD_NO, loyaltyInfo.getCustomer().getCardID());
            if (!StringUtils.isEmpty(loyaltyInfo.getCustomer().getEmail())) {
                resource = this.helper.addParameter(resource, CP_PARAM_EMAIL, loyaltyInfo.getCustomer().getEmail());
            }
            resource = this.helper.addParameter(resource, CP_PARAM_SYSTEM_STATE, SystemStateType.ACTIVE.toString());
            resource = this.helper.addBasicAuth(resource, OrderMate.CUSTOMER_PORTAL_USER, OrderMate.CUSTOMER_PORTAL_PWD);
            OrderMate.LOG.info("Calling:" + resource.toString());
            CustomerPortalResult portalResult = (CustomerPortalResult)resource.get(CustomerPortalResult.class);
            if (portalResult.getResultCode().intValue() != 0) {
                OrderMate.LOG.error("Error retreiving Customer by cardno from HO for card no: " + loyaltyInfo.getCustomer().getCardID() + ", error code: " + portalResult.getResultCode() + ", description: " + portalResult.getResultDesc());
            } else if (portalResult.getCustomerExtList() != null && portalResult.getCustomerExtList().getCustomerExt() != null && portalResult.getCustomerExtList().getCustomerExt().size() >= 1) {
                CustomerExt hoCustomer = portalResult.getCustomerExtList().getCustomerExt().get(0);
                Customer fetchedCustomer = PersistenceManager.getServerConnection().runSync(new BusinessObjectRequestorExecuter<Customer>(hoCustomer.getId(), Customer.class, Customer.Properties.ID));
                if (fetchedCustomer != null) {
                    loyaltyInfo.setCustomer(fetchedCustomer);
                    loyaltyInfo.setNumPoints(hoCustomer.getPoints().intValue());
                    return true;
                }
            } else {
                OrderMate.LOG.warn("A response was received from HO, but it did not contain any customers.\r\nResult Code: " + String.valueOf(portalResult.getResultCode()) + "\r\nResult Desc: " + portalResult.getResultDesc());
                CustomerExtList customers = portalResult.getCustomerExtList();
                if (customers == null) {
                    OrderMate.LOG.warn("We got no customer list back");
                } else if (customers.getCustomerExt() == null) {
                    OrderMate.LOG.warn("We got no customer in the list");
                } else {
                    OrderMate.LOG.warn("We got none or more than one customer in the list:" + customers.getCustomerExt().size());
                }
                String result = (String)resource.get(String.class);
                OrderMate.LOG.warn("Customer pull result:" + result);
            }
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Error retreiving Customer by cardno from HO for card no: " + loyaltyInfo.getCustomer().getCardID(), (Throwable)ex);
        }
        return false;
    }

    @Override
    public boolean updateCustomerInfo(LoyaltyPointsInfoRecord loyaltyInfo) {
        Integer numPoints = this.updateNumberOfPoints(loyaltyInfo);
        if (numPoints != null) {
            loyaltyInfo.setNumPoints(numPoints);
        }
        return numPoints != null;
    }
}

