/*
 * Decompiled with CFR 0.152.
 */
package ordermate.hom.synchronisation.customer;

import au.com.ordermate.persistence.synchronisation.SynchronisationSnapshot;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import ordermate.OrderMate;
import ordermate.hom.synchronisation.customer.CustomerUpdateProcessor;
import org.apache.activemq.command.ActiveMQObjectMessage;

public class CustomerUpdateMessageListener
implements MessageListener {
    private final CustomerUpdateProcessor processor;

    public CustomerUpdateMessageListener() {
        this(new CustomerUpdateProcessor());
    }

    protected CustomerUpdateMessageListener(CustomerUpdateProcessor yourProcessor) {
        this.processor = yourProcessor;
    }

    public void onMessage(Message msg) {
        if (msg instanceof ActiveMQObjectMessage) {
            try {
                SynchronisationSnapshot snapshot = (SynchronisationSnapshot)((ActiveMQObjectMessage)msg).getObject();
                this.processor.processCustomerSnapshot(snapshot, false);
            }
            catch (JMSException ex) {
                OrderMate.LOG.warn("Could not update customer:", (Throwable)ex);
            }
        }
    }
}

