/*
 * Decompiled with CFR 0.152.
 */
package ordermate.hom.synchronisation.customer;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.synchronisation.PosPersistentObjectCreator;
import au.com.ordermate.persistence.synchronisation.SynchronisationSnapshot;
import au.com.ordermate.sql.SQL;
import java.util.ArrayList;
import java.util.Date;
import java.util.Set;
import ordermate.OrderMate;
import ordermate.database.config.CustomerGroup;
import ordermate.database.config.ExperimentalFeature;
import ordermate.database.sales.Customer;
import ordermate.database.sales.CustomerCategory;
import ordermate.hom.synchronisation.BusinessObjectRequestor;
import ordermate.hom.synchronisation.SyncUpdateProcessor;
import ordermate.hom.synchronisation.customer.CustomerCategoryPrePersistInterceptor;
import ordermate.integration.webservice.RestHelper;

public class CustomerUpdateProcessor
extends SyncUpdateProcessor {
    private final PosPersistentObjectCreator creator = new PosPersistentObjectCreator(this.getIdTranslator());
    private final BusinessObjectRequestor objRequestor;
    private final String idExists = "SELECT modTime from sales_customer where sales_customer.id = ?";
    private boolean skipGroup = false;

    public CustomerUpdateProcessor() {
        this(new RestHelper());
        ExperimentalFeature skipGroupFeature = ExperimentalFeature.find("Download Customer Group");
        if (skipGroupFeature != null) {
            this.skipGroup = skipGroupFeature.getBooleanValue(Boolean.FALSE);
        }
    }

    protected CustomerUpdateProcessor(RestHelper restHelper) {
        this.objRequestor = new BusinessObjectRequestor(restHelper, this.creator, new CustomerCategoryPrePersistInterceptor());
    }

    public Customer retrieveById(long id) {
        return this.objRequestor.fetch(id, Customer.class, Customer.Properties.ID);
    }

    public static Customer fetchCustomerFromHO(long id) {
        return new CustomerUpdateProcessor().retrieveById(id);
    }

    public void processDeletedIds(Set<Long> ids) {
        if (ids == null || ids.size() == 0) {
            return;
        }
        if (ids.contains(null)) {
            throw new IllegalArgumentException("Cannot mark a customer with a null id as being deleted.");
        }
        String sql = SQL.updateBulk("sales_customer", new String[]{"system_state"}, ids.size());
        ArrayList<Object> paramList = new ArrayList<Object>();
        paramList.add("DELETED");
        paramList.addAll(ids);
        PersistenceManager.getPersistenceDelegate().executeUpdate(sql, paramList.toArray());
    }

    public void processCustomerSnapshot(SynchronisationSnapshot snapshot, boolean forceUpdate) {
        Customer incoming;
        OrderMate.LOG.info("Processing customer snapshot:\r\n" + snapshot);
        CustomerCategory cat = null;
        if (!this.objRequestor.fetch(Customer.Properties.CATEGORY, CustomerCategory.class, snapshot, CustomerCategory.Properties.MASTER_ID)) {
            OrderMate.LOG.info("Still going to update, but CustomerCategory master id is unknown:" + snapshot.get(Customer.Properties.CATEGORY.getName()));
        }
        if (!this.skipGroup && !this.objRequestor.fetch(Customer.Properties.CUSTOMER_GROUP, CustomerGroup.class, snapshot, CustomerGroup.Properties.ID)) {
            OrderMate.LOG.info("Still going to update, but CustomerGroup master id is unknown: " + snapshot.get(Customer.Properties.CUSTOMER_GROUP.getName()));
        }
        if ((incoming = (Customer)this.creator.createFromSnapShotContent(snapshot)).getCategory() == null) {
            OrderMate.LOG.info("Using the default category since incoming was null");
            cat = CustomerCategory.getDefaultCategory();
        }
        if (cat != null) {
            incoming.setCategory(cat);
        }
        Date myDate = this.getDateIfExists(incoming.getID());
        if (!forceUpdate && myDate != null && incoming.getMod() != null && myDate.getTime() > incoming.getMod().getTime() - 1000L) {
            OrderMate.LOG.debug("Not going to update, mod date is equal to or before db date:" + incoming.getMod());
            return;
        }
        if (myDate == null) {
            incoming.ensureHasPoints();
        }
        try {
            Number pointsNumber = (Number)snapshot.get(Customer.Properties.LOYALTY_POINTS.getName());
            if (pointsNumber != null) {
                int points = pointsNumber.intValue();
                incoming.getCustomerPoints().setTotalPoints(points);
                incoming.getCustomerPoints().save();
            } else {
                OrderMate.LOG.warn("Incoming points for customer not found.");
            }
        }
        catch (NumberFormatException ex) {
            OrderMate.LOG.error("Incoming points object poorly formed.", (Throwable)ex);
        }
        this.saveToDB(incoming, myDate == null);
    }

    private Date getDateIfExists(Long id) {
        if (id == null) {
            throw new IllegalArgumentException("We should not have a null id for a customer from HO");
        }
        Object[][] result = PersistenceManager.getPersistenceDelegate().executeQuery("SELECT modTime from sales_customer where sales_customer.id = ?", new Object[]{id});
        if (result.length > 0 && result[0].length > 0) {
            if (result[0][0] == null) {
                return new Date(0L);
            }
            return (Date)result[0][0];
        }
        return null;
    }
}

