/*
 * Decompiled with CFR 0.152.
 */
package ordermate.hom.synchronisation.customer;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.synchronisation.SynchronisationSnapshot;
import com.sun.jersey.api.client.WebResource;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import ordermate.OrderMate;
import ordermate.database.misc.HOConfig;
import ordermate.database.misc.StoreGroup;
import ordermate.database.sales.CustomerCategory;
import ordermate.hom.synchronisation.LocalIdTranslator;
import ordermate.hom.synchronisation.customer.CustomerCategoryUpdateProcessor;
import ordermate.hom.synchronisation.customer.CustomerUpdateProcessor;
import ordermate.integration.webservice.RestHelper;
import ordermate.scheduler.Task;

public class FullCustomerUpdateTask
implements Task {
    public static final String RESOURCE = "synchronize/customer/";
    public static final String UPDATE = "activeChanged";
    public static final String DELETED = "deletedChanged";
    public static final String CATEGORIES = "categories";
    private CustomerUpdateProcessor processor;
    private CustomerCategoryUpdateProcessor categoryProcessor;
    private RestHelper helper;

    public FullCustomerUpdateTask() {
    }

    protected FullCustomerUpdateTask(RestHelper yourHelper) {
        this.processor = new CustomerUpdateProcessor(yourHelper);
        this.helper = yourHelper;
    }

    @Override
    public String getName() {
        return "Full Customer Update";
    }

    @Override
    public void run() {
        if (HOConfig.getInstance().isEnabled()) {
            if (this.processor == null) {
                RestHelper yourHelper = new RestHelper();
                this.processor = new CustomerUpdateProcessor(yourHelper);
                this.categoryProcessor = new CustomerCategoryUpdateProcessor();
                this.helper = yourHelper;
            }
            OrderMate.LOG.info("Performing Full Customer Update");
            StringBuilder SB = new StringBuilder(HOConfig.getInstance().getServerLocation()).append(RESOURCE);
            String resourceRoot = SB.toString();
            this.updateCategories(resourceRoot);
            this.updateCustomers(resourceRoot);
        } else {
            OrderMate.LOG.info("HeadOffice is not configured, will not run Customer Updater");
        }
    }

    private void updateCategories(String resourceRoot) {
        OrderMate.LOG.info("Updating Categories...");
        String categoryResource = resourceRoot + CATEGORIES;
        ArrayList list = null;
        WebResource resource = this.helper.getResource(categoryResource);
        resource = this.helper.addBasicAuth(resource, StoreGroup.getInstance().getStoreNumber(), StoreGroup.getInstance().getStoreName());
        list = this.helper.getObject(resource, ArrayList.class);
        LocalIdTranslator translater = new LocalIdTranslator();
        if (list != null) {
            for (SynchronisationSnapshot snapshot : list) {
                Long id = (Long)snapshot.get(CustomerCategory.Properties.ID.getName());
                this.categoryProcessor.processCustomerCategory(snapshot, PersistenceManager.getByID(id = translater.convertToLocalId(id), CustomerCategory.class) == null);
            }
        }
    }

    private void updateCustomers(String resourceRoot) {
        OrderMate.LOG.info("Updating Customer...");
        String activeResource = resourceRoot + UPDATE;
        String deletedResource = resourceRoot + DELETED;
        long newTime = System.currentTimeMillis() - HOConfig.getInstance().getTimeDifference();
        HOConfig config = HOConfig.getInstance();
        long modTime = config.getLastCustomerUpdate().getTime();
        int processed = 1;
        int batchStart = 0;
        int chunkSize = 1000;
        while (processed > 0) {
            processed = this.processDeletedCustomers(batchStart, chunkSize, modTime, deletedResource);
            batchStart += processed;
        }
        processed = 1;
        while (processed > 0) {
            processed = this.processActiveCustomers(batchStart, chunkSize, modTime, activeResource);
            batchStart += processed;
        }
        config.setLastCustomerUpdate(new Date(newTime));
        config.save();
    }

    private int processDeletedCustomers(int start, int max, long modDate, String resourceLocation) {
        WebResource resource = this.helper.getResource(resourceLocation);
        resource = this.helper.addBasicAuth(resource, StoreGroup.getInstance().getStoreNumber(), StoreGroup.getInstance().getStoreName());
        resource = this.helper.addParameter(resource, "modDate", Long.toString(modDate));
        resource = this.helper.addParameter(resource, "start", Integer.toString(start));
        resource = this.helper.addParameter(resource, "max", Integer.toString(max));
        Set set = this.helper.getObject(resource, HashSet.class);
        this.processor.processDeletedIds(set);
        return set == null ? 0 : set.size();
    }

    private int processActiveCustomers(int start, int max, long modDate, String resourceLocation) {
        WebResource resource = this.helper.getResource(resourceLocation);
        resource = this.helper.addBasicAuth(resource, StoreGroup.getInstance().getStoreNumber(), StoreGroup.getInstance().getStoreName());
        resource = this.helper.addParameter(resource, "modDate", Long.toString(modDate));
        resource = this.helper.addParameter(resource, "start", Integer.toString(start));
        List list = this.helper.getObject(resource = this.helper.addParameter(resource, "max", Integer.toString(max)), ArrayList.class);
        if (list != null) {
            for (SynchronisationSnapshot snapshot : list) {
                this.processor.processCustomerSnapshot(snapshot, true);
            }
        }
        return list == null ? 0 : list.size();
    }

    @Override
    public void setData(Object data) {
    }
}

