/*
 * Decompiled with CFR 0.152.
 */
package ordermate.hom.synchronisation.dynamicmenu;

import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import ordermate.OMSemaphore;
import ordermate.OrderMate;
import ordermate.database.inventory.InventoryGroup;
import ordermate.database.inventory.InventoryItem;
import ordermate.database.inventory.InventoryProfileHelper;
import ordermate.integration.dynamicnmenu.MenuIntegrationHelper;
import org.apache.activemq.command.ActiveMQObjectMessage;

public class DynamicMenuItemListener
implements MessageListener {
    private MenuIntegrationHelper helper = new MenuIntegrationHelper(PersistenceManager.getPersistenceDelegate());

    public void onMessage(Message arg0) {
        ActiveMQObjectMessage message = (ActiveMQObjectMessage)arg0;
        try {
            String xmlObject = (String)((Object)message.getObject());
            this.processDynamicMenuItem(xmlObject);
        }
        catch (JMSException ex) {
            OrderMate.LOG.info("Cannot read in dynamic menu item message, will not add.", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processDynamicMenuItem(String xmlObject) {
        if (xmlObject != null) {
            if (OMSemaphore.tryLock(OMSemaphore.Stick.itemDownload, 5000L)) {
                try {
                    InventoryGroup group = PersistenceManager.getObject(InventoryGroup.class, Query.select(InventoryGroup.class).active(InventoryGroup.class).toString());
                    InventoryItem item = this.helper.wrangleItem(xmlObject, group, null);
                    if (item != null) {
                        item.save();
                        InventoryProfileHelper.getInstance().clearCache();
                    }
                    this.logError("Invalid item downloaded, could not be wrangled.");
                }
                catch (Exception ex) {
                    OrderMate.LOG.error("Cannot dynamically download item", (Throwable)ex);
                }
                finally {
                    OMSemaphore.release(OMSemaphore.Stick.itemDownload);
                }
            } else {
                this.logError("Item not downloaded: the itemDownload semaphore was locked for more than 5 seconds.");
            }
        } else {
            this.logError("XML Object passed to DynamicMenuItemListener via a message was null! Item will not be wrangled or persisted.");
        }
    }

    private void logError(String errorString) {
        OrderMate.LOG.error(errorString);
    }
}

