/*
 * Decompiled with CFR 0.152.
 */
package ordermate.hom.synchronisation.general;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PersistentObjectSnapshot;
import au.com.ordermate.persistence.Saveable;
import au.com.ordermate.persistence.SaveableChild;
import au.com.ordermate.persistence.SyncPersistentObjectSnapshot;
import au.com.ordermate.persistence.synchronisation.PersistenceSyncReceiver;
import au.com.ordermate.persistence.synchronisation.PosPersistentObjectCreator;
import au.com.ordermate.persistence.synchronisation.SynchronisationSnapshot;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import ordermate.OrderMate;
import ordermate.database.inventory.triggers.AbstractTrigger;
import ordermate.database.inventory.triggers.DefaultTrigger;
import ordermate.database.inventory.triggers.activation.TriggerActivated;
import ordermate.hom.synchronisation.LocalIdTranslator;
import org.apache.activemq.command.ActiveMQObjectMessage;

public class HeadOfficeObjectMessageListener
implements MessageListener {
    private PosPersistentObjectCreator creator;

    public void onMessage(Message arg0) {
        if (this.creator == null) {
            this.creator = new PosPersistentObjectCreator(new LocalIdTranslator());
        }
        ActiveMQObjectMessage message = (ActiveMQObjectMessage)arg0;
        try {
            SynchronisationSnapshot snapshot = (SynchronisationSnapshot)message.getObject();
            PersistentObject obj = this.creator.createFromSnapShotContent(snapshot);
            SyncPersistentObjectSnapshot snappy = obj.getSnapshot();
            if (PersistenceManager.getByID(obj.getID(), obj.getClass()) == null) {
                snappy = new SyncPersistentObjectSnapshot(snappy);
            }
            long id = PersistenceSyncReceiver.getInstance().saveOrUpdate(snappy);
            this.postHandle(id, snappy);
        }
        catch (JMSException ex) {
            OrderMate.LOG.info("Cannot read in headOfficeUser message, will not activate.", (Throwable)ex);
        }
        catch (Exception ex) {
            OrderMate.LOG.warn("Cannot create or save object from snapshot", (Throwable)ex);
        }
    }

    private void postHandle(long id, PersistentObjectSnapshot snappy) {
        DefaultTrigger trigger;
        Object po;
        if (TriggerActivated.class.isAssignableFrom(snappy.getObjectType()) && (po = PersistenceManager.getByID(id, snappy.getObjectType())) != null && ((TriggerActivated)po).getTriggers().isEmpty() && (trigger = AbstractTrigger.getDefaultTriggerIfExists()) != null) {
            ((TriggerActivated)po).addTrigger(trigger);
            if (po instanceof SaveableChild) {
                ((SaveableChild)po).saveChild();
            } else if (po instanceof Saveable) {
                ((Saveable)po).save();
            }
        }
    }
}

