/*
 * Decompiled with CFR 0.152.
 */
package ordermate.hom.synchronisation.status;

import au.com.ordermate.persistence.PersistenceManager;
import java.util.Date;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import ordermate.OrderMate;
import ordermate.database.misc.SynchronisationStatus;
import ordermate.database.reports.general.NumberReport;

public class SynchronisationStatusManager {
    private final String queueLengthQuery = "SELECT COUNT(ID) AS value FROM system_synchronisation_buffer";
    private final ExecutorService jmsPingerExecutor = Executors.newSingleThreadExecutor();
    public static final int MESSAGE_PERIOD = 600000;
    private static final SynchronisationStatusManager instance = new SynchronisationStatusManager();

    public static synchronized SynchronisationStatusManager getInstance() {
        return instance;
    }

    private SynchronisationStatusManager() {
    }

    public final void startJMSPinger() {
        this.jmsPingerExecutor.submit(this.getJMSPingerTask());
    }

    private Runnable getJMSPingerTask() {
        int MAX_CONSECUTIVE_ERRORS = 30;
        return new Runnable(){

            @Override
            public void run() {
                int consecutiveErrorCount = 0;
                while (consecutiveErrorCount < 30) {
                    try {
                        SynchronisationStatusManager.this.sendStatus();
                        consecutiveErrorCount = 0;
                    }
                    catch (Exception ex) {
                        OrderMate.LOG.warn("Exception in JMSPinger, error count is : " + ++consecutiveErrorCount, (Throwable)ex);
                    }
                    try {
                        Thread.sleep(600000L);
                    }
                    catch (InterruptedException ie) {
                        OrderMate.LOG.info("JMS Pinger shutting down due to interrupted exception");
                        return;
                    }
                }
                OrderMate.LOG.error("Error in JMS Pinger, aborting thread with error count of " + consecutiveErrorCount);
            }
        };
    }

    public void sendStatus() {
        SynchronisationStatus status = this.getSingletonStatus();
        status.setMessageTime(new Date());
        status.setSoftwareVersion(OrderMate.VERSION);
        status.setSyncQueueLength(this.getSyncQueueLength());
        status.save();
        OrderMate.LOG.info("Creating synchronisation status message at :" + status.getMessageTime() + " sync queue length " + status.getSyncQueueLength());
    }

    public SynchronisationStatus getSingletonStatus() {
        SynchronisationStatus status = SynchronisationStatus.getSynchronisationStatus();
        return status != null ? status : new SynchronisationStatus();
    }

    private int getSyncQueueLength() {
        NumberReport report = PersistenceManager.getObject(NumberReport.class, "SELECT COUNT(ID) AS value FROM system_synchronisation_buffer", null);
        if (report != null) {
            return report.intValue();
        }
        return 0;
    }
}

