/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration;

import au.com.ordermate.util.StringUtils;
import com.sun.jersey.core.util.Base64;
import javax.ws.rs.core.Response;
import ordermate.OrderMate;
import ordermate.integration.webservice.PassthroughX509TrustManager;
import ordermate.integration.webservice.RestHelper;
import ordermate.misc.ObjectMarshaller;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.ssl.AllowAllHostnameVerifier;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.StandardHttpRequestRetryHandler;

public abstract class DiamondBackClient {
    private static final String CC_AGENT_HEADER = "CCAgent";
    private static final String CC_AGENT = "AgentBanana";
    private static final String AUTHORIZATION = "Authorization";
    private static final int REQUEST_TIMEOUT_MS = 5000;
    private final RestHelper restHelper = new RestHelper();
    private final PassthroughX509TrustManager trustManager = new PassthroughX509TrustManager();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> T performRequest(Class<T> returnType, HttpUriRequest request) {
        request.setHeader(CC_AGENT_HEADER, new String(Base64.encode((String)CC_AGENT)));
        request.setHeader("Content-Type", ContentType.APPLICATION_JSON.toString());
        request.setHeader("Accept", ContentType.APPLICATION_JSON.toString());
        HttpClientBuilder builder = HttpClientBuilder.create().setRetryHandler((HttpRequestRetryHandler)new StandardHttpRequestRetryHandler(0, false)).setHostnameVerifier((X509HostnameVerifier)new AllowAllHostnameVerifier()).setSslcontext(this.restHelper.getSSLContext(this.trustManager)).setDefaultRequestConfig(RequestConfig.custom().setConnectTimeout(5000).setConnectionRequestTimeout(5000).build());
        CloseableHttpResponse httpResponse = this.tryExecuteRequest(builder, request);
        try {
            if (httpResponse != null) {
                String stringEntity = this.tryReadResponseEntityAndLog(httpResponse);
                if (httpResponse.getStatusLine().getStatusCode() != Response.Status.OK.getStatusCode()) {
                    OrderMate.LOG.error("DiamondBack returned a response of " + httpResponse.getStatusLine().getStatusCode() + " " + httpResponse.getStatusLine().getReasonPhrase() + ".");
                    T t = null;
                    return t;
                }
                T t = new ObjectMarshaller().unmarshal(stringEntity, returnType);
                return t;
            }
        }
        finally {
            this.tryCloseResponse(httpResponse);
        }
        return null;
    }

    protected void setAuthorization(HttpUriRequest request, String usernamePwd) {
        request.setHeader(AUTHORIZATION, "BASIC " + new String(Base64.encode((byte[])usernamePwd.getBytes())));
    }

    private CloseableHttpResponse tryExecuteRequest(HttpClientBuilder builder, HttpUriRequest request) {
        CloseableHttpResponse httpResponse = null;
        try {
            httpResponse = builder.build().execute(request);
        }
        catch (ConnectTimeoutException cte) {
            OrderMate.LOG.error("Connection to DiamondBack timed out, this request will fail.");
            return null;
        }
        catch (Exception e) {
            OrderMate.LOG.error("Failed to send request to DiamondBack!", (Throwable)e);
            return null;
        }
        return httpResponse;
    }

    protected String tryReadResponseEntityAndLog(CloseableHttpResponse response) {
        String entity = "";
        try {
            entity = StringUtils.readFromStream(response.getEntity().getContent(), -1);
            OrderMate.LOG.info("Response string: " + entity);
        }
        catch (Throwable e) {
            OrderMate.LOG.error("Failed to read in the response entity!", e);
        }
        return entity;
    }

    private void tryCloseResponse(CloseableHttpResponse response) {
        if (response != null) {
            try {
                response.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

