/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration;

import au.com.ordermate.simplermi.SimpleRMI;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import ordermate.OrderMate;
import ordermate.database.finance.debtors.transactions.DebtorSale;
import ordermate.database.hardware.Terminal;
import ordermate.database.misc.SystemProperty;
import ordermate.database.misc.license.PersistentLicenseManager;
import ordermate.database.sales.Account;
import ordermate.database.tables.LogicalTableState;
import ordermate.integration.PropertyIntegrator;

public final class PropertyIntegrationUtils {
    private PropertyIntegrationUtils() {
    }

    private static synchronized PropertyIntegrator getPropertyIntegrator() {
        PropertyIntegrator integrator = null;
        if (SystemProperty.getInstance().isPropertyManagementIntegrationEnabled()) {
            try {
                Remote obj = SimpleRMI.getObject(Terminal.getServerMateTerminal().getAddress(), "PropertyIntegrator", 11100);
                if (obj != null) {
                    integrator = (PropertyIntegrator)obj;
                }
            }
            catch (NotBoundException e) {
                OrderMate.LOG.warn(SystemProperty.getInstance().getPropertyIntegration() + " is enabled but not bound to RMI.  Integration will not work.", (Throwable)e);
            }
            catch (RemoteException e) {
                PropertyIntegrationUtils.handleException(e);
            }
            if (!PersistentLicenseManager.getInstance().hasLicenseFor(integrator)) {
                OrderMate.LOG.warn(SystemProperty.getInstance().getPropertyIntegration() + " is enabled but not licensed.  Integration will not work.");
                return null;
            }
        }
        return integrator;
    }

    private static synchronized void handleException(RemoteException e) {
        OrderMate.LOG.warn("Error communicating with Property integration", (Throwable)e);
    }

    public static void synchronize() {
        PropertyIntegrator integrator = PropertyIntegrationUtils.getPropertyIntegrator();
        if (integrator != null) {
            try {
                integrator.synchronize();
            }
            catch (RemoteException e) {
                PropertyIntegrationUtils.handleException(e);
            }
        }
    }

    public static void writeZReads() {
        PropertyIntegrator integrator = PropertyIntegrationUtils.getPropertyIntegrator();
        if (integrator != null) {
            try {
                integrator.writeZReads();
            }
            catch (RemoteException e) {
                PropertyIntegrationUtils.handleException(e);
            }
        }
    }

    public static void accountCreated(final Account account) {
        final PropertyIntegrator integrator = PropertyIntegrationUtils.getPropertyIntegrator();
        if (integrator != null) {
            Thread syncThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        integrator.accountCreated(account);
                    }
                    catch (RemoteException e) {
                        PropertyIntegrationUtils.handleException(e);
                    }
                }
            }, "Integration call thread");
            PropertyIntegrationUtils.executeThread(syncThread, integrator);
        }
    }

    private static void executeThread(Thread thread, PropertyIntegrator integrator) {
        try {
            if (SystemProperty.getInstance().getOnThreadIntegration() && !integrator.isOffThread()) {
                thread.run();
            } else {
                thread.start();
            }
        }
        catch (RemoteException e) {
            PropertyIntegrationUtils.handleException(e);
        }
    }

    public static void receiptPrinted(final Account printed) {
        PropertyIntegrator integrator = PropertyIntegrationUtils.getPropertyIntegrator();
        if (integrator != null) {
            Thread syncThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    PropertyIntegrator integrator = PropertyIntegrationUtils.getPropertyIntegrator();
                    if (integrator != null) {
                        try {
                            integrator.receiptPrinted(printed);
                        }
                        catch (RemoteException e) {
                            PropertyIntegrationUtils.handleException(e);
                        }
                    }
                }
            }, "Integration call thread");
            PropertyIntegrationUtils.executeThread(syncThread, integrator);
        }
    }

    public static void transactionsCreated(final DebtorSale sale) {
        PropertyIntegrator integrator = PropertyIntegrationUtils.getPropertyIntegrator();
        if (integrator != null) {
            Thread syncThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    PropertyIntegrator integrator = PropertyIntegrationUtils.getPropertyIntegrator();
                    if (integrator != null) {
                        try {
                            integrator.transactionsCreated(sale);
                        }
                        catch (RemoteException e) {
                            PropertyIntegrationUtils.handleException(e);
                        }
                    }
                }
            }, "Integration call thread");
            PropertyIntegrationUtils.executeThread(syncThread, integrator);
        }
    }

    public static void accountClosed(final Account closed) {
        PropertyIntegrator integrator = PropertyIntegrationUtils.getPropertyIntegrator();
        if (integrator != null) {
            Thread syncThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    PropertyIntegrator integrator = PropertyIntegrationUtils.getPropertyIntegrator();
                    if (integrator != null) {
                        try {
                            integrator.accountClosed(closed);
                        }
                        catch (RemoteException e) {
                            PropertyIntegrationUtils.handleException(e);
                        }
                    }
                }
            }, "Integration call thread");
            PropertyIntegrationUtils.executeThread(syncThread, integrator);
        }
    }

    public static void tableStateUpdated(final Account updated, final LogicalTableState state) {
        PropertyIntegrator integrator = PropertyIntegrationUtils.getPropertyIntegrator();
        if (integrator != null) {
            Thread syncThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    PropertyIntegrator integrator = PropertyIntegrationUtils.getPropertyIntegrator();
                    if (integrator != null) {
                        try {
                            integrator.tableStateUpdated(updated, state);
                        }
                        catch (RemoteException e) {
                            PropertyIntegrationUtils.handleException(e);
                        }
                    }
                }
            }, "Integration call thread");
            PropertyIntegrationUtils.executeThread(syncThread, integrator);
        }
    }
}

