/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration;

import au.com.ordermate.simplermi.SimpleRMI;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import ordermate.OrderMate;
import ordermate.database.hardware.Terminal;
import ordermate.database.misc.SystemProperty;
import ordermate.database.misc.enums.ReservationIntegrationType;
import ordermate.database.misc.license.LicenseType;
import ordermate.database.misc.license.PersistentLicenseManager;
import ordermate.database.sales.Account;
import ordermate.database.sales.TableAccount;
import ordermate.database.sales.reservation.Reservation;
import ordermate.database.sales.reservation.ReservationsHelper;
import ordermate.database.tables.LogicalTableState;
import ordermate.integration.reservations.ReservationIntegrator;

public final class ReservationIntegrationUtils {
    private static ReservationIntegrator.ReservationTwoWay defaultTwoWay = ReservationIntegrator.ReservationTwoWay.Unsupported;
    private static ReservationIntegrator forcedIntegrator;

    public static void setForcedIntegrator(ReservationIntegrator useThis) {
        forcedIntegrator = useThis;
    }

    private ReservationIntegrationUtils() {
    }

    private static synchronized ReservationIntegrator getReservationIntegrator() {
        if (forcedIntegrator != null) {
            return forcedIntegrator;
        }
        ReservationIntegrator integrator = null;
        if (!ReservationIntegrationType.NONE.equals((Object)SystemProperty.getInstance().getReservationIntegration())) {
            try {
                Remote obj = SimpleRMI.getObject(Terminal.getServerMateTerminal().getAddress(), "ReservationIntegrator", 11100);
                if (obj != null) {
                    integrator = (ReservationIntegrator)obj;
                }
            }
            catch (NotBoundException e) {
                OrderMate.LOG.warn((Object)((Object)SystemProperty.getInstance().getReservationIntegration()) + " is enabled but not bound to RMI.  Integration will not work.", (Throwable)e);
            }
            catch (RemoteException e) {
                ReservationIntegrationUtils.handleException(e);
            }
            if (!PersistentLicenseManager.getInstance().getBoolean(LicenseType.ReservationIntegrationEnabled)) {
                OrderMate.LOG.warn((Object)((Object)SystemProperty.getInstance().getReservationIntegration()) + " is enabled but not licensed. Reservation Integration will not work.");
                return null;
            }
        }
        return integrator;
    }

    private static synchronized void handleException(RemoteException e) {
        OrderMate.LOG.warn("Error communicating with Reservation integration", (Throwable)e);
    }

    public static void synchronize() {
        ReservationIntegrator integrator = ReservationIntegrationUtils.getReservationIntegrator();
        if (integrator != null) {
            try {
                integrator.synchronize();
            }
            catch (RemoteException e) {
                ReservationIntegrationUtils.handleException(e);
            }
        }
    }

    private static void executeThread(Thread thread, ReservationIntegrator integrator) {
        try {
            if (SystemProperty.getInstance().getOnThreadIntegration() && !integrator.isOffThread()) {
                thread.run();
            } else {
                thread.start();
            }
        }
        catch (RemoteException e) {
            ReservationIntegrationUtils.handleException(e);
        }
    }

    public static void receiptPrinted(final Account printed) {
        final ReservationIntegrator integrator = ReservationIntegrationUtils.getReservationIntegrator();
        if (integrator != null) {
            Thread syncThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        integrator.receiptPrinted(printed);
                    }
                    catch (RemoteException e) {
                        ReservationIntegrationUtils.handleException(e);
                    }
                }
            }, "Integration call thread");
            ReservationIntegrationUtils.executeThread(syncThread, integrator);
        }
    }

    public static void accountClosed(final Account closed) {
        final ReservationIntegrator integrator = ReservationIntegrationUtils.getReservationIntegrator();
        if (integrator != null) {
            Thread syncThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        integrator.accountClosed(closed);
                    }
                    catch (RemoteException e) {
                        ReservationIntegrationUtils.handleException(e);
                    }
                }
            }, "Integration call thread");
            ReservationIntegrationUtils.executeThread(syncThread, integrator);
        }
    }

    public static void tableStateUpdated(final Account updated, final LogicalTableState state) {
        final ReservationIntegrator integrator = ReservationIntegrationUtils.getReservationIntegrator();
        if (integrator != null) {
            Thread syncThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        integrator.tableStateUpdated(updated, state);
                    }
                    catch (RemoteException e) {
                        ReservationIntegrationUtils.handleException(e);
                    }
                }
            }, "Integration call thread");
            ReservationIntegrationUtils.executeThread(syncThread, integrator);
        }
    }

    public static void accountLinkedToReservation(final Account account, final Reservation reservation) {
        final ReservationIntegrator integrator = ReservationIntegrationUtils.getReservationIntegrator();
        if (integrator != null) {
            Thread syncThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        integrator.accountLinkedToReservation(account, reservation);
                    }
                    catch (RemoteException e) {
                        ReservationIntegrationUtils.handleException(e);
                    }
                }
            }, "Integration call thread");
            syncThread.start();
        }
    }

    public static void reservationUpdated(final Reservation reservation) {
        if (!ReservationIntegrationUtils.isCloudReservationsConfigured()) {
            return;
        }
        Thread syncThread = new Thread(new Runnable(){

            @Override
            public void run() {
                ReservationIntegrator integrator = ReservationIntegrationUtils.getReservationIntegrator();
                if (integrator != null) {
                    try {
                        integrator.reservationUpdated(reservation);
                    }
                    catch (RemoteException e) {
                        ReservationIntegrationUtils.handleException(e);
                    }
                }
            }
        }, "Integration call thread");
        syncThread.start();
    }

    public static void reservationAccountCreated(final Account account) {
        Thread syncThread = new Thread(new Runnable(){

            @Override
            public void run() {
                ReservationIntegrator integrator = ReservationIntegrationUtils.getReservationIntegrator();
                if (integrator != null) {
                    try {
                        integrator.reservationAccountCreated(account, account.getDuration());
                    }
                    catch (RemoteException e) {
                        ReservationIntegrationUtils.handleException(e);
                    }
                }
            }
        }, "Integration call thread");
        syncThread.start();
    }

    public static void reservationAccountUpdated(final Account account) {
        if (!(account instanceof TableAccount) || !ReservationIntegrationUtils.isCloudReservationsConfigured()) {
            return;
        }
        Thread syncThread = new Thread(new Runnable(){

            @Override
            public void run() {
                ReservationIntegrator integrator = ReservationIntegrationUtils.getReservationIntegrator();
                if (integrator != null) {
                    try {
                        for (Reservation res : ReservationsHelper.getReservationsForTableAccount((TableAccount)account)) {
                            integrator.reservationUpdated(res);
                        }
                    }
                    catch (RemoteException e) {
                        ReservationIntegrationUtils.handleException(e);
                    }
                }
            }
        }, "Account Update");
        syncThread.start();
    }

    public static void reservationTableClosed(final Reservation reservation) {
        Thread syncThread = new Thread(new Runnable(){

            @Override
            public void run() {
                ReservationIntegrator integrator = ReservationIntegrationUtils.getReservationIntegrator();
                if (integrator != null) {
                    try {
                        integrator.reservationTableClosed(reservation);
                    }
                    catch (RemoteException e) {
                        ReservationIntegrationUtils.handleException(e);
                    }
                }
            }
        }, "Integration call thread");
        syncThread.start();
    }

    public static void reservationAccountTransferred(final Account source, final Account target, final boolean isNew) {
        Thread syncThread = new Thread(new Runnable(){

            @Override
            public void run() {
                ReservationIntegrator integrator = ReservationIntegrationUtils.getReservationIntegrator();
                if (integrator != null) {
                    try {
                        if (isNew || ReservationIntegrationType.DIAMONDBACK.equals((Object)SystemProperty.getInstance().getReservationIntegration())) {
                            integrator.reservationAccountTransferred(source, target, target.getDuration());
                        }
                    }
                    catch (RemoteException e) {
                        ReservationIntegrationUtils.handleException(e);
                    }
                }
            }
        }, "Integration call thread");
        syncThread.start();
    }

    public static synchronized void clearReservations() {
        Thread syncThread = new Thread(new Runnable(){

            @Override
            public void run() {
                ReservationIntegrator integrator = ReservationIntegrationUtils.getReservationIntegrator();
                if (integrator != null) {
                    try {
                        integrator.clearReservations();
                    }
                    catch (RemoteException e) {
                        ReservationIntegrationUtils.handleException(e);
                    }
                }
            }
        }, "Integration call thread");
        syncThread.start();
    }

    public static boolean isCloudReservationsConfigured() {
        ReservationIntegrationType type = SystemProperty.getInstance().getReservationIntegration();
        return type != null && !ReservationIntegrationType.NONE.equals((Object)type);
    }

    public static ReservationIntegrator.ReservationTwoWay getTwoWayIntegration() {
        ReservationIntegrator integrator = ReservationIntegrationUtils.getReservationIntegrator();
        try {
            if (integrator != null) {
                return integrator.getTwoWayIntegration();
            }
        }
        catch (RemoteException e) {
            OrderMate.LOG.error("Couldn't determine two-way, defaulting to Unsupported");
        }
        return defaultTwoWay;
    }
}

