/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.automatedsalesandvariance;

import au.com.ordermate.configuration.Config;
import au.com.ordermate.guicore.task.CompositeTask;
import au.com.ordermate.guicore.task.ProgressLogger;
import au.com.ordermate.persistence.PersistenceClientSetupTask;
import java.io.File;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import ordermate.OrderMate;
import ordermate.database.hardware.Terminal;
import ordermate.integration.automatedsalesandvariance.SalesAndVarianceReport;
import ordermate.startup.ConfigurationTask;
import ordermate.startup.LoggerSetupTask;
import ordermate.startup.RMIStartupTask;
import ordermate.startup.ServerConnectionSetupTask;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.LoggerContext;

public class AutomatedExport {
    private static Logger LOG;
    private static final String WEEK = "/week";
    private static final String FORTNIGHT = "/fortnight";
    private static final String MONTH = "/month";
    private static String mode;
    private static int month;
    private static Date startDay;
    private static Date endDay;

    public static void main(String[] args) {
        new LoggerSetupTask("AutomatedExport").run();
        LOG = LoggerContext.getContext((boolean)false).getLogger("AutomatedExport");
        LOG.info("Starting Cash and Variance Export");
        try {
            AutomatedExport.parseCommandLines(args);
        }
        catch (IllegalArgumentException ex) {
            LOG.fatal("Could not start Automated export version " + OrderMate.VERSION + " incorrect command line arguments", (Throwable)ex);
            System.exit(1);
        }
        try {
            AutomatedExport.startup();
        }
        catch (Exception e) {
            LOG.fatal("Error starting up", (Throwable)e);
            System.exit(1);
        }
        Date[] range = AutomatedExport.getDateRange();
        startDay = range[0];
        endDay = range[1];
        try {
            SalesAndVarianceReport exporter = new SalesAndVarianceReport(startDay, endDay);
            exporter.setLogger(LOG);
            Object[] files = exporter.export();
            try {
                exporter.transmit((File[])files);
            }
            catch (Exception e) {
                LOG.warn("Error trasmitting the reports " + Arrays.toString(files), (Throwable)e);
                System.exit(1);
            }
        }
        catch (Exception e) {
            LOG.fatal("Error generating the reports.", (Throwable)e);
            System.exit(1);
        }
        LOG.info("Automated Export complete");
        System.exit(0);
    }

    private static Date[] getDateRange() {
        Date[] range = new Date[2];
        range = mode.equals(WEEK) ? AutomatedExport.getWeekRange() : (mode.equals(FORTNIGHT) ? AutomatedExport.getFortnightlyRange() : AutomatedExport.getMonthlyDateRange());
        return range;
    }

    private static Date[] getFortnightlyRange() {
        Date[] dateRange = new Date[2];
        GregorianCalendar end = new GregorianCalendar();
        int today = end.get(7);
        int offset = 1 - today;
        if (offset == 0) {
            offset = -7;
        }
        ((Calendar)end).add(5, offset);
        dateRange[1] = end.getTime();
        GregorianCalendar start = new GregorianCalendar();
        start.setTime(dateRange[1]);
        ((Calendar)start).add(5, -13);
        dateRange[0] = start.getTime();
        return dateRange;
    }

    private static Date[] getWeekRange() {
        Date[] dateRange = new Date[2];
        GregorianCalendar end = new GregorianCalendar();
        int today = end.get(7);
        int offset = 1 - today;
        if (offset == 0) {
            offset = -7;
        }
        ((Calendar)end).add(5, offset);
        dateRange[1] = end.getTime();
        GregorianCalendar start = new GregorianCalendar();
        start.setTime(dateRange[1]);
        ((Calendar)start).add(5, -6);
        dateRange[0] = start.getTime();
        return dateRange;
    }

    private static Date[] getMonthlyDateRange() {
        Date[] dateRange = new Date[2];
        GregorianCalendar start = new GregorianCalendar();
        GregorianCalendar end = new GregorianCalendar();
        if (month >= 0) {
            start.set(2, month);
            end.set(2, month);
            if (start.get(2) >= new GregorianCalendar().get(2)) {
                ((Calendar)start).add(1, -1);
                ((Calendar)end).add(1, -1);
            }
        } else {
            ((Calendar)start).add(2, -1);
            ((Calendar)end).add(2, -1);
        }
        start.set(5, 1);
        dateRange[0] = start.getTime();
        int lastDay = ((Calendar)end).getActualMaximum(5);
        end.set(5, lastDay);
        dateRange[1] = end.getTime();
        return dateRange;
    }

    private static void parseCommandLines(String[] args) throws IllegalArgumentException {
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.equals(WEEK)) {
                mode = WEEK;
                continue;
            }
            if (arg.equals(FORTNIGHT)) {
                mode = FORTNIGHT;
                continue;
            }
            if (arg.startsWith(MONTH)) {
                mode = MONTH;
                if (arg.indexOf(58) < 0) continue;
                String theMonth = arg.substring(arg.indexOf(58) + 1);
                try {
                    month = Integer.parseInt(theMonth);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("The month must be specified as a number between 1 and 12");
                }
                if (month > 12 || month < 1) {
                    throw new IllegalArgumentException("The specified month must be between 1 and 12");
                }
                --month;
                continue;
            }
            throw new IllegalArgumentException("Unknown command line argument " + arg);
        }
        if (args.length == 0) {
            throw new IllegalArgumentException("No date range specified.  Must be one of /week or /fortnight or /month");
        }
    }

    private static void startup() throws Exception {
        int EXPORT_RMI_PORT = 11104;
        CompositeTask startup = new CompositeTask("Starting Automated Export");
        startup.addTask(new ConfigurationTask("AutomatedExportConfig.ini"));
        startup.addTask(new RMIStartupTask(11104));
        startup.addTask(new ServerConnectionSetupTask(null, "Integration"));
        startup.addTask(new PersistenceClientSetupTask(true, 11104));
        startup.run();
        startup.taskStarted.connect(new ProgressLogger(), "logProgress");
        List<String> servers = Config.getStringListValue("app_server");
        Terminal.setupServerMate(servers.get(0));
    }

    static {
        mode = "";
        month = -1;
    }
}

