/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.automatedsalesandvariance;

import au.com.ordermate.util.DateTimeUtils;
import java.io.File;
import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.Future;
import ordermate.OrderMate;
import ordermate.database.misc.StoreGroup;
import ordermate.database.misc.TradingDay;
import ordermate.integration.automatedsalesandvariance.SalesAndVarianceReport;
import ordermate.scheduler.RetryingExecutor;
import ordermate.scheduler.Task;

public class AutomatedExportTask
implements Task {
    public static final String NAME = "Monthly Automated Export";
    private TradingDay day;
    private RetryingExecutor retransmit;
    private RetryingExecutor transmit;

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void run() {
        if (this.transmit != null && !this.transmit.getFuture().isDone()) {
            throw new IllegalStateException("The transmission task is already running!");
        }
        if (this.retransmit != null && !this.retransmit.getFuture().isDone()) {
            OrderMate.LOG.warn("Cancel the current retransmit task.");
            this.retransmit.getFuture().cancel(true);
        }
        this.transmit = null;
        this.retransmit = null;
        if (!StoreGroup.getInstance().isSet()) {
            OrderMate.LOG.info("Store Group not set, no Monthly Automated Export to create.");
            return;
        }
        Date monthLastExport = StoreGroup.getInstance().getMonthLastExport();
        Calendar calLast = Calendar.getInstance();
        if (monthLastExport != null) {
            calLast.setTime(monthLastExport);
        } else {
            calLast = DateTimeUtils.getEndOfPreviousMonth(new Date());
        }
        int mmLast = calLast.get(2);
        int yyLast = calLast.get(1);
        Calendar calCurrent = Calendar.getInstance();
        if (this.day != null) {
            calCurrent.setTime(this.day.getCloseDate());
        }
        int mmCurrent = calCurrent.get(2);
        int yyCurrent = calCurrent.get(1);
        if (mmCurrent != mmLast || yyCurrent != yyLast) {
            this.runTransmit(mmLast, yyLast, mmCurrent, yyCurrent);
        } else if (StoreGroup.getInstance().getMonthToTransmit() != null) {
            this.runRetransmit();
        }
    }

    @Override
    public void setData(Object data) {
        if (data instanceof TradingDay) {
            this.day = (TradingDay)data;
        }
    }

    public Future getTransmitFuture() {
        if (this.transmit == null) {
            return null;
        }
        return this.transmit.getFuture();
    }

    public Future getRetransmitFuture() {
        if (this.retransmit == null) {
            return null;
        }
        return this.retransmit.getFuture();
    }

    private void runRetransmit() {
        OrderMate.LOG.info("Retry to send the report for " + StoreGroup.getInstance().getMonthToTransmit());
        Date date = StoreGroup.getInstance().getMonthToTransmit();
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int yy = cal.get(1);
        int mm = cal.get(2);
        Date[] range = DateTimeUtils.getMonthlyDateRange(yy, mm);
        final SalesAndVarianceReport report = new SalesAndVarianceReport(range[0], range[1]);
        this.retransmit = new RetryingExecutor(600000L){

            @Override
            public void execute() throws Exception {
                report.retransmit();
            }
        };
    }

    private void runTransmit(int mmLast, int yyLast, int mmCurrent, int yyCurrent) {
        OrderMate.LOG.info("The task is running for " + (mmLast + 1) + "-" + yyLast + " as we are now " + (mmCurrent + 1) + "-" + yyCurrent);
        try {
            Date[] range = DateTimeUtils.getMonthlyDateRange(yyLast, mmLast);
            final SalesAndVarianceReport report = new SalesAndVarianceReport(range[0], range[1]);
            final File[] files = report.export();
            this.transmit = new RetryingExecutor(600000L){

                @Override
                public void execute() throws Exception {
                    report.transmit(files);
                }
            };
            StoreGroup.getInstance().setMonthLastExport(new Date());
            StoreGroup.getInstance().save();
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Unable to produce the reports.", (Throwable)ex);
        }
    }
}

