/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.automatedsalesandvariance;

import au.com.ordermate.configuration.Config;
import au.com.ordermate.message.Email;
import au.com.ordermate.message.MessageServer;
import au.com.ordermate.util.StringUtils;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.sql.Date;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.mail.SendFailedException;
import javax.mail.internet.InternetAddress;
import ordermate.OrderMate;
import ordermate.database.EventContext;
import ordermate.database.finance.debtors.DebtorPaymentAgent;
import ordermate.database.finance.debtors.transactions.DebtorPayment;
import ordermate.database.finance.debtors.transactions.DebtorSale;
import ordermate.database.finance.transactions.ExportTransaction;
import ordermate.database.finance.transactions.FinanceTransactionContext;
import ordermate.database.hardware.Terminal;
import ordermate.database.misc.StoreGroup;
import ordermate.database.misc.SystemProperty;
import ordermate.database.queries.finance.debtors.DebtorQueries;
import ordermate.database.reports.periodstock.PeriodStockAreaReport;
import ordermate.database.reports.periodstock.PeriodStockAreaReportItem;
import ordermate.database.stock.StockArea;
import ordermate.database.stock.StockTake;
import ordermate.database.users.User;
import ordermate.integration.automatedsalesandvariance.BunningsPeriodStockReportItem;
import ordermate.integration.automatedsalesandvariance.ReportHelper;
import ordermate.integration.automatedsalesandvariance.SalesItemReport;
import ordermate.integration.automatedsalesandvariance.VarianceReport;
import ordermate.integration.cloudback.OMOutgoingServiceResponse;
import ordermate.integration.cloudback.nudge.NudgeManager;
import ordermate.maps.finance.debtors.DebtorSaleMap;
import org.apache.logging.log4j.core.Logger;

public class SalesAndVarianceReport {
    private static final int REPORTS_NB_TO_GENERATE = 4;
    private Logger logger = OrderMate.LOG;
    private final java.util.Date startDay;
    private final java.util.Date endDay;
    private final String startDayLabel;
    private final String endDayLabel;
    private final DateFormat formatter = new SimpleDateFormat("dd-MM-yy");
    private final String fileLocation;
    private final List emailAddresses;
    private final StockTake startStockTake;
    private final StockTake endStockTake;
    private boolean emailSent = false;

    public SalesAndVarianceReport(java.util.Date startDay, java.util.Date endDay) {
        this(startDay, endDay, null);
    }

    public SalesAndVarianceReport(java.util.Date startDay, java.util.Date endDay, List emails) {
        if (!SystemProperty.getInstance().isSinglePaymentMode() && !Config.isDebuging()) {
            throw new IllegalStateException("The system must be in Single Payment Mode. Exiting without exporting.");
        }
        if (StockArea.getStockAreas().size() > 1 && !Config.isDebuging()) {
            throw new IllegalStateException("The system must only have one stock area. Exiting without exporting.");
        }
        if (startDay == null) {
            throw new IllegalArgumentException("Start date should not be null");
        }
        if (endDay == null) {
            throw new IllegalArgumentException("End date should not be null");
        }
        this.startDay = startDay;
        this.endDay = endDay;
        String location = StoreGroup.getExistingOutputDir() + File.separatorChar;
        this.getLogger().info("Will export into " + location);
        this.fileLocation = location;
        this.startDayLabel = this.formatter.format(startDay);
        this.endDayLabel = this.formatter.format(endDay);
        List stockTakes = StockTake.getStockTakesWithinDateRange(startDay, endDay);
        if (stockTakes.size() < 1) {
            this.getLogger().warn("Date range : " + this.startDayLabel + " - " + this.endDayLabel + " does not span a stock take, cannot produce a period stock report.");
            this.startStockTake = null;
            this.endStockTake = null;
        } else {
            StockTake firstInRange = (StockTake)stockTakes.get(0);
            this.endStockTake = (StockTake)stockTakes.get(stockTakes.size() - 1);
            StockTake previous = firstInRange.getPreviousStockTake();
            this.startStockTake = previous != null ? previous : firstInRange;
        }
        this.emailAddresses = emails == null || emails.size() == 0 ? this.getRecipients(StoreGroup.getInstance().getEmailAddress()) : emails;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public File[] export() throws Exception {
        File[] files = new File[4];
        this.getLogger().info("Exporting Sales Report for " + this.startDayLabel + " to " + this.endDayLabel);
        files[0] = this.doSalesReport();
        this.getLogger().info("Sales Report export complete");
        this.getLogger().info("Exporting Account Sales Report for " + this.startDayLabel + " to " + this.endDayLabel);
        files[1] = this.doDebtorSalesReport();
        this.getLogger().info("Account Sales Report export complete");
        this.getLogger().info("Exporting Variance Report for " + this.startDayLabel + " to " + this.endDayLabel);
        files[2] = this.doVarianceReport();
        this.getLogger().info("Variance Report export complete");
        files[3] = this.doPeriodStockReport();
        this.getLogger().info("Period stock report complete");
        this.getLogger().info("Exporting debtor sales");
        this.exportDebtorSales();
        this.getLogger().info("Debtor sales export complete");
        return files;
    }

    public void transmit(File[] files) throws SendFailedException {
        if (!this.emailAddresses.isEmpty()) {
            StoreGroup.getInstance().setMonthToTransmit(this.endDay);
            StoreGroup.getInstance().save();
            if (!NudgeManager.isNudgeConfigured()) {
                MessageServer.getServer().connect();
                if (!MessageServer.getServer().isSmtpConnected()) {
                    throw new SendFailedException("Could not connect to the SMTP server, e-mail will not be sent");
                }
            }
            this.getLogger().info("Emailing Sales Report to " + this.emailAddresses);
            this.sendEmail(StoreGroup.getInstance().getStoreNumber() + " " + StoreGroup.getInstance().getStoreName() + " sales for " + this.formatter.format(this.startDay) + " to " + this.formatter.format(this.endDay), files);
            this.getLogger().info("Sales Variance report email successfully sent");
        } else {
            this.getLogger().info("Ooops, no one into the email adresses, cannot e-mail the result.");
        }
        StoreGroup.getInstance().setMonthToTransmit(null);
        StoreGroup.getInstance().save();
    }

    public void retransmit() throws SendFailedException {
        File debtorSaleReportFile;
        File saleReportFile;
        File varianceReportFile;
        ArrayList<File> files = new ArrayList<File>();
        File periodStockReportFile = this.getPeriodStockReportFile();
        if (periodStockReportFile != null && periodStockReportFile.exists()) {
            files.add(periodStockReportFile);
        }
        if ((varianceReportFile = this.getVarianceReportFile()).exists()) {
            files.add(varianceReportFile);
        }
        if ((saleReportFile = this.getSaleReportFile()) != null && saleReportFile.exists()) {
            files.add(saleReportFile);
        }
        if ((debtorSaleReportFile = this.getDebtorSaleReportFile()) != null && debtorSaleReportFile.exists()) {
            files.add(debtorSaleReportFile);
        }
        if (files.size() > 0) {
            this.transmit(files.toArray(new File[files.size()]));
            if (files.size() != 4) {
                this.getLogger().warn("Found only these files: " + files);
            }
        } else {
            this.getLogger().warn("Could not find any file to transmit for " + this.startDayLabel);
            StoreGroup.getInstance().setMonthToTransmit(null);
            StoreGroup.getInstance().setMonthLastExport(null);
            StoreGroup.getInstance().save();
        }
    }

    private File doPeriodStockReport() throws Exception {
        if (this.startStockTake != null && this.endStockTake != null) {
            PeriodStockAreaReport report = new PeriodStockAreaReport(this.startStockTake, this.endStockTake);
            ArrayList<BunningsPeriodStockReportItem> bunningsReportItems = new ArrayList<BunningsPeriodStockReportItem>();
            Iterator<PeriodStockAreaReportItem> it = report.getReportItems(StockArea.getStockAreas()).iterator();
            while (it.hasNext()) {
                bunningsReportItems.add(new BunningsPeriodStockReportItem(report, it.next()));
            }
            File file = this.getPeriodStockReportFile();
            FileWriter fwriter = new FileWriter(file);
            ReportHelper.writeCSVToFile((Writer)fwriter, BunningsPeriodStockReportItem.getHeadings(), bunningsReportItems);
            return file;
        }
        return null;
    }

    private File doSalesReport() throws Exception {
        SalesItemReport report = new SalesItemReport(this.startDay, this.endDay, StoreGroup.getInstance().getStoreNumber(), StoreGroup.getInstance().getStoreName());
        List<? extends SalesItemReport> reportEntries = report.generateReport(SalesItemReport.SalesItemReportType.NormalSales);
        File file = this.getSaleReportFile();
        FileWriter fwriter = new FileWriter(file);
        ReportHelper.writeCSVToFile((Writer)fwriter, SalesItemReport.getHeadings(), reportEntries);
        return file;
    }

    private File doDebtorSalesReport() throws Exception {
        SalesItemReport report = new SalesItemReport(this.startDay, this.endDay, StoreGroup.getInstance().getStoreNumber(), StoreGroup.getInstance().getStoreName());
        List<? extends SalesItemReport> reportEntries = report.generateReport(SalesItemReport.SalesItemReportType.DebtorSales);
        File file = this.getDebtorSaleReportFile();
        FileWriter fwriter = new FileWriter(file);
        ReportHelper.writeCSVToFile((Writer)fwriter, SalesItemReport.getHeadings(), reportEntries);
        return file;
    }

    private File doVarianceReport() throws Exception {
        Object[][] rs = VarianceReport.getVarianceReport(StoreGroup.getInstance().getStoreNumber(), StoreGroup.getInstance().getStoreName(), new Date(this.startDay.getTime()), new Date(this.endDay.getTime()));
        File file = this.getVarianceReportFile();
        FileWriter fwriter = new FileWriter(file);
        ReportHelper.writeCSVToFile((Writer)fwriter, VarianceReport.getHeadings(), rs);
        return file;
    }

    private void exportDebtorSales() throws Exception {
        List<DebtorSale> debtorSales = DebtorSaleMap.getSalesBetweenDatesForDebtors(this.startDay, this.endDay, DebtorQueries.getAllDebtors());
        for (DebtorSale currentSale : debtorSales) {
            if (currentSale.isPaid()) continue;
            ExportTransaction tran = new ExportTransaction(currentSale.getAmountOutstanding(), new FinanceTransactionContext(new EventContext(Terminal.getServerMateTerminal(), User.getSystemUser()), null));
            DebtorPaymentAgent payable = new DebtorPaymentAgent(currentSale.getDebtor());
            DebtorPayment exportPayment = new DebtorPayment(currentSale.getDebtor(), tran, tran.getPaid());
            ArrayList<DebtorPayment> paymentList = new ArrayList<DebtorPayment>();
            paymentList.add(exportPayment);
            currentSale.setPayments(paymentList);
            currentSale.setExported(true);
            currentSale.saveChild();
            payable.pay();
        }
    }

    private File getPeriodStockReportFile() {
        if (this.startStockTake != null && this.endStockTake != null) {
            return new File(this.fileLocation + "Period_stock_" + this.formatter.format(this.startStockTake.getDate()) + "_to_" + this.formatter.format(this.endStockTake.getDate()) + ".csv");
        }
        return null;
    }

    private File getSaleReportFile() {
        return new File(this.fileLocation + "Sales_" + this.startDayLabel + "_to_" + this.endDayLabel + ".csv");
    }

    private File getDebtorSaleReportFile() {
        return new File(this.fileLocation + "Account_Sales_" + this.startDayLabel + "_to_" + this.endDayLabel + ".csv");
    }

    private File getVarianceReportFile() {
        return new File(this.fileLocation + "Variance_" + this.startDayLabel + "_to_" + this.endDayLabel + ".csv");
    }

    private void sendEmail(String subject, File[] files) throws SendFailedException {
        Email salesEmail = new Email();
        salesEmail.addReplyTo("support@ordermate.com.au", "OrderMate");
        salesEmail.setSubject(subject);
        String emailSender = SystemProperty.getInstance().getEmailSender();
        if (!StringUtils.isEmpty(emailSender)) {
            salesEmail.addSender(emailSender, emailSender);
        } else {
            salesEmail.addSender("support@ordermate.com.au", "OrderMate");
        }
        for (String address : this.emailAddresses) {
            try {
                InternetAddress emailAdd = new InternetAddress(address);
                salesEmail.addToRecipient(emailAdd);
            }
            catch (Exception e) {
                this.getLogger().warn("Invalid address in the configuration.", (Throwable)e);
            }
        }
        if (salesEmail.getToRecipients().length == 0) {
            this.getLogger().warn("Ooops, no recipients, will fails.");
        }
        salesEmail.setText(subject);
        for (int i = 0; i < files.length; ++i) {
            if (files[i] == null) continue;
            salesEmail.addAttachment(files[i]);
        }
        if (NudgeManager.isNudgeConfigured()) {
            OMOutgoingServiceResponse nudgeResponse = NudgeManager.getInstance().sendEmail(salesEmail);
            this.emailSent = nudgeResponse.isSuccessful();
        } else if (!MessageServer.getServer().send(salesEmail.createMessage(MessageServer.getServer().getSession()))) {
            throw new SendFailedException("Failed to send the " + subject + " message.");
        }
    }

    private List getRecipients(String recipientList) {
        ArrayList<String> recipientEmails = new ArrayList<String>();
        if (recipientList != null) {
            StringTokenizer tokenizer = new StringTokenizer(recipientList, ",");
            while (tokenizer.hasMoreTokens()) {
                recipientEmails.add(tokenizer.nextToken());
            }
        }
        return recipientEmails;
    }

    public boolean isEmailSent() {
        return this.emailSent;
    }
}

