/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.automatedsalesandvariance;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.oquery.SQLDateType;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentSummaryObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.util.DateTimeUtils;
import au.com.ordermate.util.Price;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import ordermate.database.finance.debtors.AbstractDebtor;
import ordermate.database.finance.debtors.transactions.DebtorPayment;
import ordermate.database.finance.debtors.transactions.DebtorSale;
import ordermate.database.finance.transactions.FinanceTransaction;
import ordermate.database.finance.transactions.FinanceUnit;
import ordermate.database.inventory.InventoryCategory;
import ordermate.database.inventory.InventoryItem;
import ordermate.database.inventory.InventoryItemPortion;
import ordermate.database.inventory.InventoryItemSize;
import ordermate.database.inventory.InventoryItemUnit;
import ordermate.database.misc.StoreGroup;
import ordermate.database.misc.SystemProperty;
import ordermate.database.misc.TradingDay;
import ordermate.database.sales.SalesComponent;
import ordermate.database.sales.SalesItemQuantity;
import ordermate.database.sales.SalesLineItem;
import ordermate.database.users.User;
import ordermate.integration.automatedsalesandvariance.CSVReport;

public class SalesItemReport
extends PersistentSummaryObject
implements CSVReport {
    public static final String NORMAL_SALES = "sales";
    public static final String DEBTOR_SALES = "debtor_sales";
    public static final Props Properties = new Props();
    private Date date;
    private String userFirstName;
    private String userLastName;
    private String itemName;
    private String itemPortionName;
    private String itemSizeName;
    private BigDecimal quantity;
    private Double portion;
    private String category;
    private String transactionType;
    private String debtor;
    private Double itemDiscount;
    private Double accountDiscount;
    private Double accountSurcharge;
    private Double unitPrice;
    private Double unitTax;
    private Date startDate;
    private Date endDate;
    private static String storeNumber;
    private static String storeName;
    static final DateTimeUtils.ThreadLocalDateFormat fullDateFormat;
    static final DateTimeUtils.ThreadLocalDateFormat shortDateFormat;

    public SalesItemReport() {
        storeNumber = StoreGroup.getInstance().getStoreNumber();
        storeName = StoreGroup.getInstance().getStoreName();
    }

    public SalesItemReport(Date start, Date end, String storeNum, String storeNam) {
        if (start == null) {
            throw new IllegalArgumentException("The start date is null, cannot produce a report");
        }
        if (end == null) {
            throw new IllegalArgumentException("The end date is null, cannot produce a report");
        }
        if (storeNum == null) {
            throw new IllegalArgumentException("The store number is null, cannot produce a report");
        }
        if (storeNam == null) {
            throw new IllegalArgumentException("The store name is null, cannot produce a report");
        }
        this.startDate = new Date(start.getTime());
        this.endDate = new Date(end.getTime());
        storeNumber = storeNum;
        storeName = storeNam;
    }

    public List<? extends SalesItemReport> generateReport(SalesItemReportType type) {
        this.checkInitialized();
        if (SalesItemReportType.NormalSales.equals((Object)type)) {
            return PersistenceManager.getObjectList(this.getClass(), this.getSummaryQuery().toString(), new Object[0]);
        }
        if (SalesItemReportType.DebtorSales.equals((Object)type)) {
            return PersistenceManager.getObjectList(this.getClass(), this.getDebtorSalesSummaryQuery().toString(), new Object[0]);
        }
        if (SalesItemReportType.EftposSales.equals((Object)type)) {
            return PersistenceManager.getObjectList(this.getClass(), this.getEftposSalesSummaryQuery().toString(), new Object[0]);
        }
        throw new IllegalArgumentException("Unknown report type " + (Object)((Object)type));
    }

    protected ObjectQuery getSummaryQuery() {
        this.checkInitialized();
        ObjectQuery sql = Query.select(TradingDay.Properties.DATE, "date").select(User.Properties.FIRST_NAME, "userFirstName").select(User.Properties.LAST_NAME, "userLastName").select(InventoryItem.Properties.LABEL, "itemName").select(InventoryItemSize.Properties.LABEL, "itemSizeName").select(InventoryItemPortion.Properties.LABEL, "itemPortionName").select(InventoryItemPortion.Properties.SIZE, "portion").select(InventoryCategory.Properties.LABEL, "category").select(FinanceUnit.Properties.LABEL, "transactionType").sum(SalesItemQuantity.Properties.QUANTITY, "quantity").select(SalesComponent.Properties.ITEM_DISCOUNT_TOTAL, "itemDiscount").select(SalesComponent.Properties.ACCOUNT_DISCOUNT_TOTAL, "accountDiscount").select(SalesComponent.Properties.ACCOUNT_SURCHARGE_TOTAL, "accountSurcharge").select(SalesComponent.Properties.SAVED_UNIT_PRICE, "unitPrice").select(SalesComponent.Properties.UNIT_TAX_AMOUNT, "unitTax").selectFunc("NULL AS debtor").linkUsing(SalesItemQuantity.Properties.SALES_LINE_ITEM).linkUsing(SalesItemQuantity.Properties.USER).linkUsing(SalesItemQuantity.Properties.TRADING_DAY).linkUsing(SalesComponent.Properties.SALES_ITEM).linkUsing(SalesComponent.Properties.INVENTORY_ITEM).linkUsing(SalesComponent.Properties.UNIT).linkUsing(InventoryItem.Properties.CATEGORY).linkUsing(InventoryItemUnit.Properties.SIZE).linkUsing(InventoryItemUnit.Properties.PORTION).linkUsing(FinanceTransaction.Properties.SUB_TYPE).linkUsing("finance_transaction_item", "sales_item").linkUsing("finance_transaction_item", "finance_transaction").wherePropertyBetween(TradingDay.Properties.DATE, this.startDate, this.endDate, SQLDateType.DATE).active(FinanceTransaction.class).groupBy(SalesComponent.Properties.ID).orderBy(SalesComponent.Properties.ID).orderBy(SalesComponent.Properties.SALES_ITEM).orderBy(User.Properties.ID);
        return sql;
    }

    protected ObjectQuery getDebtorSalesSummaryQuery() {
        this.checkInitialized();
        ObjectQuery sql = Query.select(TradingDay.Properties.DATE, "date").select(User.Properties.FIRST_NAME, "userFirstName").select(User.Properties.LAST_NAME, "userLastName").select(InventoryItem.Properties.LABEL, "itemName").select(InventoryItemSize.Properties.LABEL, "itemSizeName").select(InventoryItemPortion.Properties.LABEL, "itemPortionName").select(InventoryItemPortion.Properties.SIZE, "portion").select(InventoryCategory.Properties.LABEL, "category").selectFunc("finance_unit.Name as transactionType").sum(SalesItemQuantity.Properties.QUANTITY, "quantity").select(SalesComponent.Properties.ITEM_DISCOUNT_TOTAL, "itemDiscount").select(SalesComponent.Properties.ACCOUNT_DISCOUNT_TOTAL, "accountDiscount").select(SalesComponent.Properties.ACCOUNT_SURCHARGE_TOTAL, "accountSurcharge").select(SalesComponent.Properties.SAVED_UNIT_PRICE, "unitPrice").select(SalesComponent.Properties.UNIT_TAX_AMOUNT, "unitTax").select(AbstractDebtor.Properties.LABEL, "debtor").joinLeft(DebtorPayment.class, DebtorPayment.Properties.SALE).joinLeft(FinanceTransaction.class, DebtorPayment.Properties.FINANCE_TRANSACTION).joinLeft(FinanceUnit.class, FinanceTransaction.Properties.SUB_TYPE).linkUsing(SalesItemQuantity.Properties.SALES_LINE_ITEM).linkUsing(SalesItemQuantity.Properties.USER).linkUsing(SalesItemQuantity.Properties.TRADING_DAY).linkUsing(SalesComponent.Properties.SALES_ITEM).linkUsing(SalesComponent.Properties.INVENTORY_ITEM).linkUsing(SalesComponent.Properties.UNIT).linkUsing(InventoryItem.Properties.CATEGORY).linkUsing(InventoryItemUnit.Properties.SIZE).linkUsing(InventoryItemUnit.Properties.PORTION).linkUsing(SalesLineItem.Properties.ACCOUNT).linkUsing(DebtorSale.Properties.SALE_ACCOUNT).linkUsing(DebtorSale.Properties.DEBTOR).wherePropertyBetween(TradingDay.Properties.DATE, this.startDate, this.endDate, SQLDateType.DATE).groupBy(SalesComponent.Properties.ID).orderBy(SalesComponent.Properties.ID).orderBy(SalesComponent.Properties.SALES_ITEM);
        return sql;
    }

    protected ObjectQuery getEftposSalesSummaryQuery() {
        this.checkInitialized();
        List<FinanceUnit> eftposUnits = FinanceUnit.getAllEftposUnits();
        ObjectQuery sql = Query.select(TradingDay.Properties.DATE, "date").select(User.Properties.FIRST_NAME, "userFirstName").select(User.Properties.LAST_NAME, "userLastName").select(InventoryItem.Properties.LABEL, "itemName").select(InventoryItemSize.Properties.LABEL, "itemSizeName").select(InventoryItemPortion.Properties.LABEL, "itemPortionName").select(InventoryItemPortion.Properties.SIZE, "portion").select(InventoryCategory.Properties.LABEL, "category").select(FinanceUnit.Properties.LABEL, "transactionType").sum(SalesItemQuantity.Properties.QUANTITY, "quantity").select(SalesComponent.Properties.ITEM_DISCOUNT_TOTAL, "itemDiscount").select(SalesComponent.Properties.ACCOUNT_DISCOUNT_TOTAL, "accountDiscount").select(SalesComponent.Properties.ACCOUNT_SURCHARGE_TOTAL, "accountSurcharge").select(SalesComponent.Properties.SAVED_UNIT_PRICE, "unitPrice").select(SalesComponent.Properties.UNIT_TAX_AMOUNT, "unitTax").selectFunc("NULL AS debtor").linkUsing(SalesItemQuantity.Properties.SALES_LINE_ITEM).linkUsing(SalesItemQuantity.Properties.USER).linkUsing(SalesItemQuantity.Properties.TRADING_DAY).linkUsing(SalesComponent.Properties.SALES_ITEM).linkUsing(SalesComponent.Properties.INVENTORY_ITEM).linkUsing(SalesComponent.Properties.UNIT).linkUsing(InventoryItem.Properties.CATEGORY).linkUsing(InventoryItemUnit.Properties.SIZE).linkUsing(InventoryItemUnit.Properties.PORTION).linkUsing(FinanceTransaction.Properties.SUB_TYPE).linkUsing("finance_transaction_item", "sales_item").linkUsing("finance_transaction_item", "finance_transaction").wherePropertyBetween(TradingDay.Properties.DATE, this.startDate, this.endDate, SQLDateType.DATE).wherePropertyIn(FinanceUnit.Properties.ID, eftposUnits).active(FinanceTransaction.class).groupBy(SalesComponent.Properties.ID).orderBy(SalesComponent.Properties.ID).orderBy(SalesItemQuantity.Properties.ID);
        return sql;
    }

    public String getDate() {
        return fullDateFormat.getFormat().format(this.date);
    }

    public String getMonthYear() {
        return shortDateFormat.getFormat().format(this.date);
    }

    public String getUserName() {
        return this.getUserFirstName() + " " + this.getUserLastName();
    }

    public String getStoreNumber() {
        return storeNumber;
    }

    public String getStoreName() {
        return storeName;
    }

    public String getItemName() {
        return this.itemName + " (" + this.getItemSizeName() + "/" + this.getItemPortionName() + ")";
    }

    public String getCategory() {
        return this.category;
    }

    public String getTransactionType() {
        return this.transactionType;
    }

    public String getDebtor() {
        return this.debtor;
    }

    public String getQuantity() {
        return new Double(this.quantity.multiply(new BigDecimal(this.portion)).doubleValue()).toString();
    }

    public String getDiscount() {
        return new Price(new BigDecimal(this.getItemDiscount()).add(new BigDecimal(this.getAccountDiscount())).subtract(new BigDecimal(this.getAccountSurcharge())).multiply(this.quantity), 0.01).toString(false);
    }

    public String getUnitPrice() {
        return new Price(this.unitPrice, 0.01).toString(false);
    }

    public String getUnitTax() {
        return new Price(this.unitTax, 0.01).toString(false);
    }

    public String getTotalPrice() {
        return new Price(new BigDecimal(this.unitPrice).multiply(this.quantity), 0.01).toString(false);
    }

    public String getTotalTax() {
        return new Price(new BigDecimal(this.unitTax).multiply(this.quantity), 0.01).toString(false);
    }

    private Double getPortion() {
        return this.portion;
    }

    public static final String[] getHeadings() {
        return new String[]{"Date", "Month/Year", "User", "Store number", "Store name", "Item", "Category", "Transaction Type", "Account", "Quantity", "Discount", "Unit Price", "Unit " + SystemProperty.getInstance().getBaseTaxLabel(), "Total Price", "Total " + SystemProperty.getInstance().getBaseTaxLabel()};
    }

    @Override
    public String[] getCSVData() {
        return new String[]{this.getDate(), this.getMonthYear(), this.getUserName(), this.getStoreNumber(), this.getStoreName(), this.getItemName(), this.getCategory(), this.getTransactionType(), this.getDebtor(), this.getQuantity(), this.getDiscount(), this.getUnitPrice(), this.getUnitTax(), this.getTotalPrice(), this.getTotalTax()};
    }

    private void checkInitialized() throws IllegalStateException {
        if (this.startDate == null) {
            throw new IllegalStateException("The start date is null, cannot produce a report");
        }
        if (this.endDate == null) {
            throw new IllegalStateException("The end date is null, cannot produce a report");
        }
        if (storeNumber == null) {
            throw new IllegalStateException("The store number is null, cannot produce a report");
        }
        if (storeName == null) {
            throw new IllegalStateException("The store name is null, cannot produce a report");
        }
    }

    private void setItemSizeName(String newItemSizeName) {
        this.itemSizeName = newItemSizeName;
    }

    private String getItemSizeName() {
        return this.itemSizeName;
    }

    private void setItemDiscount(Double newItemDiscount) {
        this.itemDiscount = newItemDiscount;
    }

    private Double getItemDiscount() {
        return this.itemDiscount;
    }

    private void setAccountSurcharge(Double newAccountSurcharge) {
        this.accountSurcharge = newAccountSurcharge;
    }

    private Double getAccountSurcharge() {
        return this.accountSurcharge;
    }

    private void setUserLastName(String newUserLastName) {
        this.userLastName = newUserLastName;
    }

    private String getUserLastName() {
        return this.userLastName;
    }

    private void setAccountDiscount(Double newAccountDiscount) {
        this.accountDiscount = newAccountDiscount;
    }

    private Double getAccountDiscount() {
        return this.accountDiscount;
    }

    private void setItemPortionName(String newItemPortionName) {
        this.itemPortionName = newItemPortionName;
    }

    private String getItemPortionName() {
        return this.itemPortionName;
    }

    private void setUserFirstName(String newUserFirstName) {
        this.userFirstName = newUserFirstName;
    }

    private String getUserFirstName() {
        return this.userFirstName;
    }

    static {
        fullDateFormat = new DateTimeUtils.ThreadLocalDateFormat(new SimpleDateFormat("dd/MM/yyyy"));
        shortDateFormat = new DateTimeUtils.ThreadLocalDateFormat(new SimpleDateFormat("MMM-yy"));
    }

    public static class Props
    extends PersistentSummaryObject.Props {
        public PropertiedObject.Property DATE;
        public PropertiedObject.Property USER_FIRST_NAME;
        public PropertiedObject.Property USER_LAST_NAME;
        public PropertiedObject.Property ITEM_NAME;
        public PropertiedObject.Property ITEM_PORTION_NAME;
        public PropertiedObject.Property ITEM_SIZE_NAME;
        public PropertiedObject.Property PORTION;
        public PropertiedObject.Property CATEGORY;
        public PropertiedObject.Property TRANSACTION_TYPE;
        public PropertiedObject.Property DEBTOR;
        public PropertiedObject.Property QUANTITY;
        public PropertiedObject.Property ITEM_DISCOUNT;
        public PropertiedObject.Property ACCOUNT_DISCOUNT;
        public PropertiedObject.Property ACCOUNT_SURCHARGE;
        public PropertiedObject.Property UNIT_PRICE;
        public PropertiedObject.Property UNIT_TAX;
    }

    public static enum SalesItemReportType {
        NormalSales,
        DebtorSales,
        EftposSales;

    }
}

