/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.automatedsalesandvariance;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.util.MathsUtils;
import java.sql.Date;

public class VarianceReport {
    private static Object[][] systemRS;
    private static Object[][] actualRS;
    private static Object[][] daysAndDrawersRS;

    public static Object[][] getVarianceReport(String storeNum, String storeName, Date startDate, Date endDate) throws Exception {
        String daysAndDrawers = "SELECT\tDISTINCT DATE_FORMAT(finance_trading_day.day, '%d/%m/%Y') AS 'Date', config_terminal.ID AS terminal_id, config_terminal.Name AS terminal_name, config_cashdrawer.ID AS cashdrawer_id, config_cashdrawer.Name AS cashdrawer_name FROM config_terminal, config_cashdrawer, finance_trading_day, config_terminal_cashdrawer WHERE (finance_trading_day.day BETWEEN '" + startDate.toString() + "' AND '" + endDate.toString() + "') AND config_terminal_cashdrawer.FK_config_terminal = config_terminal.ID AND config_terminal_cashdrawer.FK_config_cashdrawer = config_cashdrawer.ID AND config_terminal.system_state = 'ACTIVE' ORDER BY finance_trading_day.ID";
        String systemSql = "SELECT\tDATE_FORMAT(finance_trading_day.day, '%d/%m/%Y') AS 'Date', config_terminal.ID AS 'Terminal', config_cashdrawer.ID AS 'Cash drawer', SUM(finance_transaction.amount_paid) as 'System Amount' FROM finance_transaction, finance_unit, config_terminal, config_cashdrawer, finance_trading_day WHERE finance_transaction.FK_finance_trading_day = finance_trading_day.ID AND finance_transaction.FK_finance_unit = finance_unit.ID AND finance_transaction.FK_config_terminal = config_terminal.ID AND finance_transaction.FK_config_cashdrawer = config_cashdrawer.ID AND (finance_trading_day.day BETWEEN '" + startDate.toString() + "' AND '" + endDate.toString() + "') AND finance_unit.unit_type IN ('CASH', 'CREDIT','DEBIT') AND finance_transaction.System_State = 'ACTIVE' GROUP BY config_cashdrawer.ID, config_terminal.ID, finance_trading_day.ID";
        String actualSql = "SELECT\tDATE_FORMAT(finance_trading_day.day, '%d/%m/%Y') AS 'Date', config_terminal.ID AS 'Terminal', config_cashdrawer.ID AS 'Cashdrawer', SUM(IF(finance_reconciliation_entry.FK_finance_denomination = 0, finance_reconciliation_entry.value, finance_reconciliation_entry.value * finance_denomination.Value)) as 'Actual Amount' FROM finance_reconciliation_cashdrawer, finance_reconciliation_shift, finance_shift, finance_trading_day, config_terminal, config_cashdrawer, finance_unit, finance_reconciliation_entry LEFT JOIN finance_denomination ON finance_denomination.ID = finance_reconciliation_entry.FK_finance_denomination WHERE finance_reconciliation_cashdrawer.FK_finance_reconciliation_shift = finance_reconciliation_shift.ID AND finance_reconciliation_shift.FK_finance_shift = finance_shift.ID AND finance_shift.FK_finance_trading_day = finance_trading_day.ID AND finance_reconciliation_entry.FK_finance_reconciliation_cashdrawer = finance_reconciliation_cashdrawer.ID AND finance_reconciliation_cashdrawer.FK_config_cashdrawer = config_cashdrawer.ID AND config_cashdrawer.FK_config_terminal = config_terminal.ID AND (finance_trading_day.day BETWEEN '" + startDate.toString() + "' AND '" + endDate.toString() + "') AND finance_unit.unit_type IN ('CASH', 'CREDIT','DEBIT') GROUP BY config_cashdrawer.ID, config_terminal.ID, finance_trading_day.ID";
        daysAndDrawersRS = PersistenceManager.getPersistenceDelegate().executeQuery(daysAndDrawers, new Object[0]);
        systemRS = PersistenceManager.getPersistenceDelegate().executeQuery(systemSql, new Object[0]);
        actualRS = PersistenceManager.getPersistenceDelegate().executeQuery(actualSql, new Object[0]);
        Object[][] varianceRS = new Object[daysAndDrawersRS.length][VarianceReport.getHeadings().length];
        for (int i = 0; i < varianceRS.length; ++i) {
            Object date = daysAndDrawersRS[i][0];
            Object terminalID = daysAndDrawersRS[i][1];
            Object terminalName = daysAndDrawersRS[i][2];
            Object drawerID = daysAndDrawersRS[i][3];
            Object drawerName = daysAndDrawersRS[i][4];
            varianceRS[i][0] = date;
            varianceRS[i][1] = storeNum;
            varianceRS[i][2] = storeName;
            varianceRS[i][3] = terminalName;
            varianceRS[i][4] = drawerName;
            double systemAmt = VarianceReport.getSystemAmount(date, terminalID, drawerID);
            double actualAmt = VarianceReport.getActualAmount(date, terminalID, drawerID);
            varianceRS[i][5] = new Double(MathsUtils.roundDouble(actualAmt - systemAmt, 0.01));
        }
        return varianceRS;
    }

    public static final String[] getHeadings() {
        return new String[]{"Date", "Store number", "Store name", "Terminal name", "Cash drawer", "Variance"};
    }

    private static double getSystemAmount(Object date, Object terminalID, Object drawerID) {
        for (int i = 0; i < systemRS.length; ++i) {
            Object[] systemRow = systemRS[i];
            if (!systemRow[0].equals(date) || !systemRow[1].equals(terminalID) || !systemRow[2].equals(drawerID)) continue;
            return (Double)systemRow[3];
        }
        return 0.0;
    }

    private static double getActualAmount(Object date, Object terminalID, Object drawerID) {
        for (int i = 0; i < actualRS.length; ++i) {
            Object[] actualRow = actualRS[i];
            if (!actualRow[0].equals(date) || !actualRow[1].equals(terminalID) || !actualRow[2].equals(drawerID)) continue;
            return (Double)actualRow[3];
        }
        return 0.0;
    }
}

