/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.barstock;

import au.com.ordermate.guicore.task.CompositeTask;
import au.com.ordermate.guicore.task.ProgressLogger;
import au.com.ordermate.util.Price;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.StringTokenizer;
import ordermate.database.integration.BarStockConfiguration;
import ordermate.database.inventory.InventoryItemUnit;
import ordermate.database.inventory.PriceLevel;
import ordermate.database.inventory.UnitPriceLevel;
import ordermate.database.misc.SystemCurrentInfo;
import ordermate.startup.ConfigurationTask;
import ordermate.startup.LoggerSetupTask;
import ordermate.startup.ServerConnectionSetupTask;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ORDERMATEP {
    private static final Log LOG = LogFactory.getLog((String)"ORDERMATEP");

    public static void main(String[] args) {
        CompositeTask startup = new CompositeTask("Starting barstock integration");
        startup.addTask(new LoggerSetupTask("BarStock%u-%g.log"));
        startup.addTask(new ConfigurationTask("BarstockConfig.ini"));
        startup.addTask(new ServerConnectionSetupTask(null, "Integration"));
        startup.run();
        startup.taskStarted.connect(new ProgressLogger(), "logProgress");
        BarStockConfiguration bsConfig = BarStockConfiguration.getInstance();
        String inputFileName = bsConfig.getInputFileName();
        String filePath = bsConfig.getWorkingDirectoryPath();
        PriceLevel priceLevel = bsConfig.getPriceLevel();
        ORDERMATEP.getUpdatedPrices(filePath, inputFileName, priceLevel);
        System.exit(0);
    }

    private static void getUpdatedPrices(String filePath, String inputFileName, PriceLevel priceLevel) {
        FileInputStream fin = null;
        try {
            fin = new FileInputStream(filePath + inputFileName);
        }
        catch (FileNotFoundException e) {
            LOG.error((Object)("Error getting BarStock inputFile\n" + e), (Throwable)e);
        }
        BufferedReader myInput = new BufferedReader(new InputStreamReader(fin));
        String current = null;
        try {
            current = myInput.readLine();
        }
        catch (IOException e1) {
            LOG.error((Object)"Error reading in BarStock inputFile", (Throwable)e1);
        }
        String currentExternalID = "";
        double currentPrice = 0.0;
        while (current != null) {
            InventoryItemUnit unit;
            StringTokenizer s = new StringTokenizer(current, " ,");
            boolean gotExternalID = false;
            if (s.hasMoreTokens()) {
                currentExternalID = s.nextToken();
                gotExternalID = true;
            }
            boolean gotNewPrice = false;
            while (!gotNewPrice && s.hasMoreTokens()) {
                try {
                    currentPrice = Double.parseDouble(s.nextToken());
                    gotNewPrice = true;
                }
                catch (NumberFormatException numberFormatException) {}
            }
            if (gotExternalID && gotNewPrice && (unit = InventoryItemUnit.getUnitByExtID(currentExternalID)) != null) {
                UnitPriceLevel price = unit.getUnitPriceLevel(priceLevel);
                if (price == null) {
                    price = new UnitPriceLevel();
                    unit.addUnitPriceLevel(price);
                    priceLevel.addUnitPriceLevel(price);
                }
                price.setPrice(new Price(currentPrice));
                price.save();
            }
            try {
                current = myInput.readLine();
            }
            catch (IOException e2) {
                LOG.error((Object)"Error reading in BarStock inputFile", (Throwable)e2);
            }
        }
        ORDERMATEP.forceUpdateAllMenus();
    }

    private static void forceUpdateAllMenus() {
        SystemCurrentInfo.setMenuUpdate("Barstock Prices Changed");
    }
}

