/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.barstock;

import au.com.ordermate.guicore.task.CompositeTask;
import au.com.ordermate.guicore.task.ProgressLogger;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import ordermate.database.integration.BarStockConfiguration;
import ordermate.database.misc.TradingDay;
import ordermate.startup.ConfigurationTask;
import ordermate.startup.LoggerSetupTask;
import ordermate.startup.ServerConnectionSetupTask;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ORDERMATER {
    private static final Log LOG = LogFactory.getLog((String)"ORDERMATER");

    public static void main(String[] args) {
        CompositeTask startup = new CompositeTask("Starting barstock integration");
        startup.addTask(new LoggerSetupTask("BarStock%u-%g.log"));
        startup.addTask(new ConfigurationTask("BarstockConfig.ini"));
        startup.addTask(new ServerConnectionSetupTask(null, "Integration"));
        startup.run();
        startup.taskStarted.connect(new ProgressLogger(), "logProgress");
        BarStockConfiguration bsConfig = BarStockConfiguration.getInstance();
        String outputFileName = bsConfig.getOutputFileName();
        String filePath = bsConfig.getWorkingDirectoryPath();
        String pluFileName = bsConfig.getItemPluFileName();
        ORDERMATER.sendSalesData(filePath, outputFileName, pluFileName);
        System.exit(0);
    }

    private static void sendSalesData(String filePath, String outputFileName, String pluFileName) {
        TradingDay today = TradingDay.getCurrentTradingDay();
        try {
            List plus = ORDERMATER.getListOfBarstockPLUS(filePath, pluFileName);
            File dumpFile = new File(filePath + outputFileName);
            FileWriter fileWriter = new FileWriter(dumpFile);
            BufferedWriter out = new BufferedWriter(fileWriter);
            for (Integer currentPlu : plus) {
                int numSales = today.getNumSalesForPlu(currentPlu);
                String line = currentPlu + ", " + numSales;
                out.write(line);
                out.newLine();
            }
            out.close();
        }
        catch (FileNotFoundException e) {
            LOG.error((Object)"File not found", (Throwable)e);
        }
        catch (IOException e) {
            LOG.error((Object)"Error writing out sales to BarStock", (Throwable)e);
        }
    }

    private static List getListOfBarstockPLUS(String filePath, String pluFileName) throws IOException {
        ArrayList<Integer> pluList = new ArrayList<Integer>();
        File pluFile = new File(filePath + pluFileName);
        FileReader fileReader = new FileReader(pluFile);
        BufferedReader in = new BufferedReader(fileReader);
        String line = in.readLine();
        while (line != null) {
            pluList.add(new Integer(line.trim()));
            line = in.readLine();
        }
        in.close();
        return pluList;
    }
}

