/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.bartabs;

import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.util.Price;
import java.util.List;
import ordermate.database.integration.bartabs.BarTabsConfiguration;
import ordermate.database.sales.AccountState;
import ordermate.database.sales.BarTabAccount;
import ordermate.database.users.User;
import ordermate.integration.bartabs.BarTabAuthority;
import ordermate.integration.bartabs.BarTabIntegrationServerResponseWrapper;
import ordermate.integration.bartabs.BarTabSettlementResult;
import ordermate.integration.bartabs.BarTabVendor;
import ordermate.integration.bartabs.DefaultPosBarTabAuthority;
import ordermate.integration.bartabs.astonclub.AstonClubBarTabAuthority;
import ordermate.integration.bartabs.clipp.ClippBarTabAuthority;
import ordermate.integration.bartabs.onetab.OneTabBarTabAuthority;
import ordermate.integration.jaxb.clippbartabs.CloseTabResponse;

public class BarTabAdministrator {
    private static BarTabAdministrator instance;

    protected BarTabAdministrator() {
    }

    public static BarTabAdministrator getInstance() {
        if (instance == null) {
            instance = new BarTabAdministrator();
        }
        return instance;
    }

    public boolean barTabUpdated(BarTabAccount account) {
        if (this.getBarTabAuthorityForAccount(account).shouldUpdateBarTabStatus(account)) {
            return this.getBarTabAuthorityForAccount(account).notifyBarTabModified(account);
        }
        return true;
    }

    public BarTabSettlementResult requestSettleBarTab(BarTabAccount account, User user) {
        return this.getBarTabAuthorityForAccount(account).requestSettleBarTab(account, user);
    }

    public BarTabSettlementResult requestSettleBarTabAtPOS(BarTabAccount account, Price amount, User user) {
        return this.getBarTabAuthorityForAccount(account).requestSettleBarTabAtPOS(account, user, amount);
    }

    public BarTabIntegrationServerResponseWrapper<CloseTabResponse> requestCloseBarTab(BarTabAccount account) {
        return this.getBarTabAuthorityForAccount(account).requestCloseBarTab(account);
    }

    public BarTabAuthority getBarTabAuthorityForAccount(BarTabAccount account) {
        return this.getBarTabAuthorityForVendorId(account.getSource());
    }

    public BarTabAuthority getBarTabAuthorityForVendorId(String vendorId) {
        if (BarTabVendor.AstonClub.getId().equals(vendorId)) {
            return AstonClubBarTabAuthority.getInstance();
        }
        if (BarTabVendor.Clipp.getId().equals(vendorId)) {
            return ClippBarTabAuthority.getInstance();
        }
        if (BarTabVendor.OneTab.getId().equals(vendorId)) {
            return OneTabBarTabAuthority.getInstance();
        }
        return DefaultPosBarTabAuthority.getInstance();
    }

    public static void setBarTabAdministrator(BarTabAdministrator barTabAdministrator) {
        instance = barTabAdministrator;
    }

    public boolean isTippingAllowed(BarTabAccount account) {
        return this.getBarTabAuthorityForAccount(account).isTippingAllowed(account);
    }

    public boolean isPartialSettlementAllowed(BarTabAccount account) {
        return this.getBarTabAuthorityForAccount(account).isPartialSettlementAllowed(account);
    }

    public boolean forceCloseZeroDollarAccountsAfterSettlement(BarTabAccount account) {
        return this.getBarTabAuthorityForAccount(account).forceCloseZeroDollarAccountsAfterSettlement(account);
    }

    public void closeAllAccountsForVendorEndOfTradingDay() {
        for (BarTabsConfiguration barTabConfig : BarTabsConfiguration.getAllActiveThirdPartyVendors()) {
            if (!barTabConfig.isForceCloseTabsEndOfDay()) continue;
            BarTabAuthority authority = this.getBarTabAuthorityForVendorId(barTabConfig.getVendorId());
            for (BarTabAccount barTab : this.getOpenBarTabAccounts(barTabConfig.getVendorId())) {
                authority.closeBarTabEndOfDay(barTab);
            }
        }
    }

    private List<BarTabAccount> getOpenBarTabAccounts(String vendorId) {
        return PersistenceManager.getObjectList(BarTabAccount.class, Query.select(BarTabAccount.class).equals(BarTabAccount.Properties.ACCOUNT_STATE, (Object)AccountState.OPEN).equals(BarTabAccount.Properties.SOURCE, vendorId).toString());
    }
}

