/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.bartabs;

import au.com.ordermate.util.Price;
import java.util.HashSet;
import java.util.Set;
import ordermate.database.Payable;
import ordermate.database.finance.transactions.FinanceTransaction;
import ordermate.database.integration.bartabs.BarTabsConfiguration;
import ordermate.database.sales.BarTabAccount;
import ordermate.database.users.User;
import ordermate.integration.bartabs.BarTabIntegrationServerResponseWrapper;
import ordermate.integration.bartabs.BarTabSettlementResult;

public abstract class BarTabAuthority {
    private Set<Long> barTabsNotToNotifyUpdate = new HashSet<Long>();

    public abstract BarTabIntegrationServerResponseWrapper requestCloseBarTab(BarTabAccount var1);

    public abstract BarTabSettlementResult requestSettleBarTab(BarTabAccount var1);

    public abstract BarTabSettlementResult requestSettleBarTab(BarTabAccount var1, User var2);

    public abstract BarTabSettlementResult requestSettleBarTabAtPOS(BarTabAccount var1, User var2, Price var3);

    public abstract boolean notifyBarTabModified(BarTabAccount var1);

    public abstract boolean isTippingAllowed(BarTabAccount var1);

    public abstract boolean isPartialSettlementAllowed(BarTabAccount var1);

    public abstract boolean forceCloseZeroDollarAccountsAfterSettlement(BarTabAccount var1);

    public abstract boolean isCreditLimitModifiable(BarTabAccount var1);

    public abstract boolean closeBarTabEndOfDay(BarTabAccount var1);

    public abstract void checkForUpdates();

    protected boolean isClosePossible(BarTabAccount account) {
        return account.isOpen() && account.isClosePossible() && Payable.PAID.equals(account.getPaidState());
    }

    protected boolean containsSettlementFinanceUnit(BarTabAccount account, String vendorId) {
        for (FinanceTransaction financeTrans : account.getFinanceTransactions()) {
            if (!financeTrans.getSubType().equals(BarTabsConfiguration.getBarTabConfigForVendorId(vendorId).getFinanceUnit())) continue;
            return true;
        }
        return false;
    }

    public boolean shouldUpdateBarTabStatus(BarTabAccount account) {
        return !this.barTabsNotToNotifyUpdate.contains(account.getID());
    }

    public void addBarTabNotToSendStatusUpdatesFor(BarTabAccount account) {
        this.barTabsNotToNotifyUpdate.add(account.getID());
    }

    public void removeBarTabNotToSendStatusUpdatesFor(BarTabAccount account) {
        this.barTabsNotToNotifyUpdate.remove(account.getID());
    }
}

