/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.bartabs.astonclub;

import au.com.ordermate.util.Price;
import com.sun.jersey.api.client.WebResource;
import ordermate.OrderMate;
import ordermate.database.finance.transactions.FinanceTransaction;
import ordermate.database.hardware.Terminal;
import ordermate.database.integration.bartabs.BarTabsConfiguration;
import ordermate.database.sales.BarTabAccount;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.SalesLineItem;
import ordermate.database.users.User;
import ordermate.integration.bartabs.BarTabAuthority;
import ordermate.integration.bartabs.BarTabIntegrationServerResponseWrapper;
import ordermate.integration.bartabs.BarTabSettlementResult;
import ordermate.integration.bartabs.BarTabVendor;
import ordermate.integration.bartabs.astonclub.AstonClubJSONHelper;
import ordermate.integration.jaxb.astonclubbartab.BarTabInfo;
import ordermate.integration.jaxb.astonclubbartab.BarTabItem;
import ordermate.integration.jaxb.astonclubbartab.BarTabPayment;
import ordermate.integration.jaxb.astonclubbartab.BarTabResponse;
import ordermate.integration.jaxb.clippbartabs.CloseTabResponse;
import ordermate.integration.webservice.RestHelper;
import ordermate.webresource.bartabs.BarTabIntegrationManager;

public class AstonClubBarTabAuthority
extends BarTabAuthority {
    public static final BarTabVendor VENDOR = BarTabVendor.AstonClub;
    private static AstonClubBarTabAuthority instance;
    private RestHelper restHelper = new RestHelper();
    private static final String SEND_TAB_URI = "actions/sendtabdetails";
    private static final String CLOSE_TAB_URI = "actions/closetab";

    private AstonClubBarTabAuthority() {
    }

    public static AstonClubBarTabAuthority getInstance() {
        if (instance == null) {
            instance = new AstonClubBarTabAuthority();
        }
        return instance;
    }

    @Override
    public BarTabIntegrationServerResponseWrapper<CloseTabResponse> requestCloseBarTab(final BarTabAccount account) {
        if (!this.containsSettlementFinanceUnit(account, VENDOR.getId())) {
            Thread runner = new Thread(new Runnable(){

                @Override
                public void run() {
                    BarTabInfo barTabInfo = AstonClubBarTabAuthority.this.makeInfo(account);
                    WebResource resource = AstonClubBarTabAuthority.this.restHelper.getResource(BarTabsConfiguration.getBarTabConfigForVendorId(VENDOR.getId()).getUrl() + AstonClubBarTabAuthority.CLOSE_TAB_URI);
                    ((WebResource.Builder)resource.type("application/xml").accept(new String[]{"application/xml"})).post(String.class, (Object)barTabInfo);
                }
            });
            runner.start();
        }
        return new BarTabIntegrationServerResponseWrapper<CloseTabResponse>(true);
    }

    @Override
    public BarTabSettlementResult requestSettleBarTab(BarTabAccount account) {
        return this.requestSettleBarTab(account, null);
    }

    @Override
    public BarTabSettlementResult requestSettleBarTab(BarTabAccount account, User user) {
        return this.requestSettleBarTabAtPOS(account, user, account.getDue());
    }

    @Override
    public BarTabSettlementResult requestSettleBarTabAtPOS(BarTabAccount account, User user, Price amount) {
        try {
            boolean success;
            BarTabInfo barTabInfo = this.makeInfo(account);
            WebResource resource = this.restHelper.getResource(BarTabsConfiguration.getBarTabConfigForVendorId(VENDOR.getId()).getUrl() + CLOSE_TAB_URI);
            BarTabResponse barTabResponse = AstonClubJSONHelper.getBarTabResponseFromString((String)((WebResource.Builder)resource.type("application/xml").accept(new String[]{"application/xml"})).post(String.class, (Object)barTabInfo));
            boolean bl = success = barTabResponse != null && Boolean.FALSE.equals(barTabResponse.getError());
            if (success) {
                return BarTabIntegrationManager.getInstance().barTabPayment(VENDOR.getId(), account.getID().toString(), account.getExtID(), amount, Price.ZERO_DOLLAR, Price.ZERO_DOLLAR, user);
            }
        }
        catch (Exception ex) {
            OrderMate.LOG.error("AstonClubBarTabAuthority error while requesting settlement of account.", (Throwable)ex);
        }
        return new BarTabSettlementResult(false);
    }

    @Override
    public boolean notifyBarTabModified(final BarTabAccount account) {
        Thread runner = new Thread(new Runnable(){

            @Override
            public void run() {
                BarTabInfo barTabInfo = AstonClubBarTabAuthority.this.makeInfo(account);
                WebResource resource = AstonClubBarTabAuthority.this.restHelper.getResource(BarTabsConfiguration.getBarTabConfigForVendorId(VENDOR.getId()).getUrl() + AstonClubBarTabAuthority.SEND_TAB_URI);
                BarTabResponse barTabResponse = AstonClubJSONHelper.getBarTabResponseFromString((String)((WebResource.Builder)resource.type("application/xml").accept(new String[]{"application/xml"})).post(String.class, (Object)barTabInfo));
                if (barTabResponse != null) {
                    if (Boolean.TRUE.equals(barTabResponse.getError())) {
                        OrderMate.LOG.error("AstonClubBarTabAuthority error occured while calling actions/sendtabdetails: " + barTabResponse.getMessage());
                    } else {
                        OrderMate.LOG.info("AstonClubBarTabAuthority successfully called actions/sendtabdetails");
                    }
                }
            }
        });
        runner.start();
        return true;
    }

    public BarTabInfo makeInfo(BarTabAccount account) {
        if (account == null) {
            throw new IllegalArgumentException("Cannot process a null bar tab");
        }
        BarTabInfo info = new BarTabInfo();
        info.setOutstandingAmount(account.getDue().doubleValue());
        info.setTotalAmount(account.getTotal().doubleValue());
        info.setTotalTax(account.getTax().doubleValue());
        info.setPosTabId(account.getID());
        info.setTabId(account.getExtID());
        info.setPosTabNumber(account.getLabel());
        info.setStationId(Terminal.getLocalHost().getLabel());
        info.setCheckDate(account.getCreationDateTime());
        info.setCheckNumber(account.getBarcode());
        this.loadItems(info, account);
        this.loadSundryItems(info, account);
        this.loadPayments(info, account);
        return info;
    }

    private void loadItems(BarTabInfo info, BarTabAccount account) {
        for (SalesLineItem lineItem : account.getItems()) {
            for (SalesItem item : lineItem.getSalesItems()) {
                BarTabItem newItem = new BarTabItem();
                newItem.setItemId(String.valueOf(item.getID()));
                newItem.setItemName(String.valueOf(item.getLabel()));
                newItem.setItemId(String.valueOf(item.getComponentList().get(0).getUnit().getID()));
                newItem.setPriceIncludesTax(true);
                newItem.setQuantity(item.getQuantity().getValue().doubleValue());
                newItem.setTotalPriceIncludingDiscount(item.getPrice().doubleValue());
                newItem.setUnitPrice(item.getPricePerItem().doubleValue());
                info.getItems().add(newItem);
            }
        }
    }

    private void loadSundryItems(BarTabInfo info, BarTabAccount account) {
    }

    private void loadPayments(BarTabInfo info, BarTabAccount account) {
        for (FinanceTransaction txn : account.getFinanceTransactions()) {
            BarTabPayment payment = new BarTabPayment();
            payment.setAmountPaid(txn.getPaid().doubleValue());
            payment.setPaymentMethod(txn.getType());
            payment.setTipsAmount(txn.getTip().doubleValue());
            info.getPayments().add(payment);
        }
    }

    @Override
    public boolean isTippingAllowed(BarTabAccount account) {
        return false;
    }

    @Override
    public boolean isPartialSettlementAllowed(BarTabAccount account) {
        return false;
    }

    @Override
    public boolean forceCloseZeroDollarAccountsAfterSettlement(BarTabAccount account) {
        return this.containsSettlementFinanceUnit(account, VENDOR.getId());
    }

    @Override
    public boolean isCreditLimitModifiable(BarTabAccount account) {
        return false;
    }

    @Override
    public boolean closeBarTabEndOfDay(BarTabAccount account) {
        return false;
    }

    @Override
    public void checkForUpdates() {
    }
}

