/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.bartabs.clipp;

import au.com.ordermate.util.Price;
import com.fasterxml.jackson.databind.util.ISO8601Utils;
import com.sun.jersey.api.client.GenericType;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.client.filter.HTTPBasicAuthFilter;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import javax.ws.rs.core.MediaType;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import ordermate.OrderMate;
import ordermate.database.finance.transactions.FinanceTransaction;
import ordermate.database.integration.bartabs.BarTabsConfiguration;
import ordermate.database.inventory.InventoryCategory;
import ordermate.database.sales.BarTabAccount;
import ordermate.database.sales.SalesCombo;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.SalesLineItem;
import ordermate.database.users.User;
import ordermate.integration.bartabs.BarTabAuthority;
import ordermate.integration.bartabs.BarTabIntegrationServerResponseWrapper;
import ordermate.integration.bartabs.BarTabSettlementResult;
import ordermate.integration.bartabs.BarTabVendor;
import ordermate.integration.bartabs.clipp.ClippMessageHandler;
import ordermate.integration.jaxb.clippbartabs.BarTabPaymentResponse;
import ordermate.integration.jaxb.clippbartabs.CloseTabResponse;
import ordermate.integration.jaxb.clippbartabs.ErrorResponse;
import ordermate.integration.jaxb.clippbartabs.Item;
import ordermate.integration.jaxb.clippbartabs.Message;
import ordermate.integration.jaxb.clippbartabs.Payment;
import ordermate.integration.jaxb.clippbartabs.ReceiptData;
import ordermate.integration.webservice.RestHelper;
import ordermate.webresource.bartabs.BarTabIntegrationManager;

public class ClippBarTabAuthority
extends BarTabAuthority {
    public static final BarTabVendor VENDOR = BarTabVendor.Clipp;
    private static ClippBarTabAuthority instance;
    private RestHelper restHelper = new RestHelper();
    private static final String ENDPOINT_MESSAGES = "Clipp/Messages";
    private static final String ENDPOINT_SEND_TAB_DETAILS = "Clipp/Actions/SendTabDetails";
    private static final String ENDPOINT_REQUEST_PAY = "Clipp/Actions/RequestTabPayment";
    private static final String ENDPOINT_CLOSE_TAB = "Clipp/Actions/CloseTab";
    private static final String CLIPP_TAB_REF_PARAM = "clippTabRef";
    private static final String CLIPP_MESSAGE_ID_PARAM = "clippMessageId";
    private static final String CLIPP_AMOUNT_PARAM = "amount";
    private static final String CLIPP_USERNAME = "CLIPP";
    private static final String POS_NAME_HEADER = "X-Pos-Name";
    private static final String POS_VERSION_HEADER = "X-Pos-Version";
    private static ClippMessageHandler handler;

    public ClippBarTabAuthority() {
        handler = new ClippMessageHandler();
    }

    @Override
    public BarTabIntegrationServerResponseWrapper<CloseTabResponse> requestCloseBarTab(BarTabAccount account) {
        if (this.shouldSendRequestCloseBarTab(account)) {
            return this.requestCloseBarTab(account, null);
        }
        return new BarTabIntegrationServerResponseWrapper<CloseTabResponse>(true);
    }

    public BarTabIntegrationServerResponseWrapper requestCloseBarTab(BarTabAccount account, String msgId) {
        return this.requestCloseBarTab(account, msgId, account.getDue());
    }

    public BarTabIntegrationServerResponseWrapper requestCloseBarTab(final BarTabAccount account, String msgId, Price amountToPay) {
        WebResource resource = this.restHelper.getResource(BarTabsConfiguration.getBarTabConfigForVendorId(VENDOR.getId()).getUrl() + ENDPOINT_CLOSE_TAB);
        resource = resource.queryParam(CLIPP_TAB_REF_PARAM, account.getExtID());
        resource = resource.queryParam(CLIPP_AMOUNT_PARAM, String.valueOf(amountToPay.doubleValue()));
        if (msgId != null) {
            resource = resource.queryParam(CLIPP_MESSAGE_ID_PARAM, msgId);
        }
        try {
            CloseTabResponse response = null;
            if (account.getDue().isZero() && msgId == null) {
                final WebResource resourceCopy = resource;
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        ((WebResource.Builder)((WebResource.Builder)ClippBarTabAuthority.this.setupAuthenticationAndHeaders(resourceCopy).accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE})).type(MediaType.APPLICATION_JSON_TYPE)).post(CloseTabResponse.class, (Object)ClippBarTabAuthority.this.buildTabDataForAccount(account));
                    }
                }).start();
                return new BarTabIntegrationServerResponseWrapper(true);
            }
            response = (CloseTabResponse)((WebResource.Builder)((WebResource.Builder)this.setupAuthenticationAndHeaders(resource).accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE})).type(MediaType.APPLICATION_JSON_TYPE)).post(CloseTabResponse.class, (Object)this.buildTabDataForAccount(account));
            return new BarTabIntegrationServerResponseWrapper<CloseTabResponse>(this.checkResponseGood(response), response);
        }
        catch (UniformInterfaceException ex) {
            OrderMate.LOG.error("ClippBarTabAuthority.requestCloseBarTab - Error while closing tab: " + account, (Throwable)ex);
            return new BarTabIntegrationServerResponseWrapper(false);
        }
    }

    public void sendRequestCloseBarTabErrorResponse(ErrorResponse errorResponse, String msgId, String extId, Price amount) {
        WebResource resource = this.restHelper.getResource(BarTabsConfiguration.getBarTabConfigForVendorId(VENDOR.getId()).getUrl() + ENDPOINT_CLOSE_TAB);
        resource = resource.queryParam(CLIPP_MESSAGE_ID_PARAM, msgId);
        resource = resource.queryParam(CLIPP_TAB_REF_PARAM, extId);
        resource = resource.queryParam(CLIPP_AMOUNT_PARAM, String.valueOf(amount.doubleValue()));
        try {
            ((WebResource.Builder)this.setupAuthenticationAndHeaders(resource).type(MediaType.APPLICATION_JSON_TYPE)).post((Object)errorResponse);
        }
        catch (UniformInterfaceException ex) {
            OrderMate.LOG.error("ClippBarTabAuthority.requestCloseBarTab - Error while closing tab" + extId, (Throwable)ex);
        }
    }

    @Override
    public BarTabSettlementResult requestSettleBarTab(BarTabAccount account) {
        return this.requestSettleBarTab(account, null, account.getDue(), null);
    }

    public BarTabSettlementResult requestSettleBarTab(BarTabAccount account, Price amount, String msgId) {
        return this.requestSettleBarTab(account, null, amount, msgId);
    }

    @Override
    public BarTabSettlementResult requestSettleBarTabAtPOS(BarTabAccount account, User user, Price amount) {
        try {
            BarTabIntegrationServerResponseWrapper<CloseTabResponse> wrappedResponse = this.requestCloseBarTab(account);
            if (wrappedResponse.isSuccess()) {
                return BarTabIntegrationManager.getInstance().barTabPayment(account, new Price(wrappedResponse.getResponse().getTotalPaymentAmount(), 0.01), new Price(wrappedResponse.getResponse().getTipAmount(), 0.01), new Price(wrappedResponse.getResponse().getProcessingFeeAmount(), 0.01), user);
            }
            OrderMate.LOG.info("Bar tab could not be settled from POS request: " + account);
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Error while attempting to settle tab from POS.", (Throwable)ex);
        }
        return new BarTabSettlementResult(false);
    }

    public BarTabSettlementResult requestSettleBarTab(BarTabAccount account, User user, Price amount, String msgId) {
        WebResource resource = this.restHelper.getResource(BarTabsConfiguration.getBarTabConfigForVendorId(VENDOR.getId()).getUrl() + ENDPOINT_REQUEST_PAY);
        resource = resource.queryParam(CLIPP_TAB_REF_PARAM, account.getExtID());
        resource = resource.queryParam(CLIPP_AMOUNT_PARAM, String.valueOf(amount.doubleValue()));
        if (msgId != null) {
            resource = resource.queryParam(CLIPP_MESSAGE_ID_PARAM, msgId);
        }
        try {
            BarTabPaymentResponse response = (BarTabPaymentResponse)((WebResource.Builder)this.setupAuthenticationAndHeaders(resource).type(MediaType.APPLICATION_JSON_TYPE)).post(BarTabPaymentResponse.class, (Object)"");
            return new BarTabSettlementResult(this.checkResponseGood(response));
        }
        catch (UniformInterfaceException ex) {
            OrderMate.LOG.error("ClippBarTabAuthority.requestBarTabPayment - Error while updating tab details", (Throwable)ex);
            return null;
        }
    }

    public void sendRequestSettleBarTabErrorResponse(ErrorResponse errorResponse, String msgId, String extId, Price amount) {
        WebResource resource = this.restHelper.getResource(BarTabsConfiguration.getBarTabConfigForVendorId(VENDOR.getId()).getUrl() + ENDPOINT_REQUEST_PAY);
        resource = resource.queryParam(CLIPP_TAB_REF_PARAM, extId);
        resource = resource.queryParam(CLIPP_MESSAGE_ID_PARAM, msgId);
        resource = resource.queryParam(CLIPP_AMOUNT_PARAM, String.valueOf(amount.doubleValue()));
        try {
            ((WebResource.Builder)this.setupAuthenticationAndHeaders(resource).type(MediaType.APPLICATION_JSON_TYPE)).post((Object)errorResponse);
        }
        catch (UniformInterfaceException ex) {
            OrderMate.LOG.error("ClippBarTabAuthority.requestBarTabPayment - Error while updating tab details", (Throwable)ex);
        }
    }

    @Override
    public BarTabSettlementResult requestSettleBarTab(BarTabAccount account, User user) {
        return this.requestSettleBarTabAtPOS(account, user, account.getDue());
    }

    @Override
    public boolean notifyBarTabModified(BarTabAccount account) {
        return this.notifyBarTabModified(account, null);
    }

    public boolean notifyBarTabModified(final BarTabAccount account, final String msgId) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                WebResource resource = ClippBarTabAuthority.this.restHelper.getResource(BarTabsConfiguration.getBarTabConfigForVendorId(VENDOR.getId()).getUrl() + ClippBarTabAuthority.ENDPOINT_SEND_TAB_DETAILS);
                resource = resource.queryParam(ClippBarTabAuthority.CLIPP_TAB_REF_PARAM, account.getExtID());
                if (msgId != null) {
                    resource = resource.queryParam(ClippBarTabAuthority.CLIPP_MESSAGE_ID_PARAM, msgId);
                }
                ReceiptData data = ClippBarTabAuthority.this.buildTabDataForAccount(account);
                try {
                    ((WebResource.Builder)ClippBarTabAuthority.this.setupAuthenticationAndHeaders(resource).type(MediaType.APPLICATION_JSON_TYPE)).post((Object)data);
                }
                catch (Exception ex) {
                    OrderMate.LOG.error("ClippBarTabAuthority.notifyBarTabModified - Error while updating tab details", (Throwable)ex);
                }
            }
        }).start();
        return true;
    }

    public void notifyBarTabModified(final ErrorResponse errorResponse, final String msgId) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                WebResource resource = ClippBarTabAuthority.this.restHelper.getResource(BarTabsConfiguration.getBarTabConfigForVendorId(VENDOR.getId()).getUrl() + ClippBarTabAuthority.ENDPOINT_SEND_TAB_DETAILS);
                resource = resource.queryParam(ClippBarTabAuthority.CLIPP_MESSAGE_ID_PARAM, msgId);
                try {
                    ((WebResource.Builder)ClippBarTabAuthority.this.setupAuthenticationAndHeaders(resource).type(MediaType.APPLICATION_JSON_TYPE)).post((Object)errorResponse);
                }
                catch (Exception ex) {
                    OrderMate.LOG.error("ClippBarTabAuthority.notifyBarTabModified - Error while updating tab details", (Throwable)ex);
                }
            }
        }).start();
    }

    @Override
    public boolean isTippingAllowed(BarTabAccount account) {
        return false;
    }

    @Override
    public boolean isPartialSettlementAllowed(BarTabAccount account) {
        return false;
    }

    @Override
    public boolean forceCloseZeroDollarAccountsAfterSettlement(BarTabAccount account) {
        return this.containsSettlementFinanceUnit(account, VENDOR.getId());
    }

    @Override
    public boolean isCreditLimitModifiable(BarTabAccount account) {
        return false;
    }

    @Override
    public void checkForUpdates() {
        WebResource resource = this.restHelper.getResource(BarTabsConfiguration.getBarTabConfigForVendorId(VENDOR.getId()).getUrl() + ENDPOINT_MESSAGES);
        List messages = (List)((WebResource.Builder)this.setupAuthenticationAndHeaders(resource).accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE})).get((GenericType)new GenericType<List<Message>>(){});
        if (messages.size() > 0) {
            OrderMate.LOG.info("Clipp Bar Tab Integration - Messages received: " + messages.size());
        }
        for (Message message : messages) {
            OrderMate.LOG.info("Clipp Bar Tab Integration - Handling Message");
            this.logData(Message.class, message);
            handler.processMessage(message);
        }
    }

    public static ClippBarTabAuthority getInstance() {
        if (instance == null) {
            instance = new ClippBarTabAuthority();
        }
        return instance;
    }

    private ReceiptData buildTabDataForAccount(BarTabAccount account) {
        ReceiptData accountData = new ReceiptData();
        accountData.setReceiptDate(this.convertToString(new Date()));
        accountData.setVenueReceiptId(account.getID().toString());
        accountData.setTotalAmount(account.getTotal().doubleValue());
        accountData.setOutstandingAmount(account.getDue().doubleValue());
        accountData.setIncludedTaxAmount(account.getTax().doubleValue());
        accountData.setVenueTabRef(ClippBarTabAuthority.getBarTabName(account));
        accountData.setTabLimit(account.getCreditLimit().doubleValue());
        for (SalesLineItem item : account.getItems()) {
            Item receiptItem = new Item();
            InventoryCategory category = item.getLowestSequenceInventoryCategory();
            if (category != null) {
                receiptItem.setCategory(category.getName());
            }
            if (item instanceof SalesItem) {
                SalesItem salesItem = (SalesItem)item;
                receiptItem.setDescription(salesItem.getLabel());
                if (salesItem.getInventoryItemIfSingle() != null) {
                    receiptItem.setVenueItemRef(salesItem.getInventoryItemIfSingle().getID().toString());
                } else {
                    receiptItem.setVenueItemRef(item.getID().toString());
                }
            } else if (item instanceof SalesCombo) {
                SalesCombo salesCombo = (SalesCombo)item;
                receiptItem.setDescription(salesCombo.getLabel());
                receiptItem.setVenueItemRef(salesCombo.getID().toString());
            }
            receiptItem.setDescription(item.getLabel());
            receiptItem.setQuantity(item.getQuantity().getValue().doubleValue());
            receiptItem.setPrice(item.getPricePerItem().doubleValue());
            receiptItem.setGroup(item.getMenuGroup() == null ? "No Group" : item.getMenuGroup().getLabel());
            receiptItem.setTotalAmount(item.getPrice().doubleValue());
            receiptItem.setDiscountAmount(item.getDiscountsTotal().doubleValue());
            receiptItem.setTaxInclusive(!item.getTax().isZero());
            accountData.getItems().add(receiptItem);
        }
        for (FinanceTransaction trans : account.getFinanceTransactions()) {
            Payment payment = new Payment();
            payment.setAmount(trans.getPaid().doubleValue());
            payment.setDescription(trans.getSubType().getLabel());
            payment.setVenuePaymentRef(trans.getID() != null ? trans.getID().toString() : "Unavailable");
            accountData.getPayments().add(payment);
        }
        return accountData;
    }

    private String convertToString(Date value) {
        if (value == null) {
            return null;
        }
        return ISO8601Utils.format((Date)value, (boolean)true, (TimeZone)TimeZone.getDefault());
    }

    private void logData(Class clazz, Object data) {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{clazz});
            Marshaller marshaller = jc.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            marshaller.setProperty("eclipselink.media-type", (Object)"application/json");
            marshaller.setProperty("eclipselink.json.include-root", (Object)Boolean.FALSE);
            marshaller.marshal(data, (OutputStream)output);
            OrderMate.LOG.info(output.toString());
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Error while logging data.");
        }
    }

    private boolean checkResponseGood(ErrorResponse response) {
        return response.getErrorCode() == null || response.getErrorCode() == 0L;
    }

    private WebResource.Builder setupAuthenticationAndHeaders(WebResource resource) {
        resource.addFilter((ClientFilter)new HTTPBasicAuthFilter(CLIPP_USERNAME, BarTabsConfiguration.getBarTabConfigForVendorId(VENDOR.getId()).getSecretKey()));
        return (WebResource.Builder)resource.header(POS_NAME_HEADER, (Object)"OrderMate").header(POS_VERSION_HEADER, (Object)OrderMate.VERSION);
    }

    public static String getBarTabName(BarTabAccount account) {
        if (account.isPersistent()) {
            long tabNum = account.getID() % 10000L;
            return String.valueOf(tabNum);
        }
        return account.getLabel();
    }

    static void setInstance(ClippBarTabAuthority authority) {
        instance = authority;
    }

    @Override
    public boolean closeBarTabEndOfDay(BarTabAccount account) {
        try {
            BarTabIntegrationServerResponseWrapper<CloseTabResponse> wrappedResponse = this.requestCloseBarTab(account);
            if (wrappedResponse.isSuccess()) {
                BarTabSettlementResult result = BarTabIntegrationManager.getInstance().barTabPayment(VENDOR.getId(), null, account.getExtID(), new Price(wrappedResponse.getResponse().getTotalPaymentAmount(), 0.01), new Price(wrappedResponse.getResponse().getTipAmount(), 0.01), new Price(wrappedResponse.getResponse().getProcessingFeeAmount(), 0.01));
                if (result.isSuccessful()) {
                    BarTabIntegrationManager.getInstance().closeBarTabAccount(VENDOR.getId(), null, account.getExtID());
                } else {
                    OrderMate.LOG.info("Payment could not be assigned to bar tab to auto close at end of day: " + account);
                }
            } else {
                OrderMate.LOG.info("Bar tab could not be automatically closed at end of day: " + account);
            }
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Error while auto closing tab and end of day.", (Throwable)ex);
        }
        return false;
    }

    private boolean shouldSendRequestCloseBarTab(BarTabAccount account) {
        return !account.getDue().isZero() || !this.lastTransactionAuthortityFinanceUnit(account);
    }

    private boolean lastTransactionAuthortityFinanceUnit(BarTabAccount account) {
        FinanceTransaction lastTrans = null;
        for (FinanceTransaction financeTrans : account.getFinanceTransactions()) {
            if (lastTrans != null && !lastTrans.getCreationTime().before(financeTrans.getCreationTime())) continue;
            lastTrans = financeTrans;
        }
        return lastTrans != null && lastTrans.getSubType().equals(BarTabsConfiguration.getBarTabConfigForVendorId(VENDOR.getId()).getFinanceUnit());
    }
}

