/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.bartabs.clipp;

public enum ClippErrorMessage {
    TAB_CLOSED(1001, "Tab closed on POS"),
    TAB_NOT_FOUND(1002, "Tab not found on POS"),
    INVALID_CLOSE_AMOUNT(1003, "Invalid close amount"),
    UNABLE_TO_OPEN_TAB(1004, "Unable to open tab"),
    UNABLE_TO_CLOSE_TAB(1005, "Unable to close tab"),
    TAB_IN_USE(1006, "Tab in use"),
    INVALID_IDENTIFIER(1001, "Invalid tab/receipt identifier"),
    INVALID_PAYMENT_AMOUNT(1002, "Invalid payment amount"),
    FAILED_TO_PARSE_DATE(1003, "Failed to parse tab/receipt data."),
    INVALID_DATA(1004, "Invalid tab/receipt data"),
    PAYMENT_TYPE_NOT_SUPPORTED(1005, "Payment type not supported"),
    INVALID_PAYMENT_TYPE(1006, "Invalid payment type"),
    INVALID_REPORT_DATE(1007, "Invalid report date"),
    TAB_ALREADY_CLOSED(2001, "Tab has already been closed"),
    TAB_CLOSED_NOT_REQUESTED_BY_USER(2002, "Tab close not requested by user"),
    TAB_PAY_NOT_REQUESTED_BY_USER(2003, "Tab pay not requested by user"),
    TAB_PAY_NOT_CONFIRMED_BY_USER(2004, "Tab pay not confirmed by user"),
    PAYMENT_NOT_MATCH_USER_REQUEST(3001, "Payment amount does not match user request"),
    DUPLICATE_PAYMENT_REQUEST(3002, "Duplicate payment request"),
    PAYMENT_EXCEEDS_AUTHORIZED_AMOUNT(3003, "Payment amount exceeds authorized amount"),
    PAYMENT_CAPTURE_FAILED(3004, "Payment capture failed"),
    PAYMENT_DOESNT_MATCH_OUTSTANDING_BALANCE(3005, "Payment amount does not match outstanding balance in tab/receipt data"),
    UNEXPECTED_ERROR(5000, "Unexpected error"),
    ERROR_RECIEVED_FROM_POS(5001, "Error message received from POS"),
    REQUEST_NOT_SUPPORTED(5002, "Request not supported");

    private int code;
    private String description;

    private ClippErrorMessage(int code, String description) {
        this.code = code;
        this.description = description;
    }

    public int getCode() {
        return this.code;
    }

    public String getDescription() {
        return this.description;
    }

    public static ClippErrorMessage getErrorMessageForCode(int code) {
        for (ClippErrorMessage errorMessage : ClippErrorMessage.values()) {
            if (errorMessage.getCode() != code) continue;
            return errorMessage;
        }
        return null;
    }
}

