/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.bartabs.clipp;

import au.com.ordermate.util.Price;
import ordermate.OrderMate;
import ordermate.database.sales.BarTabAccount;
import ordermate.database.users.User;
import ordermate.integration.bartabs.BarTabIntegrationHelper;
import ordermate.integration.bartabs.BarTabIntegrationServerResponseWrapper;
import ordermate.integration.bartabs.BarTabSettlementResult;
import ordermate.integration.bartabs.clipp.ClippBarTabAuthority;
import ordermate.integration.jaxb.clippbartabs.CloseTabResponse;
import ordermate.integration.jaxb.clippbartabs.ErrorResponse;
import ordermate.integration.jaxb.clippbartabs.Message;
import ordermate.webresource.bartabs.BarTabIntegrationManager;
import ordermate.webresource.bartabs.BarTabsResourceException;
import ordermate.webresource.bartabs.BarTabsResultCode;

class ClippMessageHandler {
    private static final String TAB_OPEN_TYPE = "TAB_OPEN";
    private static final String TAB_STATUS_TYPE = "TAB_STATUS";
    private static final String TAB_PAY_TYPE = "TAB_PAY";
    private static final String TAB_CLOSE_TYPE = "TAB_CLOSE";
    private static final String TAB_UDPATE = "TAB_UPDATE";

    ClippMessageHandler() {
    }

    public synchronized void processMessage(Message message) {
        if (TAB_OPEN_TYPE.equals(message.getMessageType())) {
            this.processOpenTabMessage(message);
        } else if (TAB_STATUS_TYPE.equals(message.getMessageType())) {
            this.processTabStatusMessage(message);
        } else if (TAB_PAY_TYPE.equals(message.getMessageType())) {
            this.processPayTabMessage(message);
        } else if (TAB_CLOSE_TYPE.equals(message.getMessageType())) {
            this.processCloseTabMessage(message);
        } else if (TAB_UDPATE.equals(message.getMessageType())) {
            this.processTabUpdateMessage(message);
        } else {
            OrderMate.LOG.error("ClippMessageHandler - Unknown message type recieved: " + message.getMessageType());
        }
    }

    private void processOpenTabMessage(Message message) {
        try {
            BarTabAccount account = BarTabIntegrationManager.getInstance().openBarTabAccount(message.getData().getClippUserRef(), message.getData().getTabLimit(), message.getData().getClippTabRef(), ClippBarTabAuthority.VENDOR.getId());
            ClippBarTabAuthority.getInstance().notifyBarTabModified(account, message.getMessageId());
        }
        catch (Exception ex) {
            OrderMate.LOG.error("ClippMessageHandler.processOpenTabMessage - Error while attempting to open a tab.", (Throwable)ex);
            ClippBarTabAuthority.getInstance().notifyBarTabModified(this.convertToClippErrorResponse(ex), message.getMessageId());
        }
    }

    private void processTabStatusMessage(Message message) {
        BarTabAccount account = BarTabIntegrationHelper.getBarTabFromExtId(ClippBarTabAuthority.VENDOR.getId(), message.getData().getClippTabRef(), null);
        ClippBarTabAuthority.getInstance().notifyBarTabModified(account, message.getMessageId());
    }

    private void processPayTabMessage(Message message) {
        try {
            BarTabIntegrationManager.getInstance().checkVendorId(ClippBarTabAuthority.VENDOR.getId());
            Price toPay = new Price(message.getData().getTotalPaymentAmount(), 0.01);
            BarTabSettlementResult result = BarTabIntegrationManager.getInstance().barTabPayment(ClippBarTabAuthority.VENDOR.getId(), null, message.getData().getClippTabRef(), toPay, Price.ZERO, new Price(message.getData().getProcessingFeeAmount()));
            if (!result.isSuccessful()) {
                throw new BarTabsResourceException(BarTabsResultCode.INTERNAL_SERVER_ERROR);
            }
            ClippBarTabAuthority.getInstance().requestSettleBarTab(BarTabIntegrationHelper.getBarTabFromExtId(ClippBarTabAuthority.VENDOR.getId(), message.getData().getClippTabRef(), null), toPay, message.getMessageId());
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Error occured within processPayTabMessage method: ", (Throwable)ex);
            ClippBarTabAuthority.getInstance().sendRequestSettleBarTabErrorResponse(this.convertToClippErrorResponse(ex), message.getMessageId(), message.getData().getClippTabRef(), new Price(message.getData().getTotalPaymentAmount(), 0.01));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processCloseTabMessage(Message message) {
        try {
            BarTabIntegrationManager.getInstance().checkVendorId(ClippBarTabAuthority.VENDOR.getId());
            Price toPay = new Price(message.getData().getTotalPaymentAmount(), 0.01);
            BarTabSettlementResult settlementResult = null;
            BarTabAccount barTabAccount = BarTabIntegrationHelper.getBarTabFromExtId(ClippBarTabAuthority.VENDOR.getId(), message.getData().getClippTabRef(), null);
            ClippBarTabAuthority.getInstance().addBarTabNotToSendStatusUpdatesFor(barTabAccount);
            try {
                Price toTip;
                if (barTabAccount == null) {
                    throw new BarTabsResourceException(BarTabsResultCode.BAR_TAB_NOT_FOUND);
                }
                if (!barTabAccount.isOpen()) {
                    throw new BarTabsResourceException(BarTabsResultCode.ERROR_BARTAB_ALREADY_CLOSED);
                }
                User user = User.getSystemUser();
                if (!barTabAccount.isLocked(user) && !barTabAccount.lock(user)) {
                    throw new BarTabsResourceException(BarTabsResultCode.ERROR_BARTAB_LOCKED_BY_ANOTHER_USER);
                }
                BarTabIntegrationServerResponseWrapper responseWrapper = ClippBarTabAuthority.getInstance().requestCloseBarTab(BarTabIntegrationHelper.getBarTabFromExtId(ClippBarTabAuthority.VENDOR.getId(), message.getData().getClippTabRef(), null), message.getMessageId(), toPay);
                if (!responseWrapper.isSuccess()) {
                    return;
                }
                toPay = new Price(((CloseTabResponse)responseWrapper.getResponse()).getTotalPaymentAmount(), 0.01);
                Price price = toTip = ((CloseTabResponse)responseWrapper.getResponse()).getTipAmount() != null ? new Price(((CloseTabResponse)responseWrapper.getResponse()).getTipAmount(), 0.01) : Price.ZERO_DOLLAR;
                if (!toTip.isZero()) {
                    toPay = toPay.subtract(toTip);
                }
                if (!toPay.isZero()) {
                    settlementResult = BarTabIntegrationManager.getInstance().barTabPayment(ClippBarTabAuthority.VENDOR.getId(), null, message.getData().getClippTabRef(), toPay, toTip, new Price(((CloseTabResponse)responseWrapper.getResponse()).getProcessingFeeAmount(), 0.01));
                }
                if (toPay.isZero() || settlementResult != null && settlementResult.isSuccessful()) {
                    BarTabIntegrationManager.getInstance().closeBarTabAccount(ClippBarTabAuthority.VENDOR.getId(), null, message.getData().getClippTabRef());
                    return;
                }
            }
            finally {
                ClippBarTabAuthority.getInstance().removeBarTabNotToSendStatusUpdatesFor(barTabAccount);
            }
            throw new BarTabsResourceException(BarTabsResultCode.INTERNAL_SERVER_ERROR);
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Error occured within processCloseTabMessage method: ", (Throwable)ex);
            ClippBarTabAuthority.getInstance().sendRequestCloseBarTabErrorResponse(this.convertToClippErrorResponse(ex), message.getMessageId(), message.getData().getClippTabRef(), new Price(message.getData().getTotalPaymentAmount(), 0.01));
            return;
        }
    }

    private void processTabUpdateMessage(Message message) {
        try {
            BarTabAccount account = BarTabIntegrationManager.getInstance().updateBarTabLimit(ClippBarTabAuthority.VENDOR.getId(), null, message.getData().getClippTabRef(), new Price(message.getData().getTabLimit(), 0.01));
            ClippBarTabAuthority.getInstance().notifyBarTabModified(account, message.getMessageId());
        }
        catch (Exception ex) {
            OrderMate.LOG.error("ClippMessageHandler.processTabUpdateMessage - Error while attempting to update a tab.", (Throwable)ex);
            ClippBarTabAuthority.getInstance().notifyBarTabModified(this.convertToClippErrorResponse(ex), message.getMessageId());
        }
    }

    private ErrorResponse convertToClippErrorResponse(Exception ex) {
        if (ex instanceof BarTabsResourceException) {
            BarTabsResourceException barTabsEx = (BarTabsResourceException)ex;
            if (BarTabsResultCode.ERROR_BARTAB_ALREADY_CLOSED.equals((Object)barTabsEx.getResultCode())) {
                ErrorResponse response = new ErrorResponse();
                response.setErrorCode(1001L);
                response.setErrorDescription("Tab has already been paid and closed. Unable to process request.");
                return response;
            }
            if (BarTabsResultCode.BAR_TAB_NOT_FOUND.equals((Object)barTabsEx.getResultCode())) {
                ErrorResponse response = new ErrorResponse();
                response.setErrorCode(1002L);
                response.setErrorDescription("Specified tab does not exist on POS. Unable to process request.");
                return response;
            }
            if (BarTabsResultCode.ERROR_BARTAB_LOCKED_BY_ANOTHER_USER.equals((Object)barTabsEx.getResultCode())) {
                ErrorResponse response = new ErrorResponse();
                response.setErrorCode(1006L);
                response.setErrorDescription("Tab is currently in use. Requested action not permitted whilst tab is in use");
                return response;
            }
            ErrorResponse response = new ErrorResponse();
            response.setErrorCode(Long.valueOf(barTabsEx.getResultCode().getCode()));
            response.setErrorDescription(barTabsEx.getResultCode().toString());
            return response;
        }
        return this.getUnknownResponseError();
    }

    private ErrorResponse getUnknownResponseError() {
        ErrorResponse errorResponse = new ErrorResponse();
        errorResponse.setErrorCode(Long.valueOf(BarTabsResultCode.INTERNAL_SERVER_ERROR.getCode()));
        errorResponse.setErrorDescription(BarTabsResultCode.INTERNAL_SERVER_ERROR.toString());
        return errorResponse;
    }
}

