/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.bartabs.onetab;

import au.com.ordermate.util.Price;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import ordermate.database.finance.transactions.FinanceUnit;
import ordermate.database.integration.bartabs.BarTabsConfiguration;
import ordermate.database.sales.BarTabAccount;
import ordermate.database.users.User;
import ordermate.integration.bartabs.BarTabAuthority;
import ordermate.integration.bartabs.BarTabIntegrationServerResponseWrapper;
import ordermate.integration.bartabs.BarTabSettlementResult;
import ordermate.integration.bartabs.BarTabVendor;
import ordermate.integration.bartabs.onetab.OneTabUpdateProcessor;
import ordermate.integration.jaxb.onetabbartabs.OneTabBarTab;
import ordermate.integration.webservice.RestHelper;

public class OneTabBarTabAuthority
extends BarTabAuthority {
    public static final BarTabVendor VENDOR = BarTabVendor.OneTab;
    private static OneTabBarTabAuthority instance;
    private static final String BASE = "posVendor/";
    private static final String CLOSE_ACCOUNT = "closeBartab/";
    private static final String QUERY_BARTABS = "queryBartabs/";
    private static final String ACK_UPDATE = "acknowledgeBartabStatus/";
    static final String API_KEY = "api_key";
    static final String API_VALUE = "cz3qOBqbsBrgQgB6zkNR";
    private final RestHelper rest = new RestHelper();
    private BarTabsConfiguration config;

    public static OneTabBarTabAuthority getInstance() {
        if (instance == null) {
            instance = new OneTabBarTabAuthority();
        }
        return instance;
    }

    private OneTabBarTabAuthority() {
    }

    protected BarTabsConfiguration getConfig() {
        if (this.config == null) {
            this.config = BarTabsConfiguration.getBarTabConfigForVendorId(VENDOR.getId());
            if (this.config == null) {
                this.config = new BarTabsConfiguration();
                this.config.setName(VENDOR.name());
                this.config.setVendorId(VENDOR.getId());
                this.config.setEnabled(false);
                this.config.setFinanceUnit(FinanceUnit.getWebUnits().get(0));
                this.config.setUrl("https://onetab.com.au/api/swagger/");
                this.config.setMerchantId("123");
                this.config.save();
            }
        }
        return this.config;
    }

    protected WebResource makeResourceTo(String endpoint, Object ... pathParams) {
        StringBuilder SB = new StringBuilder(this.getConfig().getUrl());
        SB.append(BASE).append(endpoint).append(this.config.getMerchantId());
        if (pathParams.length > 0) {
            for (Object nextParam : pathParams) {
                SB.append("/").append(String.valueOf(nextParam));
            }
        }
        SB.append(".json");
        WebResource resource = this.rest.getResource(SB.toString());
        resource = this.rest.addParameter(resource, API_KEY, API_VALUE);
        return resource;
    }

    @Override
    public BarTabIntegrationServerResponseWrapper requestCloseBarTab(BarTabAccount account) {
        WebResource resource = this.makeResourceTo(CLOSE_ACCOUNT, account.getExtID());
        ClientResponse response = (ClientResponse)resource.put(ClientResponse.class);
        BarTabIntegrationServerResponseWrapper<Object> wrapper = new BarTabIntegrationServerResponseWrapper<Object>(200 == response.getStatus(), response.getEntity(OneTabBarTab.class));
        return wrapper;
    }

    @Override
    public BarTabSettlementResult requestSettleBarTab(BarTabAccount account) {
        throw new IllegalStateException("Not Implemented");
    }

    @Override
    public BarTabSettlementResult requestSettleBarTab(BarTabAccount account, User user) {
        throw new IllegalStateException("Not Implemented");
    }

    @Override
    public BarTabSettlementResult requestSettleBarTabAtPOS(BarTabAccount account, User user, Price amount) {
        throw new IllegalStateException("Not Implemented");
    }

    @Override
    public boolean notifyBarTabModified(BarTabAccount account) {
        throw new IllegalStateException("Not Implemented");
    }

    @Override
    public boolean isTippingAllowed(BarTabAccount account) {
        throw new IllegalStateException("Not Implemented");
    }

    @Override
    public boolean isPartialSettlementAllowed(BarTabAccount account) {
        throw new IllegalStateException("Not Implemented");
    }

    @Override
    public boolean forceCloseZeroDollarAccountsAfterSettlement(BarTabAccount account) {
        throw new IllegalStateException("Not Implemented");
    }

    @Override
    public boolean isCreditLimitModifiable(BarTabAccount account) {
        throw new IllegalStateException("Not Implemented");
    }

    @Override
    public boolean closeBarTabEndOfDay(BarTabAccount account) {
        throw new IllegalStateException("Not Implemented");
    }

    @Override
    public void checkForUpdates() {
        WebResource resource = this.makeResourceTo(QUERY_BARTABS, new Object[0]);
        ClientResponse response = (ClientResponse)((WebResource.Builder)resource.type("application/json").accept(new String[]{"application/json"})).get(ClientResponse.class);
        if (response.getLength() != 0) {
            OneTabBarTab[] barTabs;
            for (OneTabBarTab tab : barTabs = (OneTabBarTab[])response.getEntity(OneTabBarTab[].class)) {
                new OneTabUpdateProcessor(tab).processTab();
            }
        }
    }

    void acknowledgeBartab(OneTabBarTab tab) {
        WebResource resource = this.makeResourceTo(ACK_UPDATE, tab.getId(), tab.getStatus());
        ClientResponse response = (ClientResponse)resource.put(ClientResponse.class);
    }
}

