/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.bartabs.onetab;

import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.util.Price;
import ordermate.OrderMate;
import ordermate.database.finance.transactions.EftposTransaction;
import ordermate.database.finance.transactions.FinanceTransaction;
import ordermate.database.sales.BarTabAccount;
import ordermate.database.users.User;
import ordermate.integration.bartabs.BarTabSettlementResult;
import ordermate.integration.bartabs.BarTabVendor;
import ordermate.integration.bartabs.onetab.OneTabBarTabAuthority;
import ordermate.integration.jaxb.onetabbartabs.OneTabBarTab;
import ordermate.webresource.bartabs.BarTabIntegrationManager;
import ordermate.webresource.bartabs.BarTabsResourceException;

class OneTabUpdateProcessor {
    private final OneTabBarTab tab;
    private BarTabAccount account;

    OneTabUpdateProcessor(OneTabBarTab yourTab) {
        this.tab = yourTab;
    }

    void processTab() {
        this.getBarTab();
        if (this.account == null) {
            return;
        }
        OrderMate.LOG.info("Updating OneTab Bartab " + this.tab.getId());
        if (this.account.lock(User.getSystemUser())) {
            try {
                if (this.update()) {
                    OneTabBarTabAuthority.getInstance().acknowledgeBartab(this.tab);
                }
            }
            finally {
                this.account.unlock();
            }
        }
    }

    private void getBarTab() {
        this.account = PersistenceManager.getObject(BarTabAccount.class, Query.select(BarTabAccount.class).equals(BarTabAccount.Properties.SOURCE, BarTabVendor.OneTab.getId()).equals(BarTabAccount.Properties.EXT_ID, this.tab.getId()).toString());
        if (this.account == null) {
            this.account = this.createNewAccount();
        }
    }

    private BarTabAccount createNewAccount() {
        OrderMate.LOG.info("Creating new account for one tab");
        BarTabAccount barTab = null;
        try {
            barTab = BarTabIntegrationManager.getInstance().openBarTabAccount(BarTabVendor.OneTab.name() + " " + this.tab.getBartabCode(), this.tab.getMaxLimit().doubleValue(), this.tab.getId(), BarTabVendor.OneTab.getId());
        }
        catch (BarTabsResourceException ex) {
            OrderMate.LOG.error("Couldn't create bartab", (Throwable)ex);
        }
        return barTab;
    }

    private boolean update() {
        OneTabStatus status = OneTabStatus.getStatusForCode(this.tab.getStatus());
        if (OneTabStatus.Closed.equals((Object)status)) {
            try {
                BarTabSettlementResult result = BarTabIntegrationManager.getInstance().barTabPayment(this.account, this.account.getDue(), this.tab.getTipAmount() != null ? new Price(this.tab.getTipAmount(), 0.01) : Price.ZERO_DOLLAR, Price.ZERO_DOLLAR, User.getSystemUser());
                if (result.isSuccessful()) {
                    FinanceTransaction txn = result.getFinanceTransaction();
                    if (txn instanceof EftposTransaction) {
                        ((EftposTransaction)txn).setTransactionReference(this.tab.getTransactionId());
                    } else {
                        txn.setNote(txn.getNote() + " " + this.tab.getTransactionId());
                    }
                    BarTabIntegrationManager.getInstance().closeBarTabAccount(OneTabBarTabAuthority.VENDOR.getId(), this.account.getID().toString(), this.account.getExtID());
                }
            }
            catch (BarTabsResourceException ex) {
                OrderMate.LOG.error("Cannot add payment to onetab BarTab", (Throwable)ex);
                return false;
            }
        }
        return true;
    }

    static enum OneTabStatus {
        Pending(0),
        Active(1),
        PendingFinalize(2),
        PendingPayment(3),
        PendingTransfer(4),
        Closed(5),
        Void(6),
        Refunded(7);

        final int code;

        private OneTabStatus(int value) {
            this.code = value;
        }

        static OneTabStatus getStatusForCode(Integer statusCode) {
            if (statusCode == null) {
                return Void;
            }
            int theCode = statusCode;
            for (OneTabStatus status : OneTabStatus.values()) {
                if (status.code != theCode) continue;
                return status;
            }
            return Void;
        }
    }
}

