/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.camera;

import au.com.ordermate.util.StringUtils;
import com.sun.jersey.api.client.WebResource;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import ordermate.OrderMate;
import ordermate.database.hardware.Terminal;
import ordermate.integration.camera.CameraViewer;
import ordermate.integration.webservice.RestHelper;

public class MobotixCameraViewer
implements CameraViewer {
    private static final long DELAY = 2000L;
    private static final String TRUE = "1";
    private static final String FALSE = "0";
    private static final String IP = "ip";
    private static final String PORT = "port";
    private static final String BEEP = "beep";
    private static final String FULL_SCREEN = "fullscreen";
    private static final String HIDE_CONTROLS = "hidecontrols";
    private static final String ON_TOP = "OnTop";
    private static final String CLOSE = "CloseMxCC";
    private static final String LAYOUT = "layout";
    private static final String PLAYER = "player";
    private static final String PLAY = "play";
    private static final String ENABLE = "enable";
    private static final String DISABLE = "disable";
    private static final String STOP = "stop";
    private static final String JUMP_TO = "jumptotime";
    private static final String EVENT_AT = "openeventsearchattime";
    private String url;
    DateFormat format = new SimpleDateFormat("yyyy:MM:dd/HH:mm:ss");
    private RestHelper helper;

    public MobotixCameraViewer(String yourUrl) {
        this.url = yourUrl;
        this.helper = new RestHelper();
        if (this.url == null) {
            throw new IllegalArgumentException("Cannot call mobotix without a proper url.");
        }
    }

    @Override
    public void showFootage(Date from, Terminal terminal) {
        this.performGet(this.setUp(terminal, from), this.play());
    }

    public WebResource setLayout(WebResource resource, Terminal terminal) {
        if (terminal == null) {
            return resource;
        }
        String layout = terminal.getCameraLayout();
        if (!StringUtils.isEmpty(layout)) {
            resource = this.helper.addParameter(resource, LAYOUT, layout);
        }
        return resource;
    }

    private WebResource setUp(Terminal terminal, Date from) {
        WebResource resource = this.helper.getResource(this.url);
        resource = this.helper.addParameter(resource, FULL_SCREEN, FALSE);
        resource = this.setLayout(resource, terminal);
        resource = this.helper.addParameter(resource, PLAYER, ENABLE);
        resource = this.helper.addParameter(resource, PLAYER, "jumptotime%20" + this.formatDate(from));
        return resource;
    }

    private WebResource play() {
        WebResource resource = this.helper.getResource(this.url);
        resource = this.helper.addParameter(resource, PLAYER, PLAY);
        return resource;
    }

    @Override
    public void stopFootage() {
        WebResource resource = this.helper.getResource(this.url);
        resource = this.helper.addParameter(resource, PLAYER, STOP);
        resource = this.helper.addParameter(resource, PLAYER, DISABLE);
        this.performGet(resource);
    }

    public void performGet(final WebResource ... resources) {
        new Thread(){

            @Override
            public void run() {
                for (WebResource nextResource : resources) {
                    if (nextResource == null) continue;
                    OrderMate.LOG.debug("Getting resource:" + nextResource.toString());
                    String result = (String)((WebResource.Builder)nextResource.getRequestBuilder().type("text/plain")).get(String.class);
                    OrderMate.LOG.debug("Camera Result:" + result);
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }.start();
    }

    String formatDate(Date date) {
        return this.format.format(date);
    }
}

