/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.cloudback;

import au.com.ordermate.util.Pair;
import com.sun.jersey.api.client.WebResource;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import ordermate.OrderMate;
import ordermate.database.integration.cloudback.CloudBackConfig;
import ordermate.database.misc.SystemCurrentInfo;
import ordermate.integration.webservice.PassthroughX509TrustManager;
import ordermate.integration.webservice.RestHelper;

public abstract class CloudBackClient {
    private final CloudBackConfig cloudBackConfig;
    private final Integer DEFAULT_TIMEOUT;
    private Integer timeout;
    static final String MSG_NULL_CLOUD_CONFIG = "Cloud server configuration cannot be null!";
    static final String MSG_NOT_ENABLED_CLOUD_CONFIG = " configuration should be enabled to send requests!";
    private static final String AGENT_KEY = "CCAgent";
    private static final String AGENT_VALUE = "AgentRedCoat";

    public CloudBackClient(CloudBackConfig cloudConfig) {
        this.timeout = this.DEFAULT_TIMEOUT = Integer.valueOf(30000);
        if (cloudConfig == null) {
            throw new IllegalArgumentException(MSG_NULL_CLOUD_CONFIG);
        }
        this.cloudBackConfig = cloudConfig;
    }

    protected void validateCloudConfigEnabled() {
        if (!this.cloudBackConfig.isEnabled()) {
            throw new IllegalStateException(this.cloudBackConfig + MSG_NOT_ENABLED_CLOUD_CONFIG);
        }
    }

    protected void setTimeout(Integer newTimeout) {
        this.timeout = newTimeout;
    }

    protected Integer getTimeout() {
        return this.timeout;
    }

    protected WebResource.Builder setupResource(String path, Pair ... queryParams) {
        WebResource resource;
        RestHelper rest = new RestHelper();
        String destination = this.getBaseURL() + path;
        OrderMate.LOG.info(this.cloudBackConfig + " endpoint call, destination: " + destination);
        if (destination.startsWith("https")) {
            this.verifyHostname();
            resource = this.createSslResource(rest, destination);
        } else {
            resource = rest.getResource(destination, this.getTimeout(), this.getTimeout());
        }
        resource = rest.addBasicAuth(resource, this.cloudBackConfig.getWebConfig().getUsername(), this.cloudBackConfig.getWebConfig().getPassword());
        for (Pair pair : queryParams) {
            resource = rest.addParameter(resource, String.valueOf(pair.key), String.valueOf(pair.value));
        }
        return resource.header(AGENT_KEY, (Object)AGENT_VALUE);
    }

    protected WebResource createSslResource(RestHelper rest, String destination) {
        return rest.getSSLWebResource(destination, new PassthroughX509TrustManager(), this.getTimeout(), this.getTimeout(), this.getSSLProtocol());
    }

    protected String getSSLProtocol() {
        return "SSL";
    }

    protected String getBaseURL() {
        String url = this.cloudBackConfig.getWebConfig().getUrl();
        if (url != null && !url.endsWith("/")) {
            url = url + "/";
        }
        return url;
    }

    protected long getRedBackId() {
        return SystemCurrentInfo.getInstance().getRedbackId();
    }

    protected Pair<String, Object> createQueryParam(String key, Object value) {
        return new Pair<String, Object>(key, value);
    }

    private void verifyHostname() {
        HttpsURLConnection.setDefaultHostnameVerifier(new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return true;
            }
        });
    }
}

