/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.cloudback;

import ordermate.database.integration.cloudback.CloudServerType;
import ordermate.integration.cloudback.CloudBackClient;
import ordermate.integration.cloudback.nudge.NudgeBackClient;
import ordermate.integration.cloudback.redback.RedBackClient;

public class CloudBackClientFactory {
    static final String MSG_NULL_CLOUD_SERVER_TYPE = "Cloud server type cannot be null!";

    public static CloudBackClient createCloudBackClient(CloudServerType cloudServerType) {
        if (cloudServerType == null) {
            throw new IllegalArgumentException(MSG_NULL_CLOUD_SERVER_TYPE);
        }
        switch (cloudServerType) {
            case Nudge: {
                return new NudgeBackClient();
            }
            case RedBack: {
                return new RedBackClient();
            }
        }
        throw new IllegalArgumentException("Please implement cloud back client for your server type! " + (Object)((Object)cloudServerType));
    }
}

