/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.cloudback;

import au.com.ordermate.xmlintegration.omni.OmniBackRequirements;
import au.com.ordermate.xmlintegration.omni.OmniBackRequirementsType;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import ordermate.OrderMate;
import ordermate.database.integration.cloudback.CloudBackConfig;
import ordermate.database.integration.cloudback.CloudServerType;
import ordermate.database.integration.webservice.WebserviceIntegrationConfig;
import ordermate.integration.webservice.PassthroughX509TrustManager;
import ordermate.integration.webservice.RestHelper;
import org.apache.logging.log4j.Level;

public class CloudIntegrationUtil {
    private static final String REDBACK_ID = "redbackId";

    public static WebResource getPlainResource(WebserviceIntegrationConfig config, String endpoint) {
        String url = config.getUrl() + endpoint;
        RestHelper rest = new RestHelper();
        WebResource resource = url.startsWith("https") ? rest.getSslResource(url, new PassthroughX509TrustManager(), 15000, 30000) : rest.getResource(url, 15000, 30000);
        return resource;
    }

    public static OmniBackRequirements parseRequirements(String entity) {
        String toRemove = "xmlns=\"http://www.ordermate.com.au/xmlintegration/omni\"";
        if (entity.contains(toRemove)) {
            entity = entity.replace(toRemove, "");
        }
        OmniBackRequirements reqs = null;
        try {
            reqs = (OmniBackRequirements)JAXBContext.newInstance((Class[])new Class[]{OmniBackRequirements.class}).createUnmarshaller().unmarshal((Reader)new StringReader(entity));
        }
        catch (JAXBException ex) {
            OrderMate.LOG.error("Cannot parse Omniback requirements from " + entity, (Throwable)ex);
        }
        return reqs;
    }

    public static OmniBackRequirements getRequirementTypes(CloudBackConfig config, long redbackId) {
        WebResource reqTypes = CloudIntegrationUtil.getPlainResource(config.getWebConfig(), "common/reqtypes");
        ClientResponse response = (ClientResponse)(reqTypes = reqTypes.queryParam(REDBACK_ID, String.valueOf(redbackId))).header(CloudIntegrationUtil.getAgent(config), (Object)"QWdlbnQgTWF4").get(ClientResponse.class);
        if (response == null) {
            throw new IllegalStateException(config.getLabel() + " could not be reached.");
        }
        String entity = (String)response.getEntity(String.class);
        if (response.getStatus() / 100 != 2) {
            throw new IllegalStateException(config.getLabel() + " access denied.");
        }
        OrderMate.LOG.info("Received reqTypes from " + config.getLabel() + ": " + entity);
        OmniBackRequirements reqs = CloudIntegrationUtil.parseRequirements(entity);
        return reqs;
    }

    public static OmniBackRequirements getRequirementsForType(CloudBackConfig config, long redbackId, OmniBackRequirementsType type) {
        WebResource reqWebservice = CloudIntegrationUtil.getPlainResource(config.getWebConfig(), "common/storereq");
        reqWebservice = reqWebservice.queryParam(REDBACK_ID, String.valueOf(redbackId));
        reqWebservice = reqWebservice.queryParam("type", type.getValue());
        ClientResponse response = (ClientResponse)reqWebservice.header(CloudIntegrationUtil.getAgent(config), (Object)"QWdlbnQgTWF4").get(ClientResponse.class);
        String entity = (String)response.getEntity(String.class);
        if (response.getStatus() / 100 != 2) {
            OrderMate.LOG.error("Invalid response " + entity);
            return null;
        }
        OrderMate.LOG.info("Received reqs " + entity);
        OmniBackRequirements reqs = CloudIntegrationUtil.parseRequirements(entity);
        return reqs;
    }

    public static ClientResponse postRequirements(CloudBackConfig cloudConfig, long redbackId, OmniBackRequirements reqs) {
        reqs.setStoreId(redbackId);
        WebResource reqWebservice = CloudIntegrationUtil.getPlainResource(cloudConfig.getWebConfig(), "common/storereq");
        reqWebservice = reqWebservice.queryParam("type", reqs.getTypeValue());
        try {
            ClientResponse response = (ClientResponse)((WebResource.Builder)((WebResource.Builder)reqWebservice.header("Content-Type", (Object)"application/xml").header("Accept", (Object)"application/xml")).header(CloudIntegrationUtil.getAgent(cloudConfig), (Object)"QWdlbnQgTWF4")).post(ClientResponse.class, (Object)CloudIntegrationUtil.marshal(reqs));
            return response;
        }
        catch (Exception ex) {
            OrderMate.LOG.log(Level.ERROR, "Cannot make call to post requirements", (Throwable)ex);
            return null;
        }
    }

    private static String getAgent(CloudBackConfig cloudConfig) {
        return CloudServerType.Hive == cloudConfig.getCloudServerType() ? "Hive-Agent" : "CCAgent";
    }

    public static String marshal(OmniBackRequirements reqs) {
        String toAdd = " xmlns=\"http://www.ordermate.com.au/xmlintegration/omni\" ";
        try {
            StringWriter writer = new StringWriter();
            JAXBContext.newInstance((Class[])new Class[]{OmniBackRequirements.class}).createMarshaller().marshal((Object)reqs, (Writer)writer);
            writer.flush();
            String entity = writer.toString();
            entity = entity.replace("<omniBackRequirements", "<omniBackRequirements" + toAdd);
            return entity;
        }
        catch (JAXBException ex) {
            OrderMate.LOG.error("Cannot marshall Omniback requirements", (Throwable)ex);
            return null;
        }
    }
}

