/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.cloudback.nudge;

import au.com.ordermate.util.Pair;
import au.com.ordermate.xmlintegration.nudgeback.NudgeRequest;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.multipart.BodyPart;
import com.sun.jersey.multipart.FormDataMultiPart;
import com.sun.jersey.multipart.file.FileDataBodyPart;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.ws.rs.core.MediaType;
import ordermate.OrderMate;
import ordermate.database.integration.cloudback.CloudBackConfig;
import ordermate.database.integration.cloudback.CloudServerType;
import ordermate.integration.cloudback.CloudBackClient;
import ordermate.integration.cloudback.OMOutgoingServiceResponse;
import ordermate.integration.cloudback.OutgoingService;
import ordermate.integration.cloudback.nudge.NudgeUtil;
import ordermate.integration.cloudback.nudge.OMNudgeRequest;
import ordermate.integration.cloudback.nudge.OMNudgeRequestType;
import ordermate.misc.ObjectMarshaller;

public class NudgeBackClient
extends CloudBackClient
implements OutgoingService<OMNudgeRequest> {
    private final ObjectMarshaller marshaller = new ObjectMarshaller();
    static final String INVALID_NUDGE_REQUEST = "Invalid nudge request!";
    static final String EMPTY_REDBACK_STORE_ID = "Please set RedBack store id to call Nudge Cloud Server!";
    private static final String STORE_ID = "store_id";
    private static final String ENABLED = "enabled";
    private static final String AUTH = "Authorization";

    public NudgeBackClient() {
        super(CloudBackConfig.getCloudBackConfig(CloudServerType.Nudge));
    }

    public OMOutgoingServiceResponse execute(OMNudgeRequest omNudgeRequest) {
        if (omNudgeRequest == null || omNudgeRequest.getNudgeRequest() == null) {
            throw new IllegalArgumentException(INVALID_NUDGE_REQUEST);
        }
        NudgeRequest nudgeRequest = omNudgeRequest.getNudgeRequest();
        if (nudgeRequest.getStoreId() == 0L) {
            nudgeRequest.setStoreId(this.getRedBackId());
            if (nudgeRequest.getStoreId() == 0L) {
                throw new IllegalStateException(EMPTY_REDBACK_STORE_ID);
            }
        }
        String nudgeRequestJson = this.marshaller.marshal(nudgeRequest);
        if (omNudgeRequest.getRequestType() == OMNudgeRequestType.LINK_STORE) {
            return this.linkStore(nudgeRequestJson, nudgeRequest.getStoreId(), omNudgeRequest.isEnable());
        }
        return this.doNudgeOperation(omNudgeRequest, nudgeRequestJson);
    }

    private OMOutgoingServiceResponse doNudgeOperation(OMNudgeRequest omNudgeRequest, String nudgeRequestJson) {
        this.validateCloudConfigEnabled();
        if (omNudgeRequest.getFiles() != null && !omNudgeRequest.getFiles().isEmpty()) {
            return this.nudgeFiles(nudgeRequestJson, omNudgeRequest.getFiles());
        }
        return this.nudge(nudgeRequestJson);
    }

    private OMOutgoingServiceResponse linkStore(String nudgeRequestJson, Long storeId, boolean enabled) {
        NudgeUtil util = new NudgeUtil();
        WebResource.Builder resource = this.setupResource(util.getNudgeLinkStoreUrl(), new Pair[0]);
        ((WebResource.Builder)resource.accept(new String[]{"application/json"})).type("application/json");
        resource.header(AUTH, (Object)util.getNudgeAuth());
        resource.header(STORE_ID, (Object)storeId);
        resource.header(ENABLED, (Object)enabled);
        ClientResponse response = (ClientResponse)resource.post(ClientResponse.class, (Object)nudgeRequestJson);
        return this.getOMNudgeResponse(response);
    }

    private OMOutgoingServiceResponse nudge(String nudgeRequestJson) {
        WebResource.Builder resource = this.setupResource("customer/nudge", new Pair[0]);
        ((WebResource.Builder)resource.accept(new String[]{"application/json"})).type("application/json");
        ClientResponse response = (ClientResponse)resource.post(ClientResponse.class, (Object)nudgeRequestJson);
        return this.getOMNudgeResponse(response);
    }

    private OMOutgoingServiceResponse getOMNudgeResponse(ClientResponse response) {
        if (response.getStatus() / 100 == 2) {
            OrderMate.LOG.info("Received response " + (String)response.getEntity(String.class));
            return new OMOutgoingServiceResponse.OMOutgoingServiceResponseBuilder(true).build();
        }
        String responseMsg = (String)response.getEntity(String.class);
        OrderMate.LOG.warn("Unable to nudge request, response msg: " + responseMsg);
        return new OMOutgoingServiceResponse.OMOutgoingServiceResponseBuilder(false).message(responseMsg).build();
    }

    private static void close(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException e) {
                OrderMate.LOG.warn("Unable to close multi part while nudging files!", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OMOutgoingServiceResponse nudgeFiles(String nudgeRequestJson, List<File> files) {
        WebResource.Builder resource = this.setupResource("customer/files", new Pair[0]);
        FormDataMultiPart formDataMultiPart = new FormDataMultiPart();
        formDataMultiPart = formDataMultiPart.field("request", (Object)nudgeRequestJson, MediaType.APPLICATION_JSON_TYPE);
        for (File file : files) {
            formDataMultiPart.bodyPart((BodyPart)new FileDataBodyPart("files", file));
        }
        try {
            ClientResponse response = (ClientResponse)((WebResource.Builder)resource.type(MediaType.MULTIPART_FORM_DATA_TYPE)).post(ClientResponse.class, (Object)formDataMultiPart);
            OMOutgoingServiceResponse oMOutgoingServiceResponse = this.getOMNudgeResponse(response);
            return oMOutgoingServiceResponse;
        }
        finally {
            NudgeBackClient.close((Closeable)formDataMultiPart);
        }
    }
}

