/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.cloudback.nudge;

import au.com.ordermate.message.MessageServer;
import au.com.ordermate.persistence.PersistenceManager;
import ordermate.OrderMate;
import ordermate.database.integration.cloudback.CloudBackConfig;
import ordermate.database.integration.cloudback.CloudServerType;

public class NudgeHelper {
    public boolean setNudgeServiceAsDefault() {
        if (!MessageServer.getServer().isSmtpServerConfigured()) {
            CloudBackConfig nudgeConfig = this.getNudgeConfig();
            if (nudgeConfig == null) {
                return false;
            }
            if (!nudgeConfig.isEnabled()) {
                this.enableNudge(true);
            }
            return true;
        }
        return false;
    }

    private CloudBackConfig getNudgeConfig() {
        return CloudBackConfig.getCloudBackConfig(CloudServerType.Nudge);
    }

    public boolean enableNudge(boolean enable) {
        try {
            OrderMate.LOG.info("Setting Nudge as the default mail service " + enable);
            CloudBackConfig nudgeConfig = this.getNudgeConfig();
            nudgeConfig.setEnabled(enable);
            PersistenceManager.save(nudgeConfig);
            return true;
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Setting Nudge as default SMTP service failed ", (Throwable)ex);
            return false;
        }
    }
}

