/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.cloudback.nudge;

import au.com.ordermate.message.Email;
import au.com.ordermate.message.SMS;
import au.com.ordermate.util.StringUtils;
import au.com.ordermate.xmlintegration.nudgeback.NudgeMail;
import au.com.ordermate.xmlintegration.nudgeback.NudgeMailUnit;
import au.com.ordermate.xmlintegration.nudgeback.NudgeRequest;
import au.com.ordermate.xmlintegration.nudgeback.NudgeSMS;
import au.com.ordermate.xmlintegration.nudgeback.NudgeSMSUnit;
import java.util.Arrays;
import javax.mail.internet.InternetAddress;
import ordermate.database.integration.cloudback.CloudBackConfig;
import ordermate.database.integration.cloudback.CloudServerType;
import ordermate.database.misc.BusinessInfo;
import ordermate.database.misc.SystemCurrentInfo;
import ordermate.integration.cloudback.CloudBackClientFactory;
import ordermate.integration.cloudback.OMOutgoingServiceResponse;
import ordermate.integration.cloudback.nudge.NudgeBackClient;
import ordermate.integration.cloudback.nudge.OMNudgeRequest;
import ordermate.integration.cloudback.nudge.OMNudgeRequestType;

public class NudgeManager {
    private NudgeBackClient nudgeClient = (NudgeBackClient)CloudBackClientFactory.createCloudBackClient(CloudServerType.Nudge);
    private static volatile NudgeManager instance = null;

    private NudgeManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static NudgeManager getInstance() {
        if (instance != null) return instance;
        Class<NudgeManager> clazz = NudgeManager.class;
        synchronized (NudgeManager.class) {
            if (instance != null) return instance;
            instance = new NudgeManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public OMOutgoingServiceResponse sendEmail(Email email) {
        NudgeRequest nudgeRequest = new NudgeRequest();
        long redbackId = SystemCurrentInfo.getInstance().getRedbackId();
        NudgeMail nudgeMail = new NudgeMail();
        InternetAddress[] senders = email.getSenders();
        String from = senders != null && senders.length > 0 ? senders[0].getAddress() : null;
        nudgeMail.setFrom(from);
        NudgeMailUnit mailUnit = new NudgeMailUnit();
        mailUnit.setRecipientsTO(this.getAddresses(email.getToRecipients()));
        mailUnit.setRecipientsCC(this.getAddresses(email.getCcRecipients()));
        mailUnit.setRecipientsBCC(this.getAddresses(email.getBccRecipients()));
        mailUnit.setSubject(email.getSubject());
        if (StringUtils.startsWithIgnoreCase(email.getText(), "<Html")) {
            mailUnit.setHtmlContent(email.getText());
        } else {
            mailUnit.setTextContent(email.getText());
        }
        nudgeMail.getMailUnits().add(mailUnit);
        nudgeRequest.setMail(nudgeMail);
        nudgeRequest.setStoreId(redbackId);
        OMNudgeRequest omNudgeRequest = new OMNudgeRequest.OMNudgeRequestBuilder(nudgeRequest).storeId(String.valueOf(redbackId)).files(Arrays.asList(email.getAttachments())).build();
        return this.nudgeClient.execute(omNudgeRequest);
    }

    public OMOutgoingServiceResponse sendSMS(SMS sms) {
        NudgeRequest nudgeRequest = new NudgeRequest();
        long redbackId = SystemCurrentInfo.getInstance().getRedbackId();
        NudgeSMS nudgeSMS = new NudgeSMS();
        nudgeSMS.setFrom(BusinessInfo.getInstance().getName());
        NudgeSMSUnit smsUnit = new NudgeSMSUnit();
        smsUnit.setPhoneNumber(sms.getPhoneNumber());
        smsUnit.setMessage(sms.getText());
        nudgeSMS.getSmsUnits().add(smsUnit);
        nudgeRequest.setSms(nudgeSMS);
        nudgeRequest.setStoreId(redbackId);
        OMNudgeRequest omNudgeRequest = new OMNudgeRequest.OMNudgeRequestBuilder(nudgeRequest).storeId(String.valueOf(redbackId)).build();
        return this.nudgeClient.execute(omNudgeRequest);
    }

    public OMOutgoingServiceResponse linkStore(Long storeId, boolean enable) {
        NudgeRequest nudgeRequest = new NudgeRequest();
        nudgeRequest.setStoreId(storeId.longValue());
        nudgeRequest.setPriority(Boolean.valueOf(enable));
        OMNudgeRequest omNudgeRequest = new OMNudgeRequest.OMNudgeRequestBuilder(nudgeRequest).requestType(OMNudgeRequestType.LINK_STORE).enable(enable).build();
        return this.nudgeClient.execute(omNudgeRequest);
    }

    private String getAddresses(InternetAddress[] internetAddresses) {
        StringBuilder sb = new StringBuilder();
        for (InternetAddress internetAddress : internetAddresses) {
            sb.append(internetAddress.getAddress()).append(",");
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    void setNudgeClient(NudgeBackClient nudgeClient) {
        this.nudgeClient = nudgeClient;
    }

    public static boolean isNudgeConfigured() {
        CloudBackConfig nudgeConfig = CloudBackConfig.getCloudBackConfig(CloudServerType.Nudge);
        return nudgeConfig != null && nudgeConfig.isEnabled();
    }
}

