/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.cloudback.nudge;

import au.com.ordermate.xmlintegration.nudgeback.NudgeRequest;
import java.io.File;
import java.util.List;
import ordermate.integration.cloudback.OutgoingServiceRequest;
import ordermate.integration.cloudback.nudge.OMNudgeRequestType;

public class OMNudgeRequest
implements OutgoingServiceRequest {
    private final NudgeRequest nudgeRequest;
    private final List<File> files;
    private final String storeId;
    private OMNudgeRequestType requestType = OMNudgeRequestType.NUDGE;
    private final boolean enable;

    private OMNudgeRequest(OMNudgeRequestBuilder builder) {
        this.nudgeRequest = builder.nudgeRequest;
        this.files = builder.files;
        this.storeId = builder.storeId;
        this.requestType = builder.requestType;
        this.enable = builder.enable;
    }

    public NudgeRequest getNudgeRequest() {
        return this.nudgeRequest;
    }

    public List<File> getFiles() {
        return this.files;
    }

    public String getStoreId() {
        return this.storeId;
    }

    public OMNudgeRequestType getRequestType() {
        return this.requestType;
    }

    public boolean isEnable() {
        return this.enable;
    }

    public static class OMNudgeRequestBuilder {
        private final NudgeRequest nudgeRequest;
        private List<File> files;
        private String storeId;
        private OMNudgeRequestType requestType = OMNudgeRequestType.NUDGE;
        private boolean enable = false;

        public OMNudgeRequestBuilder(NudgeRequest nudgeRequest) {
            this.nudgeRequest = nudgeRequest;
        }

        public OMNudgeRequestBuilder files(List<File> files) {
            this.files = files;
            return this;
        }

        public OMNudgeRequestBuilder storeId(String storeId) {
            this.storeId = storeId;
            return this;
        }

        public OMNudgeRequestBuilder requestType(OMNudgeRequestType type) {
            this.requestType = type;
            return this;
        }

        public OMNudgeRequestBuilder enable(boolean enable) {
            this.enable = enable;
            return this;
        }

        public OMNudgeRequest build() {
            return new OMNudgeRequest(this);
        }
    }
}

