/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.cloudback.redback;

import au.com.ordermate.util.Pair;
import au.com.ordermate.xmlintegration.ccpos.CCSyncMessage;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.core.Response;
import ordermate.OrderMate;
import ordermate.database.integration.cloudback.CloudBackConfig;
import ordermate.database.integration.cloudback.CloudServerType;
import ordermate.database.misc.SystemCurrentInfo;
import ordermate.integration.cloudback.CloudBackClient;
import ordermate.integration.cloudback.omni.OmniCommonResourceAPI;
import org.apache.logging.log4j.Level;
import org.json.JSONArray;
import org.json.JSONObject;

public class RedBackClient
extends CloudBackClient
implements OmniCommonResourceAPI {
    private static final String PARAM_UPDATEMATE_ID = "updatemateId";
    private static final String PARAM_RED_BACK_ID = "redBackId";

    public RedBackClient() {
        super(CloudBackConfig.getCloudBackConfig(CloudServerType.RedBack));
        try {
            this.validateCloudConfigEnabled();
        }
        catch (Exception ex) {
            OrderMate.LOG.log(Level.WARN, "Cannot validate redback cloud connection", (Throwable)ex);
        }
        this.setTimeout(10000);
    }

    public Map<String, Object> getStoreTags() {
        HashMap<String, Object> tags = new HashMap<String, Object>();
        long redbackId = SystemCurrentInfo.getInstance().getRedbackId();
        if (redbackId <= 0L) {
            OrderMate.LOG.warn("Cannot get Store Tags, no redback ID " + redbackId);
            return tags;
        }
        ClientResponse response = null;
        try {
            response = (ClientResponse)this.setupResource("common/storeNag", this.createQueryParam(PARAM_RED_BACK_ID, redbackId)).get(ClientResponse.class);
        }
        catch (Exception ex) {
            OrderMate.LOG.warn("Couldn't hit redback server to retrieve tags", (Throwable)ex);
            return tags;
        }
        String value = (String)response.getEntity(String.class);
        if (response.getStatus() == Response.Status.OK.getStatusCode()) {
            try {
                JSONArray array = new JSONArray(value);
                for (int i = 0; i < array.length(); ++i) {
                    JSONObject tag = array.getJSONObject(i);
                    String key = tag.getString("name");
                    if (tag.has("value")) {
                        tag.put(key, tag.get("value"));
                        continue;
                    }
                    if (!tag.has("values")) continue;
                    tag.put(key, tag.get("values"));
                }
            }
            catch (Exception e) {
                OrderMate.LOG.warn("Couldn't decipher store tags from: " + value, (Throwable)e);
            }
        } else {
            OrderMate.LOG.warn("RedBack gave a bad response for store tags: " + value + " atatus " + response.getStatus());
        }
        return tags;
    }

    @Override
    public Long getRedBackId(long updatemateId) {
        ClientResponse response = (ClientResponse)this.setupResource("common/getRedbackId", this.createQueryParam(PARAM_UPDATEMATE_ID, updatemateId)).get(ClientResponse.class);
        if (response.getStatus() == Response.Status.OK.getStatusCode()) {
            String value = "N/A";
            try {
                value = (String)response.getEntity(String.class);
                return Long.valueOf(value);
            }
            catch (Exception e) {
                OrderMate.LOG.warn("Couldn't get RedBack ID from response: " + value, (Throwable)e);
                return null;
            }
        }
        OrderMate.LOG.warn("Failed to update RedBack ID! Response from server: " + (String)response.getEntity(String.class));
        return null;
    }

    @Override
    public boolean getRedBackStoreNagFlag(long redBackID) {
        ClientResponse response = null;
        try {
            response = (ClientResponse)this.setupResource("common/storeNag", this.createQueryParam(PARAM_RED_BACK_ID, redBackID)).get(ClientResponse.class);
        }
        catch (Exception ex) {
            OrderMate.LOG.warn("Couldn't hit redback server to get Store Nag Flag", (Throwable)ex);
            return false;
        }
        String value = (String)response.getEntity(String.class);
        if (response.getStatus() == Response.Status.OK.getStatusCode()) {
            try {
                return Boolean.parseBoolean(value);
            }
            catch (Exception e) {
                OrderMate.LOG.warn("Couldn't get RedBack nag flag from response: " + value, (Throwable)e);
                return false;
            }
        }
        OrderMate.LOG.warn("Failed to update RedBack nag flag! Response from server: " + value);
        return false;
    }

    @Override
    public CCSyncMessage getRedBackLatestTos() {
        ClientResponse response = null;
        try {
            response = (ClientResponse)((WebResource.Builder)this.setupResource("common/latestTos", new Pair[0]).accept(new String[]{"application/json"})).get(ClientResponse.class);
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Cannot get latest terms of service from RedBack", (Throwable)ex);
            return null;
        }
        if (response.getStatus() == Response.Status.OK.getStatusCode()) {
            try {
                return (CCSyncMessage)response.getEntity(CCSyncMessage.class);
            }
            catch (Exception e) {
                OrderMate.LOG.warn("Couldn't get ToS from RedBack.", (Throwable)e);
                return null;
            }
        }
        OrderMate.LOG.warn("Failed to update RedBack Terms of Service! Response from server: " + (String)response.getEntity(String.class));
        return null;
    }
}

