/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.controlcenter;

import au.com.ordermate.util.JSONUtil;
import au.com.ordermate.xmlintegration.ccpos.CCSyncMessage;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import java.util.List;
import ordermate.OrderMate;
import ordermate.integration.controlcenter.ControlCenterSync;
import ordermate.integration.controlcenter.ControlCenterSyncFactory;
import org.json.JSONObject;

public class ControlCenterRequest {
    private static final String CC_AGENT_HEADER = "CCAgent";
    private static final String AUTHORIZATION_HEADER = "Authorization";
    private static final String STORE_ID_HEADER = "StoreId";
    private static final String CONTENT_TYPE = "Content-Type";
    private static final String STORE_ENDPOINT = "store/get_storedetails";

    public ClientResponse requestLinkStore(String email) {
        String endpoint = "usermanagement/request_link";
        ControlCenterSync sync = ControlCenterSyncFactory.getControlCenterSync();
        WebResource resource = sync.getCCWebResource("usermanagement/request_link");
        try {
            ClientResponse response = (ClientResponse)((WebResource.Builder)resource.queryParam("email", email).header(CC_AGENT_HEADER, (Object)sync.getCCAgent()).header(AUTHORIZATION_HEADER, (Object)sync.getAuthorization())).get(ClientResponse.class);
            if (response.getClientResponseStatus() != ClientResponse.Status.OK) {
                OrderMate.LOG.info("Response from CC: " + response + "\n" + response.getStatus());
            }
            return response;
        }
        catch (ClientHandlerException e) {
            OrderMate.LOG.error("Server is down.");
            return new ClientResponse(ClientResponse.Status.SERVICE_UNAVAILABLE.getStatusCode(), null, null, null);
        }
    }

    public ClientResponse getStoreDetails(Long storeId) {
        String endpoint = STORE_ENDPOINT;
        ControlCenterSync sync = ControlCenterSyncFactory.getControlCenterSync();
        WebResource resource = sync.getCCWebResource(endpoint);
        try {
            ClientResponse response = (ClientResponse)((WebResource.Builder)((WebResource.Builder)((WebResource.Builder)resource.header(STORE_ID_HEADER, (Object)String.valueOf(storeId)).header(CC_AGENT_HEADER, (Object)sync.getCCAgent())).header(CONTENT_TYPE, (Object)"application/json")).header(AUTHORIZATION_HEADER, (Object)sync.getAuthorization())).get(ClientResponse.class);
            return response;
        }
        catch (ClientHandlerException e) {
            OrderMate.LOG.error("Error while trying to retrieve store details", (Throwable)e);
            return new ClientResponse(ClientResponse.Status.SERVICE_UNAVAILABLE.getStatusCode(), null, null, null);
        }
    }

    public ClientResponse doLinkStore(String email, String pin) {
        String endpoint = "usermanagement/grant_link";
        ControlCenterSync sync = ControlCenterSyncFactory.getControlCenterSync();
        WebResource resource = sync.getCCWebResource("usermanagement/grant_link");
        try {
            ClientResponse response = (ClientResponse)((WebResource.Builder)resource.queryParam("pin", pin).queryParam("email", email).queryParam("storeId", String.valueOf(sync.getStoreId())).header(CC_AGENT_HEADER, (Object)sync.getCCAgent()).header(AUTHORIZATION_HEADER, (Object)sync.getAuthorization())).get(ClientResponse.class);
            OrderMate.LOG.info("Response from CC: " + response + "\n" + (String)response.getEntity(String.class));
            return response;
        }
        catch (ClientHandlerException e) {
            OrderMate.LOG.info("Server is down.");
            return new ClientResponse(ClientResponse.Status.SERVICE_UNAVAILABLE.getStatusCode(), null, null, null);
        }
    }

    public ClientResponse linkNewUser(String userName, String email) {
        String endpoint = "usermanagement/link_newuser";
        ControlCenterSync sync = ControlCenterSyncFactory.getControlCenterSync();
        WebResource resource = sync.getCCWebResource("usermanagement/link_newuser");
        try {
            String entityString = this.createUser(userName, email);
            ClientResponse response = (ClientResponse)((WebResource.Builder)((WebResource.Builder)((WebResource.Builder)resource.header(AUTHORIZATION_HEADER, (Object)sync.getAuthorization()).header(CC_AGENT_HEADER, (Object)sync.getCCAgent())).header(CONTENT_TYPE, (Object)"application/xml")).entity((Object)entityString)).post(ClientResponse.class);
            if (response.getClientResponseStatus() != ClientResponse.Status.OK) {
                OrderMate.LOG.info("Response from CC: " + response + "\n" + (String)response.getEntity(String.class));
            }
            return response;
        }
        catch (ClientHandlerException e) {
            OrderMate.LOG.error("Server is down.");
            return new ClientResponse(ClientResponse.Status.SERVICE_UNAVAILABLE.getStatusCode(), null, null, null);
        }
    }

    public ClientResponse updateStore(List<CCSyncMessage> posSyncMessages, long storeId) throws Exception {
        String endpoint = "admin/update_store";
        ControlCenterSync sync = ControlCenterSyncFactory.getControlCenterSync();
        WebResource resource = sync.getCCWebResource("admin/update_store");
        String entityStr = JSONUtil.toJson(posSyncMessages);
        ClientResponse response = (ClientResponse)((WebResource.Builder)((WebResource.Builder)((WebResource.Builder)resource.queryParam("storeId", String.valueOf(storeId)).header(AUTHORIZATION_HEADER, (Object)sync.getAuthorization()).header(CC_AGENT_HEADER, (Object)sync.getCCAgent())).header(CONTENT_TYPE, (Object)"application/json")).entity((Object)entityStr)).put(ClientResponse.class);
        if (response.getClientResponseStatus() != ClientResponse.Status.OK) {
            throw new Exception("Response from CC: " + response + "\n" + (String)response.getEntity(String.class));
        }
        return response;
    }

    public String getPin(ClientResponse response) {
        try {
            JSONObject json = this.getJSONFromResponse(response);
            return (String)json.get("pin");
        }
        catch (Exception ex) {
            OrderMate.LOG.error(ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    public JSONObject getJSONFromResponse(ClientResponse response) {
        try {
            JSONObject json = new JSONObject((String)response.getEntity(String.class));
            return json;
        }
        catch (Exception ex) {
            OrderMate.LOG.error(ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    private String createUser(String userName, String email) {
        StringBuilder sb = new StringBuilder();
        sb.append("<User Name='");
        sb.append(userName);
        sb.append("' Email='");
        sb.append(email);
        sb.append("' />");
        return sb.toString();
    }

    public ClientResponse requestForgotPassword(String email) {
        String endpoint = "password/request_password_reset";
        ControlCenterSync sync = ControlCenterSyncFactory.getControlCenterSync();
        WebResource resource = sync.getCCWebResource("password/request_password_reset");
        try {
            ClientResponse response = (ClientResponse)((WebResource.Builder)((WebResource.Builder)resource.queryParam("email", email).header(CC_AGENT_HEADER, (Object)sync.getCCAgent()).header(AUTHORIZATION_HEADER, (Object)sync.getAuthorization())).header(STORE_ID_HEADER, (Object)sync.getStoreId())).put(ClientResponse.class);
            OrderMate.LOG.info("Response from CC: " + response + "\n" + (String)response.getEntity(String.class));
            return response;
        }
        catch (ClientHandlerException e) {
            OrderMate.LOG.error("Server is down.");
            return new ClientResponse(ClientResponse.Status.SERVICE_UNAVAILABLE.getStatusCode(), null, null, null);
        }
    }
}

