/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.csv;

import au.com.bytecode.opencsv.CSVWriter;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import ordermate.OrderMate;
import ordermate.integration.exportmapping.ImportExportMapping;

public class CSVExporter {
    private ImportExportMapping mapping;
    private String error = "";
    private Map meta;

    public CSVExporter(ImportExportMapping newMapping) {
        this.mapping = newMapping;
        this.error = "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createExportFile(String fileName, String encoding, List<String[]> data) {
        FileOutputStream fout = null;
        OutputStreamWriter writer = null;
        try {
            boolean retVal;
            fout = new FileOutputStream(fileName);
            writer = encoding != null ? new OutputStreamWriter((OutputStream)fout, encoding) : new OutputStreamWriter(fout);
            boolean bl = retVal = this.writeExportToBuffer(writer, data);
            return bl;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            this.error = ex.getMessage();
            boolean bl = false;
            return bl;
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException ex) {
                    OrderMate.LOG.warn("Error closing file writer", (Throwable)ex);
                }
            }
        }
    }

    public boolean createExportFile(String fileName, String encoding) {
        return this.createExportFile(fileName, encoding, null);
    }

    public boolean createExportFile(String fileName) {
        return this.createExportFile(fileName, null);
    }

    public boolean writeExportToBuffer(Writer writer) throws IOException {
        return this.writeExportToBuffer(writer, null);
    }

    public boolean writeExportToBuffer(Writer writer, List<String[]> data) throws IOException {
        this.error = "";
        BufferedWriter bufferedWriter = new BufferedWriter(writer);
        this.mapping.doBeforeWrittingMappings(bufferedWriter);
        CSVWriter csvWriter = new CSVWriter((Writer)bufferedWriter, this.mapping.getSeperatorChar(), this.mapping.getQuoteChar(), this.mapping.getLineEnd());
        this.insertMetadata(csvWriter);
        List header = this.mapping.getHeader();
        csvWriter.writeNext(header.toArray(new String[header.size()]));
        if (data != null) {
            csvWriter.writeAll(data);
        } else {
            csvWriter.writeAll(this.getData());
        }
        csvWriter.close();
        return true;
    }

    private List<String[]> getData() {
        ArrayList<String[]> data = new ArrayList<String[]>(this.mapping.size());
        while (this.mapping.hasNext()) {
            Object next = this.mapping.next();
            if (next instanceof List) {
                List record = (List)next;
                if (!record.isEmpty()) {
                    data.addAll(record);
                }
                if (!this.mapping.isEmptyLineBetweenSets() || record.isEmpty()) continue;
                data.add(new String[]{""});
                continue;
            }
            if (next instanceof String[]) {
                data.add((String[])next);
                continue;
            }
            if (next == null) continue;
            throw new IllegalStateException("Next was not a list or string[] " + next.getClass());
        }
        return data;
    }

    public String getError() {
        return this.error;
    }

    public void setMetadata(Map metadata) {
        this.meta = metadata;
    }

    private void insertMetadata(CSVWriter csvWriter) {
        if (this.meta != null) {
            StringBuilder sb = new StringBuilder("#");
            for (Map.Entry entry : this.meta.entrySet()) {
                if (sb.length() > 1) {
                    sb.append(";");
                }
                sb.append(entry.getKey());
                sb.append("=");
                sb.append(entry.getValue());
            }
            String[] metaString = new String[]{sb.toString()};
            csvWriter.writeNext(metaString);
        }
    }

    public ImportExportMapping getMapping() {
        return this.mapping;
    }
}

