/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.csv;

import au.com.ordermate.util.StringUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import ordermate.integration.csv.CsvImportException;
import ordermate.integration.exportmapping.ExportTemplate;

public class CsvIterator {
    private final ExportTemplate template;
    private final Collection rows;
    private final Iterator iterator;
    private String[] row;
    private final String[] headersName;
    private final ExportTemplate.Field[] fields;
    private final int[] columnsMap;
    private boolean found;
    private int rowNumber = 0;
    private final Map meta = new TreeMap();

    public CsvIterator(ExportTemplate template, Collection rows) throws CsvImportException {
        this.template = template;
        this.rows = rows;
        this.iterator = rows.iterator();
        this.headersName = new String[template.getFieldsNumber()];
        this.fields = new ExportTemplate.Field[template.getFieldsNumber()];
        this.columnsMap = new int[template.getFieldsNumber()];
        int ix = 0;
        for (ExportTemplate.Field field : template.getFields()) {
            this.headersName[ix] = field.toString();
            this.fields[ix] = field;
            ++ix;
        }
        while (this.iterator.hasNext() && !this.found) {
            this.row = (String[])this.iterator.next();
            ++this.rowNumber;
            if (this.isRowEmpty()) continue;
            if (this.row[0].startsWith("#")) {
                this.mapMetaData();
                continue;
            }
            this.mapHeader();
            if (this.found) continue;
            throw new CsvImportException("Incorrect header in " + Arrays.toString(this.row));
        }
        if (!this.found) {
            throw new CsvImportException("Header not found.");
        }
        for (int i = 0; i < this.fields.length; ++i) {
            if (!this.fields[i].isRequired() || this.columnsMap[i] >= 0) continue;
            throw new CsvImportException("The required column " + this.fields[i].toString() + " has not been found in the header.");
        }
    }

    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    public void next() {
        this.row = (String[])this.iterator.next();
        ++this.rowNumber;
    }

    public String get(String columnName) {
        for (int ix = 0; ix < this.template.getFieldsNumber(); ++ix) {
            if (!this.headersName[ix].equals(columnName)) continue;
            if (this.columnsMap[ix] < 0 || this.columnsMap[ix] >= this.row.length) {
                return null;
            }
            return this.row[this.columnsMap[ix]].trim();
        }
        return null;
    }

    public int getRowNumber() {
        return this.rowNumber;
    }

    public boolean isRowEmpty() {
        for (int i = 0; i < this.row.length; ++i) {
            if (this.row[i] != null && this.row[i].trim().isEmpty()) continue;
            return false;
        }
        return true;
    }

    private void mapHeader() throws CsvImportException {
        this.found = false;
        for (int j = 0; j < this.template.getFieldsNumber(); ++j) {
            this.columnsMap[j] = -1;
        }
        block1: for (int i = 0; i < this.row.length; ++i) {
            while (this.row[i].length() > 0 && StringUtils.isUTFCharacter(this.row[i].charAt(0))) {
                this.row[i] = this.row[i].substring(1);
            }
            this.row[i] = this.row[i].trim();
            for (int j = 0; j < this.template.getFieldsNumber(); ++j) {
                if (!this.row[i].equalsIgnoreCase(this.headersName[j])) continue;
                if (this.columnsMap[j] >= 0) {
                    throw new CsvImportException("The column " + this.row[i] + " is mapped twice.");
                }
                this.columnsMap[j] = i;
                this.found = true;
                continue block1;
            }
        }
    }

    public void checkRowValid() throws CsvImportException {
        for (int i = 0; i < this.fields.length; ++i) {
            if (!this.fields[i].isRequired() || this.row.length > this.columnsMap[i] && this.row[this.columnsMap[i]] != null && !this.row[this.columnsMap[i]].trim().isEmpty()) continue;
            throw new CsvImportException("The column " + this.fields[i] + " in row " + this.rowNumber + " is missing.");
        }
    }

    public String dumpRow() {
        return Arrays.toString(this.row);
    }

    public String getMetadata(String key) {
        return (String)this.meta.get(key);
    }

    private void mapMetaData() {
        String metaString = this.row[0].substring(1);
        StringTokenizer st = new StringTokenizer(metaString, ";");
        while (st.hasMoreTokens()) {
            String token = st.nextToken().trim();
            if (token.isEmpty()) continue;
            int indexOfEqual = token.indexOf("=");
            if (indexOfEqual < 0) {
                this.meta.put(token, "");
                continue;
            }
            this.meta.put(token.substring(0, indexOfEqual), token.substring(indexOfEqual + 1, token.length()));
        }
    }
}

