/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.csv;

import au.com.ordermate.guicore.task.AbstractTask;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import ordermate.OrderMate;
import ordermate.database.inventory.InventoryGroup;
import ordermate.database.inventory.InventoryProfile;
import ordermate.database.inventory.PriceLevel;
import ordermate.database.stock.StockArea;
import ordermate.integration.csv.CSVExporter;
import ordermate.integration.menuitem.MenuExportMapping;
import ordermate.integration.menuitem.MenuStockItemSummary;
import ordermate.integration.menuitem.MenuStockItemSummaryManager;

public class CsvMenuExportTask
extends AbstractTask {
    private final InventoryProfile profile;
    private final PriceLevel priceLevel;
    private final InventoryGroup group;
    private final String fileName;
    private final StockArea stockArea;
    private final boolean willGenerateId;
    private final String targetVersion;
    private boolean includeMeta;

    public CsvMenuExportTask(InventoryProfile aProfile, PriceLevel aPriceLevel, InventoryGroup aGroup, StockArea aStockArea, String aFileName, boolean generateId, String aVersion, boolean includeMetadata) {
        this.profile = aProfile;
        this.priceLevel = aPriceLevel;
        this.group = aGroup;
        this.fileName = aFileName;
        this.stockArea = aStockArea;
        this.willGenerateId = generateId;
        this.targetVersion = aVersion;
        this.includeMeta = includeMetadata;
    }

    @Override
    protected int getTotalSubTasks() {
        return 1;
    }

    @Override
    public String getName() {
        return "Exporting the menu";
    }

    @Override
    public void performTask() throws Exception {
        MenuStockItemSummaryManager manager = new MenuStockItemSummaryManager(this.profile, this.priceLevel, this.stockArea, this.group);
        List list = manager.getResultList();
        if (this.willGenerateId) {
            this.setIdentifier(list);
        }
        MenuExportMapping menuMapping = new MenuExportMapping(list, this.targetVersion);
        CSVExporter exporter = new CSVExporter(menuMapping);
        if (this.includeMeta) {
            exporter.setMetadata(this.getMetadata());
        }
        exporter.createExportFile(this.fileName, "UTF-8");
    }

    private Map getMetadata() {
        TreeMap<String, String> retValue = new TreeMap<String, String>();
        if (this.targetVersion.equalsIgnoreCase("current")) {
            retValue.put("version", OrderMate.VERSION);
        } else {
            retValue.put("version", this.targetVersion);
        }
        retValue.put("profile", this.profile.getLabel());
        retValue.put("price level", this.priceLevel.getLabel());
        retValue.put("area", this.stockArea.getLabel());
        return retValue;
    }

    private void setIdentifier(List list) {
        for (MenuStockItemSummary summary : list) {
            summary.generateIdentifier();
        }
    }
}

