/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.csv;

import au.com.ordermate.configuration.Config;
import au.com.ordermate.guicore.task.AbstractTask;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.util.MathsUtils;
import au.com.ordermate.util.Price;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import ordermate.OrderMate;
import ordermate.database.config.MeasureUnit;
import ordermate.database.config.MeasureUnitHelper;
import ordermate.database.config.Quantity;
import ordermate.database.hardware.PrinterGroup;
import ordermate.database.inventory.InventoryItemUnit;
import ordermate.database.inventory.InventoryProfile;
import ordermate.database.inventory.ItemSummary;
import ordermate.database.inventory.ItemSummaryException;
import ordermate.database.inventory.ItemSummaryManager;
import ordermate.database.inventory.PriceLevel;
import ordermate.database.misc.BarcodeUtils;
import ordermate.database.misc.SystemCurrentInfo;
import ordermate.database.queries.stock.StockItemQueries;
import ordermate.database.stock.StockArea;
import ordermate.database.stock.StockGroup;
import ordermate.database.stock.StockItem;
import ordermate.database.stock.StockOnHand;
import ordermate.database.stock.StockSupplier;
import ordermate.database.stock.usagelink.StockInventoryUsageLink;
import ordermate.integration.csv.CsvImportException;
import ordermate.integration.csv.CsvIterator;
import ordermate.integration.exportmapping.ExportTemplate;
import ordermate.integration.menuitem.MenuExportTemplate;
import stockmate.database.interfaces.stock.MeasureUnitI;

public class CsvMenuImportTask
extends AbstractTask {
    private final List csvData;
    private InventoryProfile profile;
    private PriceLevel priceLevel;
    private StockArea stockArea;
    private boolean warnOnDuplicateBarcodes;
    private ItemSummaryManager manager;
    private final ExportTemplate template = new MenuExportTemplate();
    private CsvIterator iterator;
    private final Map<Long, List<Long>> stockLinking = new HashMap<Long, List<Long>>();

    public CsvMenuImportTask(List aCsvData) {
        this.csvData = aCsvData;
        this.warnOnDuplicateBarcodes = false;
    }

    public void setPriceLevel(PriceLevel level) {
        this.priceLevel = level;
    }

    public PriceLevel getPriceLevel() {
        return this.priceLevel;
    }

    public void setProfile(InventoryProfile invProfile) {
        this.profile = invProfile;
    }

    public InventoryProfile getProfile() {
        return this.profile;
    }

    public void setStockArea(StockArea area) {
        this.stockArea = area;
    }

    public StockArea getStockArea() {
        return this.stockArea;
    }

    public void setWarnOnDuplicateBarcodes(boolean warn) {
        this.warnOnDuplicateBarcodes = warn;
    }

    public boolean isWarnOnDuplicateBarcodes() {
        return this.warnOnDuplicateBarcodes;
    }

    public CsvMenuImportTask(List newCsvData, InventoryProfile newLinkProfile, PriceLevel newLinkPriceLevel, StockArea newStockArea, boolean newWarnOnDuplicateBarcodes) {
        this.csvData = newCsvData;
        this.profile = newLinkProfile;
        this.priceLevel = newLinkPriceLevel;
        this.stockArea = newStockArea;
        this.warnOnDuplicateBarcodes = newWarnOnDuplicateBarcodes;
    }

    @Override
    public String getName() {
        return "Import menu";
    }

    @Override
    public int getTotalSubTasks() {
        return this.csvData.size();
    }

    @Override
    public void performTask() throws CsvImportException {
        this.iterator = new CsvIterator(this.template, this.csvData);
        this.initialize();
        this.manager = new ItemSummaryManager(this.priceLevel, this.profile);
        try {
            this.manager.setIterator(this.iterator);
            while (this.iterator.hasNext()) {
                this.iterator.next();
                this.emitProgress();
                if (this.iterator.isRowEmpty()) continue;
                this.processRow();
            }
            this.tearDownLinks();
        }
        catch (ItemSummaryException ex) {
            String message = "The imported file has an error at line " + this.iterator.getRowNumber() + ": " + ex.getLocalizedMessage();
            throw new CsvImportException(message, ex);
        }
        this.emitProgress();
        SystemCurrentInfo.setMenuUpdate("CSV Import Menu");
    }

    private Quantity getIngredientQuantity(String ingredientQuantity, StockItem stockItem) throws CsvImportException {
        Quantity ingredientUsageQty;
        if (ingredientQuantity != null && !ingredientQuantity.isEmpty()) {
            try {
                ingredientUsageQty = Quantity.parseQuantity(ingredientQuantity);
            }
            catch (NumberFormatException e) {
                throw new CsvImportException("An error occured while parsing ingredient quantity '" + ingredientQuantity + "' in row number " + this.iterator.getRowNumber());
            }
        } else {
            ingredientUsageQty = new Quantity(stockItem.getDisplayMeasureUnitContainer().getQuantityPerContainer());
        }
        return ingredientUsageQty;
    }

    private void initialize() {
        String metadata;
        if (this.profile == null && (metadata = this.iterator.getMetadata("profile")) != null) {
            this.profile = InventoryProfile.findProfile(metadata);
        }
        if (this.profile == null) {
            this.profile = InventoryProfile.getAllProfiles().get(0);
        }
        if (this.priceLevel == null && (metadata = this.iterator.getMetadata("price level")) != null) {
            this.priceLevel = PriceLevel.findPriceLevel(metadata);
        }
        if (this.priceLevel == null) {
            this.priceLevel = PriceLevel.getAllPriceLevels().get(0);
        }
        if (this.stockArea == null && (metadata = this.iterator.getMetadata("area")) != null) {
            this.stockArea = StockArea.getStockArea(metadata);
        }
        if (this.stockArea == null) {
            if (StockArea.getStockAreas().isEmpty()) {
                throw new IllegalStateException("Cannot import, no stock areas setup");
            }
            this.stockArea = StockArea.getStockAreas().get(0);
        }
        this.stockLinking.clear();
    }

    private boolean isNonEmpty(boolean hasStockCell, String value) {
        if (hasStockCell) {
            return hasStockCell;
        }
        return value != null && !value.isEmpty();
    }

    private void processRow() throws CsvImportException, ItemSummaryException {
        List<Long> links;
        Quantity ingredientUsageQty;
        String itemName;
        ItemSummary itemSummary = null;
        String state = "ACTIVE";
        if (this.createItem(this.iterator.get("Price"), this.iterator.get("Size"))) {
            itemSummary = this.manager.convertToItemSummary();
            if (this.iterator.get("Printer Group").isEmpty()) {
                itemSummary.setPrinterGroup(PrinterGroup.getPrinterGroups().get(0));
            }
            itemSummary.save();
            state = itemSummary.getSystemState();
        }
        StockItem stockItem = null;
        String ingredientQuantity = this.iterator.get("Ingredient Quantity");
        if (itemSummary != null && this.isNonEmpty(false, ingredientQuantity) && this.stockLinking.get(itemSummary.getInventoryItemUnitObject().getID()) == null) {
            this.stockLinking.put(itemSummary.getInventoryItemUnitObject().getID(), new ArrayList());
        }
        boolean hasStockCell = false;
        String identifier = this.iterator.get("Stock Identifier");
        hasStockCell = this.isNonEmpty(hasStockCell, identifier);
        String stockName = this.iterator.get("Stock Name");
        hasStockCell = this.isNonEmpty(hasStockCell, stockName);
        String purchaseCost = this.iterator.get("Purchase Cost");
        hasStockCell = this.isNonEmpty(hasStockCell, purchaseCost);
        String displayMeasure = this.iterator.get("Display measure");
        hasStockCell = this.isNonEmpty(hasStockCell, displayMeasure);
        String ingredientMeasure = this.iterator.get("Ingredient measure");
        hasStockCell = this.isNonEmpty(hasStockCell, ingredientMeasure);
        String outerName = this.iterator.get("Outer name");
        hasStockCell = this.isNonEmpty(hasStockCell, outerName);
        String outerQuantity = this.iterator.get("Outer quantity");
        hasStockCell = this.isNonEmpty(hasStockCell, outerQuantity);
        String purchaseQty = this.iterator.get("Purchase Quantity");
        hasStockCell = this.isNonEmpty(hasStockCell, purchaseQty);
        String supplierName = this.iterator.get("Supplier");
        hasStockCell = this.isNonEmpty(hasStockCell, supplierName);
        String prodCode = this.iterator.get("Supplier code");
        hasStockCell = this.isNonEmpty(hasStockCell, prodCode);
        String stockGroupCol = this.iterator.get("Stock Group");
        hasStockCell = this.isNonEmpty(hasStockCell, stockGroupCol);
        String stockBarcodes = this.iterator.get("Stock Barcode");
        hasStockCell = this.isNonEmpty(hasStockCell, stockBarcodes);
        String minQty = this.iterator.get("Min stock");
        hasStockCell = this.isNonEmpty(hasStockCell, minQty);
        String maxQty = this.iterator.get("Max stock");
        hasStockCell = this.isNonEmpty(hasStockCell, maxQty);
        String stockOnHandValue = this.iterator.get("Stock on hand");
        hasStockCell = this.isNonEmpty(hasStockCell, stockOnHandValue);
        String isTaxIncluded = this.iterator.get("Include Tax");
        if (!(hasStockCell = this.isNonEmpty(hasStockCell, isTaxIncluded))) {
            return;
        }
        Integer stockIdentifier = this.getStockIdentifier(identifier);
        stockItem = this.getStockItemByIdentifier(stockIdentifier);
        if (stockItem == null && stockName != null && !stockName.isEmpty()) {
            stockItem = StockItemQueries.getStockItemForName(stockName);
        } else if (stockItem != null && stockName != null && !stockItem.getName().equals(stockName)) {
            OrderMate.LOG.info("Name for the stock item " + stockItem + " will be " + stockName);
        }
        if (stockItem == null && (stockName == null || stockName.isEmpty()) && (itemName = this.iterator.get("Name")) != null && !itemName.isEmpty()) {
            stockName = itemName;
            stockItem = StockItemQueries.getStockItemForName(stockName);
        }
        if (stockItem != null && state.equals("DELETED")) {
            Quantity soh = stockItem.getTotalStockOnHand();
            if (!MathsUtils.approxGreaterThan(soh.getRawValue(), 0.0)) {
                stockItem.delete();
            }
            return;
        }
        if (stockItem == null) {
            if (stockName == null || stockName.isEmpty()) {
                itemName = this.iterator.get("Name");
                if (itemName == null || itemName.isEmpty()) {
                    throw new CsvImportException("No name for stock item at line " + this.iterator.getRowNumber() + ", cannot create the stock for [" + this.iterator.dumpRow() + "].");
                }
                stockName = itemName;
            }
            if (purchaseCost == null || purchaseCost.isEmpty()) {
                throw new CsvImportException("No purchase cost for the stock item " + stockName + " at line " + this.iterator.getRowNumber() + ", cannot create the stock for [" + this.iterator.dumpRow() + "].");
            }
            if (stockGroupCol == null || stockGroupCol.isEmpty()) {
                String itemGroupName = this.iterator.get("Group");
                if (itemGroupName == null || itemGroupName.isEmpty()) {
                    throw new CsvImportException("No stock group for the stock item " + stockName + " at line " + this.iterator.getRowNumber() + ", cannot create the stock for [" + this.iterator.dumpRow() + "].");
                }
                stockGroupCol = itemGroupName;
            }
        }
        boolean wasCreation = false;
        if (stockItem == null) {
            if (purchaseCost == null || purchaseCost.isEmpty()) {
                throw new CsvImportException("Purchase Cost must be filled for the new stock item in row " + this.iterator.getRowNumber());
            }
            stockItem = new StockItem();
            wasCreation = true;
        }
        this.setStockName(stockName, stockItem);
        this.setPurchase(purchaseCost, isTaxIncluded, displayMeasure, purchaseQty, stockItem);
        this.setIngredientMeasure(ingredientMeasure, stockItem);
        this.setOuterQuantity(outerQuantity, stockItem);
        this.setOuterName(outerName, outerQuantity, stockItem);
        this.setStockGroup(stockGroupCol, stockItem);
        this.setStockSupplier(supplierName, prodCode, stockItem);
        this.setStockBarcodes(stockBarcodes, stockItem);
        this.setMinQty(minQty, stockItem);
        this.setMaxQty(maxQty, stockItem);
        if (stockIdentifier != null) {
            stockItem.setStockIdentifier(stockIdentifier);
        }
        stockItem.save();
        if (wasCreation) {
            this.setStockOnHand(stockOnHandValue, stockItem);
        }
        if (itemSummary != null && (ingredientUsageQty = this.getIngredientQuantity(ingredientQuantity, stockItem)) != null) {
            itemSummary.setStockUsage(stockItem, ingredientUsageQty);
            itemSummary.save();
        }
        if (itemSummary != null && (links = this.stockLinking.get(itemSummary.getInventoryItemUnitObject().getID())) != null) {
            links.add(stockItem.getID());
        }
    }

    private boolean createItem(String price, String size) {
        return price.length() != 0 && size.length() != 0;
    }

    private String getBarcode(String string, StockItem item) throws CsvImportException {
        List stockItems;
        String barcode = BarcodeUtils.stripBarcodeDelimiter(string.trim());
        if (string.equals("")) {
            return "";
        }
        for (String currentCode : item.getBarcodes()) {
            if (!currentCode.equals(barcode)) continue;
            return "";
        }
        if (this.warnOnDuplicateBarcodes && !(stockItems = StockItemQueries.getStockItemsForBarcode(barcode)).isEmpty()) {
            throw new CsvImportException("Found " + stockItems.size() + " stock items that already use the barcode " + barcode);
        }
        return barcode;
    }

    private void setIngredientMeasure(String ingredientMeasure, StockItem stockItem) throws CsvImportException {
        if (ingredientMeasure != null && !ingredientMeasure.isEmpty()) {
            if (!Config.getBooleanValue("ignoreCSVCheck") && stockItem.isPersistent() && !stockItem.getIngredientMeasureUnit().getName().equals(ingredientMeasure)) {
                OrderMate.LOG.info("Ingredient measure ignored for existing stock item at row " + this.iterator.getRowNumber());
                return;
            }
            MeasureUnit ingredientUnit = MeasureUnitHelper.wrangleMeasureUnit(ingredientMeasure);
            MeasureUnitI displayUnit = stockItem.getDisplayMeasureUnit();
            if (displayUnit.getScale().equals(ingredientUnit.getScale())) {
                stockItem.setIngredientMeasureUnit(ingredientUnit);
            } else {
                throw new CsvImportException("Ingredient measure [" + ingredientUnit.getName() + "] and Display measure [" + displayUnit.getName() + "] do not match on row " + this.iterator.getRowNumber());
            }
        }
    }

    private void setMaxQty(String maxQty, StockItem stockItem) throws CsvImportException {
        if (maxQty != null && !maxQty.isEmpty()) {
            try {
                Quantity max = Quantity.parseQuantity(maxQty);
                max = max.multiply(stockItem.getDisplayMeasureUnitContainer().getMultiplier());
                stockItem.setSuggestedMax(this.stockArea, max);
            }
            catch (NumberFormatException e) {
                throw new CsvImportException("An error occured while parsing suggested max ordering quantity '" + maxQty + "' in row number " + this.iterator.getRowNumber());
            }
        }
    }

    private void setMinQty(String minQty, StockItem stockItem) throws CsvImportException {
        if (minQty != null && !minQty.isEmpty()) {
            try {
                Quantity min = Quantity.parseQuantity(minQty);
                min = min.multiply(stockItem.getDisplayMeasureUnitContainer().getMultiplier());
                stockItem.setSuggestedMin(this.stockArea, min);
            }
            catch (NumberFormatException e) {
                throw new CsvImportException("An error occured while parsing suggested min ordering quantity '" + minQty + "' in row number " + this.iterator.getRowNumber());
            }
        }
    }

    private void setPurchase(String cost, String isTax, String displayMeasure, String quantity, StockItem stockItem) throws CsvImportException {
        MeasureUnit displayUnit;
        if ((cost = cost.replaceAll(",", "")) != null && !cost.isEmpty()) {
            Price costPrice;
            try {
                costPrice = Price.parsePrice(cost);
            }
            catch (NumberFormatException n) {
                throw new CsvImportException("Cannot parse cost '" + cost + "' in row number " + this.iterator.getRowNumber());
            }
            stockItem.setCurrentCost(costPrice);
        }
        if (stockItem.isPersistent() && (quantity != null && !quantity.isEmpty() || displayMeasure != null && !displayMeasure.isEmpty() || isTax != null && !isTax.isEmpty())) {
            OrderMate.LOG.debug("Tax included, display measure, purchase qty ignored in row" + this.iterator.getRowNumber());
            return;
        }
        if (isTax != null && !isTax.isEmpty()) {
            boolean isTaxIncluded = Boolean.parseBoolean(isTax);
            stockItem.setTaxIncluded(isTaxIncluded);
        }
        if ((displayUnit = MeasureUnitHelper.wrangleMeasureUnit(displayMeasure)) == null) {
            throw new CsvImportException("Unknown measure unit at row " + this.iterator.getRowNumber() + ": '" + displayMeasure + "'. Format '<container> <amount><measure>' eg: 'Bottle 375mL'");
        }
        String container = MeasureUnitHelper.wrangleMeasureContainer(displayMeasure);
        double qtyPer = MeasureUnitHelper.wrangleQtyPerUnit(displayMeasure);
        double purchaseQty = 1.0;
        if (quantity != null && !quantity.isEmpty()) {
            try {
                purchaseQty = Double.parseDouble(quantity) * qtyPer;
            }
            catch (NumberFormatException e) {
                throw new CsvImportException("An error occured while parsing purchase quantity '" + quantity + "' in row number " + this.iterator.getRowNumber());
            }
        }
        stockItem.setPurchaseQty(new Quantity(displayUnit, purchaseQty, false));
        stockItem.getDisplayMeasureUnitContainer().setMeasureContainer(MeasureUnitHelper.getContainerForName(container, true));
        stockItem.getDisplayMeasureUnitContainer().setQuantityPerContainer(qtyPer);
    }

    private void setStockBarcodes(String stockBarcodes, StockItem stockItem) throws CsvImportException {
        String barcode;
        if (stockBarcodes != null && !(barcode = this.getBarcode(stockBarcodes, stockItem)).isEmpty()) {
            stockItem.addBarcode(barcode);
        }
    }

    private void setStockName(String stockName, StockItem stockItem) {
        stockItem.setName(stockName);
    }

    private void setStockOnHand(String stockOnHandValue, StockItem stockItem) throws CsvImportException {
        if (stockOnHandValue != null && !stockOnHandValue.isEmpty()) {
            Quantity stockOnHand = null;
            try {
                stockOnHand = Quantity.parseQuantity(stockOnHandValue);
                stockOnHand = stockOnHand.multiply(stockItem.getDisplayMeasureUnitContainer().getMultiplier());
            }
            catch (NumberFormatException e) {
                throw new CsvImportException("An error occured while parsing stock on hand '" + stockOnHandValue + "' in row number " + this.iterator.getRowNumber());
            }
            StockOnHand soh = StockOnHand.getSOHForItemAndArea(stockItem, this.stockArea);
            if (soh == null) {
                soh = new StockOnHand(stockItem, this.stockArea);
            }
            if (soh.getQuantity() != 0.0 && Config.isDebuging()) {
                throw new CsvImportException("The " + stockItem + " stock quantity of " + soh.getQuantity() + " should not be set to " + stockOnHandValue + " in row number " + this.iterator.getRowNumber());
            }
            soh.setTotalQuantity(stockOnHand.getRawValue());
            soh.saveChild();
        }
    }

    private void setStockSupplier(String name, String prodCode, StockItem stockItem) {
        if (name == null || name.isEmpty()) {
            return;
        }
        StockSupplier supplier = StockSupplier.getSupplierForName(name);
        if (supplier == null) {
            supplier = new StockSupplier();
            supplier.setName(name);
            supplier.setAddress1("");
            supplier.setAddress2("");
            supplier.setPhone("");
            supplier.setFax("");
            supplier.setEmail("");
        }
        if (supplier != null) {
            if (!supplier.isPersistent()) {
                supplier.save();
            }
            stockItem.clearSuppliers();
            if (prodCode == null || prodCode.isEmpty()) {
                stockItem.addSupplier(supplier);
            } else {
                stockItem.addSupplier(supplier, prodCode);
            }
        }
    }

    private void setStockGroup(String name, StockItem stockItem) {
        if (name == null || name.isEmpty()) {
            return;
        }
        StockGroup upperGroup = null;
        StringTokenizer st = new StringTokenizer(name, "/\\");
        while (st.hasMoreTokens()) {
            String group = st.nextToken().trim();
            StockGroup stockGroup = StockGroup.getStockGroupForName(group);
            if (stockGroup == null) {
                stockGroup = new StockGroup();
                stockGroup.setLabel(group);
                stockGroup.save();
            }
            if (upperGroup != null && !stockGroup.isSubGroupOf(upperGroup)) {
                stockGroup.setParentGroup(upperGroup);
                stockGroup.save();
            }
            upperGroup = stockGroup;
        }
        stockItem.setStockGroup(upperGroup);
    }

    private Integer getStockIdentifier(String identifier) throws CsvImportException {
        if (identifier == null || identifier.isEmpty()) {
            return null;
        }
        Integer stockId = null;
        try {
            stockId = new Integer(identifier);
        }
        catch (NumberFormatException e) {
            throw new CsvImportException("An error occured while parsing integer value of stock identifier '" + identifier + "' in row number " + this.iterator.getRowNumber(), e);
        }
        return stockId;
    }

    private StockItem getStockItemByIdentifier(Integer identifier) {
        if (identifier == null) {
            return null;
        }
        return StockItemQueries.getStockItemsForIdentifier(identifier);
    }

    private void setOuterName(String outerName, String outerQuantity, StockItem stockItem) {
        if (outerName != null && !outerName.isEmpty() && outerQuantity != null && !outerQuantity.isEmpty()) {
            stockItem.setOuterName(outerName);
        }
    }

    private void setOuterQuantity(String outerQuantity, StockItem stockItem) throws CsvImportException {
        if (outerQuantity != null && !outerQuantity.isEmpty()) {
            double outerQtyInt = 0.0;
            try {
                outerQtyInt = Double.parseDouble(outerQuantity);
            }
            catch (NumberFormatException n) {
                throw new CsvImportException("Cannot parse outer quantity '" + outerQuantity + "' in row number " + this.iterator.getRowNumber());
            }
            stockItem.setOuterQuantity(outerQtyInt);
        }
    }

    private void tearDownLinks() {
        for (Map.Entry<Long, List<Long>> entry : this.stockLinking.entrySet()) {
            List<Long> links = entry.getValue();
            Long id = entry.getKey();
            InventoryItemUnit unit = PersistenceManager.getByID(id, InventoryItemUnit.class);
            List<StockInventoryUsageLink> stockInventoryUsageLinks = unit.getStockInventoryUsageLinks();
            for (StockInventoryUsageLink link : stockInventoryUsageLinks) {
                if (links.contains(link.getStockItem().getID())) continue;
                link.deleteChild();
            }
        }
    }
}

