/*
 * Decompiled with CFR 0.152.
 */
package ordermate.integration.diamondback;

import au.com.diamondback.xmlintegration.report.DiamondAccountAmountSummary;
import au.com.diamondback.xmlintegration.report.DiamondAccountCountSummary;
import au.com.diamondback.xmlintegration.report.DiamondAccountSummary;
import au.com.diamondback.xmlintegration.report.DiamondPaymentAmountSummary;
import au.com.diamondback.xmlintegration.report.DiamondPaymentCountSummary;
import au.com.diamondback.xmlintegration.report.DiamondPaymentSummary;
import au.com.diamondback.xmlintegration.report.DiamondSummaryReport;
import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.util.JSONUtil;
import au.com.ordermate.util.Price;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import ordermate.OrderMate;
import ordermate.database.finance.Shift;
import ordermate.database.finance.priceadjustment.PriceAdjustmentDirection;
import ordermate.database.finance.priceadjustment.SalesPriceAdjustment;
import ordermate.database.finance.reconciliation.ShiftReconciliation;
import ordermate.database.finance.transactions.FinanceTransaction;
import ordermate.database.misc.EventLogRecord;
import ordermate.database.misc.TradingDay;
import ordermate.database.queries.misc.TradingDayQueries;
import ordermate.database.queries.sales.AccountQueries;
import ordermate.database.reports.general.NumberReport;
import ordermate.database.sales.Account;
import ordermate.database.sales.AccountState;
import ordermate.database.sales.SalesComponent;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.SalesItemQuantity;
import ordermate.database.sales.SalesLineItem;
import ordermate.database.users.User;

public class DiamondBackDataHelper {
    private DiamondSummaryReport getDiamondSummaryReport() {
        DiamondSummaryReport summaryReport = new DiamondSummaryReport();
        DiamondAccountSummary accSummary = new DiamondAccountSummary();
        summaryReport.setAccountSummary(accSummary);
        DiamondAccountCountSummary accCountSummary = new DiamondAccountCountSummary();
        accSummary.setCountSummary(accCountSummary);
        DiamondAccountAmountSummary accAmountSummary = new DiamondAccountAmountSummary();
        accAmountSummary.setClosed(BigDecimal.ZERO);
        accAmountSummary.setCompleted(BigDecimal.ZERO);
        accAmountSummary.setDeleted(BigDecimal.ZERO);
        accAmountSummary.setFullyRefunded(BigDecimal.ZERO);
        accAmountSummary.setOpen(BigDecimal.ZERO);
        accAmountSummary.setPartiallyRefunded(BigDecimal.ZERO);
        accAmountSummary.setTotal(BigDecimal.ZERO);
        accSummary.setAmountSummary(accAmountSummary);
        DiamondPaymentSummary paymentSummary = new DiamondPaymentSummary();
        summaryReport.setPaymentSummary(paymentSummary);
        DiamondPaymentCountSummary paymentCountSummary = new DiamondPaymentCountSummary();
        paymentSummary.setCountSummary(paymentCountSummary);
        DiamondPaymentAmountSummary paymentAmountSummary = new DiamondPaymentAmountSummary();
        paymentAmountSummary.setDiscounts(BigDecimal.ZERO);
        paymentAmountSummary.setSurcharges(BigDecimal.ZERO);
        paymentAmountSummary.setTips(BigDecimal.ZERO);
        paymentAmountSummary.setTotal(BigDecimal.ZERO);
        paymentSummary.setAmountSummary(paymentAmountSummary);
        return summaryReport;
    }

    private long getNumberOfNoSales() {
        NumberReport report = PersistenceManager.getObject(NumberReport.class, Query.count(EventLogRecord.class, "value").select(EventLogRecord.Properties.ID, "ID").equals(EventLogRecord.Properties.TRADING_DAY, TradingDay.getCurrentTradingDay()).equals(EventLogRecord.Properties.TYPE, "No Sale").toString());
        return report.getValue();
    }

    private void summarizePriceAdjustments(List<SalesPriceAdjustment> priceAdjustments, DiamondSummaryReport diamondSummaryReport) {
        for (SalesPriceAdjustment adj : priceAdjustments) {
            DiamondPaymentCountSummary paymentCountSummary = diamondSummaryReport.getPaymentSummary().getCountSummary();
            DiamondPaymentAmountSummary paymentAmountSummary = diamondSummaryReport.getPaymentSummary().getAmountSummary();
            PriceAdjustmentDirection direction = adj.getDirection();
            if (PriceAdjustmentDirection.DISCOUNT.equals(direction)) {
                Price discountAmount = adj.getSavedValue();
                paymentCountSummary.setDiscounts(paymentCountSummary.getDiscounts() + 1L);
                paymentAmountSummary.setDiscounts(paymentAmountSummary.getDiscounts().add(discountAmount.toBigDecimal()));
                continue;
            }
            if (!PriceAdjustmentDirection.SURCHARGE.equals(direction)) continue;
            Price surchargeAmount = adj.getSavedValue();
            paymentCountSummary.setSurcharges(paymentCountSummary.getSurcharges() + 1L);
            paymentAmountSummary.setSurcharges(paymentAmountSummary.getSurcharges().add(surchargeAmount.toBigDecimal()));
        }
    }

    private BigDecimal getTotalTips(TradingDay tradingDay) {
        List<Shift> shifts = PersistenceManager.getObjectList(Shift.class, Query.select(Shift.class).equals(Shift.Properties.TRADING_DAY, tradingDay).toString());
        BigDecimal tipsTotal = BigDecimal.ZERO;
        for (Shift shift : shifts) {
            ShiftReconciliation rec = new ShiftReconciliation(shift, User.getSystemUser());
            Price shiftTips = rec.getSystemTipsTotal();
            tipsTotal = tipsTotal.add(shiftTips.toBigDecimal());
        }
        return tipsTotal;
    }

    private void summarizeTransactions(List<FinanceTransaction> trans, DiamondSummaryReport diamondSummaryReport, Account account) {
        DiamondPaymentCountSummary paymentCountSummary = diamondSummaryReport.getPaymentSummary().getCountSummary();
        paymentCountSummary.setTransactions(paymentCountSummary.getTransactions() + (long)trans.size());
        for (FinanceTransaction tran : trans) {
            DiamondPaymentAmountSummary paymentAmountSummary = diamondSummaryReport.getPaymentSummary().getAmountSummary();
            paymentAmountSummary.setTotal(paymentAmountSummary.getTotal().add(tran.getPaid().toBigDecimal()));
        }
    }

    public DiamondSummaryReport createDiamondBackSummaryReport(TradingDay tradingDay) {
        TradingDay tday = tradingDay;
        if (tday == null) {
            tday = TradingDayQueries.getLastClosedTradingDay();
        }
        DiamondSummaryReport diamondSummaryReport = this.getDiamondSummaryReport();
        Date startDT = tradingDay.getOpenDateTime();
        Date endDT = tradingDay.getCloseDateTime();
        diamondSummaryReport.setFromDate(startDT != null ? startDT.getTime() : 0L);
        diamondSummaryReport.setToDate(endDT != null ? endDT.getTime() : 0L);
        this.createPaymentSummary(tradingDay, diamondSummaryReport);
        this.createAccountSummary(tradingDay, diamondSummaryReport);
        OrderMate.LOG.info("Sending DiamondBackSummaryReport for Trading Day " + tday + ".\n" + JSONUtil.toJson(diamondSummaryReport));
        return diamondSummaryReport;
    }

    private void createAccountSummary(TradingDay tradingDay, DiamondSummaryReport diamondSummaryReport) {
        List<Account> accs = AccountQueries.getAllAccounts(tradingDay);
        DiamondAccountSummary accountSummary = diamondSummaryReport.getAccountSummary();
        accountSummary.getCountSummary().setTotal((long)accs.size());
        accountSummary.getCountSummary().setNoSale(this.getNumberOfNoSales());
        for (Account account : accs) {
            this.summariseAccount(account, accountSummary);
        }
    }

    private void createPaymentSummary(TradingDay tradingDay, DiamondSummaryReport diamondSummaryReport) {
        List<Account> closedAccs = AccountQueries.getClosedAccounts(tradingDay);
        for (Account account : closedAccs) {
            List<FinanceTransaction> trans = account.getAllFinanceTransactions();
            List<SalesPriceAdjustment> priceAdjustments = account.getPriceAdjustments();
            this.summarizePriceAdjustments(priceAdjustments, diamondSummaryReport);
            this.summarizeTransactions(trans, diamondSummaryReport, account);
        }
        BigDecimal totalTips = this.getTotalTips(tradingDay);
        diamondSummaryReport.getPaymentSummary().getAmountSummary().setTips(totalTips);
    }

    private void summariseAccount(Account account, DiamondAccountSummary accountSummary) {
        DiamondAccountCountSummary accountCountSummary = accountSummary.getCountSummary();
        DiamondAccountAmountSummary accountAmountSummary = accountSummary.getAmountSummary();
        if (AccountState.CLOSED == account.getAccountState()) {
            if (this.isRefund(account)) {
                this.summariseRefund(account, accountSummary);
            } else if (account.getItems().isEmpty()) {
                boolean isVoid = true;
                for (FinanceTransaction tran : account.getFinanceTransactions()) {
                    if (tran.getPaid().isZero()) continue;
                    isVoid = false;
                }
                if (isVoid) {
                    accountCountSummary.setDeleted(accountCountSummary.getDeleted() + 1L);
                    this.summariseVoid(account, accountSummary);
                }
            } else {
                accountCountSummary.setCompleted(accountCountSummary.getCompleted() + 1L);
                accountAmountSummary.setCompleted(accountAmountSummary.getCompleted().add(account.getPaid().toBigDecimal()));
            }
            accountCountSummary.setClosed(accountCountSummary.getClosed() + 1L);
            accountAmountSummary.setClosed(accountAmountSummary.getClosed().add(account.getPaid().toBigDecimal()));
        } else {
            accountCountSummary.setOpen(accountCountSummary.getOpen() + 1L);
        }
        accountAmountSummary.setTotal(accountAmountSummary.getTotal().add(account.getPaid().toBigDecimal()));
    }

    private boolean isRefund(Account account) {
        List<SalesItemQuantity> qtys = AccountQueries.getRefundQuantities(account);
        return !qtys.isEmpty();
    }

    private void summariseRefund(Account account, DiamondAccountSummary accountSummary) {
        BigDecimal refundedAmount = BigDecimal.ZERO;
        boolean isFullyRefuned = false;
        BigDecimal paidAmount = BigDecimal.ZERO;
        for (FinanceTransaction transaction : account.getFinanceTransactions()) {
            BigDecimal tranPaid = transaction.getPaid().toBigDecimal();
            paidAmount = paidAmount.add(tranPaid);
            if (BigDecimal.ZERO.compareTo(tranPaid) <= 0) continue;
            refundedAmount = refundedAmount.add(tranPaid);
        }
        if (BigDecimal.ZERO.compareTo(paidAmount) == 0) {
            isFullyRefuned = true;
        }
        DiamondAccountCountSummary accountCountSummary = accountSummary.getCountSummary();
        DiamondAccountAmountSummary accountAmountSummary = accountSummary.getAmountSummary();
        if (isFullyRefuned) {
            accountCountSummary.setFullyRefunded(accountCountSummary.getFullyRefunded() + 1L);
            accountAmountSummary.setFullyRefunded(accountAmountSummary.getFullyRefunded().add(refundedAmount));
        } else {
            accountCountSummary.setPartiallyRefunded(accountCountSummary.getPartiallyRefunded() + 1L);
            accountAmountSummary.setPartiallyRefunded(accountAmountSummary.getPartiallyRefunded().add(refundedAmount));
        }
    }

    private void summariseVoid(Account account, DiamondAccountSummary accountSummary) {
        ObjectQuery query = Query.select(SalesItemQuantity.class).linkUsing(SalesItemQuantity.Properties.SALES_LINE_ITEM, SalesItem.Properties.ID).whereFunction("sales_item_quantity.item_state IN ('DELETED', 'DELETED_WASTED')").equals(SalesLineItem.Properties.ACCOUNT, account).orderBy(SalesItemQuantity.Properties.ID);
        List<SalesItemQuantity> qtys = PersistenceManager.getObjectList(SalesItemQuantity.class, query.toString());
        BigDecimal deletedAmount = BigDecimal.ZERO;
        for (SalesItemQuantity qty : qtys) {
            SalesLineItem salesLineItem = qty.getSalesLineItem();
            SalesItem saleItem = salesLineItem.getSalesItems().get(0);
            SalesComponent salesComponent = saleItem.getComponentList().get(0);
            BigDecimal unitPrice = salesComponent.getSavedUnitPrice().toBigDecimal();
            BigDecimal amount = unitPrice.multiply(qty.getQuantity().getValue()).setScale(5, 6);
            deletedAmount = deletedAmount.add(amount);
        }
        DiamondAccountAmountSummary accountAmountSummary = accountSummary.getAmountSummary();
        accountAmountSummary.setDeleted(accountAmountSummary.getDeleted().add(deletedAmount));
    }
}

